/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.dao.factory;

import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.support.audit.plugin.dao.factory.BaseBuildTableService;
import java.sql.JDBCType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildHighGoTableServiceImpl
extends BaseBuildTableService {
    private final Logger log = LoggerFactory.getLogger(BuildHighGoTableServiceImpl.class);
    private Map<String, Consumer<ColumnInfoDto>> JDBC_TYPE_2_METHOD;

    private void init() {
        if (ObjectUtils.isEmpty(this.JDBC_TYPE_2_METHOD)) {
            HashMap<String, Consumer<ColumnInfoDto>> jdbcType2Method = new HashMap<String, Consumer<ColumnInfoDto>>();
            jdbcType2Method.put(JDBCType.CHAR.name(), action -> action.setDataType("char"));
            jdbcType2Method.put(JDBCType.VARCHAR.name(), action -> action.setDataType("varchar"));
            jdbcType2Method.put(JDBCType.TIMESTAMP.name(), action -> action.setDataType("TIMESTAMP"));
            jdbcType2Method.put(JDBCType.CLOB.name(), action -> action.setDataType("TEXT"));
            jdbcType2Method.put(JDBCType.INTEGER.name(), this::buildIntColumn);
            jdbcType2Method.put(JDBCType.BIGINT.name(), this::buildBigIntColumn);
            this.JDBC_TYPE_2_METHOD = jdbcType2Method;
        }
    }

    @Override
    public List<ColumnInfoDto> changeDataTypeByJDBCType(List<ColumnInfoDto> param) {
        this.init();
        return param.stream().peek(action -> {
            String jdbcType = action.getJdbcType();
            Consumer<ColumnInfoDto> columnInfoDtoConsumer = this.JDBC_TYPE_2_METHOD.get(jdbcType);
            if (ObjectUtils.isNull((Object[])new Object[]{columnInfoDtoConsumer})) {
                throw new IllegalStateException(String.format("\u6682\u4e0d\u652f\u6301\u7c7b\u578b%s", jdbcType));
            }
            columnInfoDtoConsumer.accept((ColumnInfoDto)action);
        }).collect(Collectors.toList());
    }

    @Override
    public boolean buildNewTableByOldTable(String newTableName, String oldTableName) {
        String createSql = String.format("CREATE TABLE %s (LIKE %s  INCLUDING ALL INCLUDING INDEXES);", newTableName, oldTableName);
        return this.quicklyBuildSql(createSql) || super.buildNewTableByOldTable(newTableName, oldTableName);
    }

    private void buildIntColumn(ColumnInfoDto config) {
        config.setDataType("numeric");
        config.setDataDot(Optional.ofNullable(config.getDataDot()).orElse(0));
    }

    private void buildBigIntColumn(ColumnInfoDto config) {
        config.setDataType("numeric");
        config.setDataDot(Optional.ofNullable(config.getDataDot()).orElse(0));
    }
}

