/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.dao.config;

import com.jxdinfo.hussar.platform.core.utils.date.format.DatePattern;
import com.jxdinfo.hussar.support.audit.core.support.cache.AuditLogThreadLocalCache;
import com.jxdinfo.hussar.support.audit.plugin.dao.action.DDLSqlBuildAction;
import com.jxdinfo.hussar.support.audit.plugin.dao.enums.CreateTableBuildEnum;
import com.jxdinfo.hussar.support.audit.plugin.dao.handler.AuditLogTableNameHandler;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.scheduling.annotation.Scheduled;

public class AutoCreateTables
implements ApplicationRunner {
    Logger log = LoggerFactory.getLogger(AutoCreateTables.class);
    @Autowired
    private AuditLogTableNameHandler auditLogTableNameHandler;

    public void run(ApplicationArguments args) throws Exception {
        this.createTableByTime(System.currentTimeMillis());
    }

    @Scheduled(cron="0 0 22 * * ?")
    public void scheduledCreateTables() {
        long targetTime = System.currentTimeMillis() + TimeUnit.DAYS.toMillis(1L);
        this.createTableByTime(targetTime);
    }

    private void createTableByTime(long time) {
        Map<String, DDLSqlBuildAction> tableName2Action = CreateTableBuildEnum.getAll();
        tableName2Action.forEach((tableName, action) -> {
            if ("month".equals(action.getSplitRole())) {
                this.createMonthTableByTime((String)tableName, time);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMonthTableByTime(String tableName, long time) {
        try {
            String suffix = DatePattern.SIMPLE_MONTH_FORMATTER.format(Instant.ofEpochMilli(time));
            AuditLogThreadLocalCache.setDynamicTableName((String)suffix);
            this.auditLogTableNameHandler.dynamicTableName("", tableName);
        }
        catch (Exception e) {
            this.log.error("\u63d0\u524d\u521b\u5efa\u8868\u540d\u79f0\u5931\u8d25", (Throwable)e);
        }
        finally {
            AuditLogThreadLocalCache.removeDynamicTableName();
        }
    }
}

