/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.dao.action;

import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.IndexInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.List;
import org.springframework.util.ObjectUtils;

public interface DDLSqlBuildAction {
    public static final int MAX_LENGTH = 30;
    public static final String MONTH = "month";
    public static final String MONTH_REGEX = "^\\d{4}(0[1-9]|1[0-2])$";

    public TableInfoDto getTableInfo();

    public List<ColumnInfoDto> getColumnInfoList();

    public List<IndexInfoDto> getIndexInfoList(String var1);

    default public String getNewTableName(String oldTableName, String suffix) {
        return oldTableName + "_" + suffix;
    }

    default public String getIndexName(String pre, String newTableName) {
        if (ObjectUtils.isEmpty((Object)pre)) {
            pre = "id_";
        }
        if (pre.length() >= 30) {
            return pre.substring(0, 30);
        }
        return pre + StringUtil.cutFromEnd((String)newTableName, (int)(30 - pre.length()));
    }

    default public String getSplitRole() {
        return MONTH;
    }
}

