/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.dao.service.impl;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.auditlog.entity.AuditLogEntity;
import com.jxdinfo.hussar.support.audit.core.auditlog.entity.AuditLogTableEntity;
import com.jxdinfo.hussar.support.audit.core.auditlog.service.AuditLogService;
import com.jxdinfo.hussar.support.audit.core.auditlog.vo.AuditLogItemVo;
import com.jxdinfo.hussar.support.audit.plugin.dao.mapper.AuditLogMapper;
import com.jxdinfo.hussar.support.audit.plugin.dao.service.AuditLogColumnService;
import com.jxdinfo.hussar.support.audit.plugin.dao.service.AuditLogTableService;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AuditLogServiceImpl
extends HussarServiceImpl<AuditLogMapper, AuditLogEntity>
implements AuditLogService {
    private static Logger LOGGER = LoggerFactory.getLogger(AuditLogServiceImpl.class);
    @Autowired
    private AuditLogTableService auditLogTableService;
    @Autowired
    private AuditLogColumnService auditLogColumnService;

    public void saveAuditLogDataChanges(List<AuditLogItemVo> auditLogItemVos) {
        if (HussarUtils.isEmpty(auditLogItemVos)) {
            LOGGER.warn("\u5ba1\u8ba1\u65e5\u5fd7\u6570\u636e\u53d8\u5316\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u4fdd\u5b58\u6570\u636e");
            return;
        }
        for (AuditLogItemVo auditLogItemVo : auditLogItemVos) {
            AuditLogTableEntity auditLogTable = auditLogItemVo.getAuditLogTable();
            this.auditLogTableService.save(auditLogTable);
            Set auditLogColumnSet = auditLogItemVo.getAuditLogColumnSet();
            if (HussarUtils.isNotEmpty((Object)auditLogColumnSet)) {
                auditLogColumnSet.stream().forEach(auditLogColumnEntity -> auditLogColumnEntity.setTableId(auditLogTable.getId()));
            }
            this.auditLogColumnService.saveBatchNoTransaction(auditLogColumnSet);
        }
    }
}

