/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.archive.utils;

import com.google.common.collect.Lists;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.archive.enums.ArchiveHotDataPeriodType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.List;

public class LocalDateTimeUtils {
    private LocalDateTimeUtils() {
    }

    public static List<YearMonth> getYearMonthList(LocalDateTime startTime, LocalDateTime endTime) {
        if (HussarUtils.isEmpty((Object)startTime) || HussarUtils.isEmpty((Object)endTime)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        if (startTime.isAfter(endTime)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        ArrayList yearMonths = Lists.newArrayListWithCapacity((int)12);
        YearMonth startYearMonth = YearMonth.from(startTime);
        YearMonth endYearMonth = YearMonth.from(endTime);
        while (startYearMonth.isBefore(endYearMonth)) {
            yearMonths.add(startYearMonth);
            startYearMonth = startYearMonth.plusMonths(1L);
        }
        yearMonths.add(endYearMonth);
        return yearMonths;
    }

    public static Integer getDaysOfMonth(LocalDateTime localDateTime) {
        if (HussarUtils.isEmpty((Object)localDateTime)) {
            return 0;
        }
        return YearMonth.from(localDateTime).lengthOfMonth();
    }

    public static Integer getDaysOfMonth(LocalDate localDate) {
        if (HussarUtils.isEmpty((Object)localDate)) {
            return 0;
        }
        return YearMonth.from(localDate).lengthOfMonth();
    }

    public static Integer getDaysOfMonth(YearMonth yearMonth) {
        if (HussarUtils.isEmpty((Object)yearMonth)) {
            return 0;
        }
        return yearMonth.lengthOfMonth();
    }

    public static LocalDateTime calculateDateTime(Integer num, Integer type) {
        if (ArchiveHotDataPeriodType.DAY.getCode().equals(type)) {
            return LocalDateTime.now().minusDays(num.intValue());
        }
        if (ArchiveHotDataPeriodType.MONTH.getCode().equals(type)) {
            return LocalDateTime.now().minusMonths(num.intValue());
        }
        if (ArchiveHotDataPeriodType.YEAR.getCode().equals(type)) {
            return LocalDateTime.now().minusYears(num.intValue());
        }
        return LocalDateTime.now();
    }
}

