/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.archive.service.impl;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.archive.service.RecoverService;
import com.jxdinfo.hussar.support.audit.core.archive.vo.ArchiveRecordVo;
import com.jxdinfo.hussar.support.audit.core.archive.vo.ArchiveRecoverVo;
import com.jxdinfo.hussar.support.audit.core.archive.vo.RecoverDataParam;
import com.jxdinfo.hussar.support.audit.plugin.archive.factory.RecoverHandlerFactory;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service(value="auditLogRecoverService")
@HussarDs(value="master")
public class AuditLogRecoverServiceImpl
implements RecoverService {
    @Async
    public void recoverData(RecoverDataParam recoverDataParam) {
        List archiveRecordVoList = recoverDataParam.getArchiveRecordVos();
        LocalDateTime dataStorageTime = recoverDataParam.getDataStorageTime();
        if (HussarUtils.isNotEmpty((Object)archiveRecordVoList) && HussarUtils.isNotEmpty((Object)dataStorageTime)) {
            for (ArchiveRecordVo archiveRecordVo : archiveRecordVoList) {
                String sourceTableName = archiveRecordVo.getSourceTableName();
                RecoverHandlerFactory.getRecoverHandler(sourceTableName).recover(archiveRecordVo, dataStorageTime);
            }
            return;
        }
        List archiveRecoverVos = recoverDataParam.getArchiveRecoverVos();
        for (ArchiveRecoverVo archiveRecoverVo : archiveRecoverVos) {
            String sourceTableName = archiveRecoverVo.getSourceTableName();
            RecoverHandlerFactory.getRecoverHandler(sourceTableName).recover(archiveRecoverVo);
        }
    }
}

