/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.handler;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.audit.core.archive.context.ArchiveTableNameContext;
import com.jxdinfo.hussar.support.audit.core.auditlog.entity.AuditLogTableEntity;
import com.jxdinfo.hussar.support.audit.plugin.archive.conditions.MybatisCondition;
import com.jxdinfo.hussar.support.audit.plugin.archive.factory.RecoverHandlerFactory;
import com.jxdinfo.hussar.support.audit.plugin.archive.handler.AbstractRecoverHandler;
import com.jxdinfo.hussar.support.audit.plugin.dao.service.AuditLogTableDaoService;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service(value="auditLogTableRecoverHandler")
@HussarDs(value="master")
@Conditional(value={MybatisCondition.class})
public class AuditLogTableRecoverHandler
extends AbstractRecoverHandler {
    private static final Logger logger = LoggerFactory.getLogger(AuditLogTableRecoverHandler.class);
    @Autowired
    private AuditLogTableDaoService auditLogTableDaoService;

    @Override
    protected long getSourceDataCount(LocalDateTime startTime, LocalDateTime endTime) {
        return this.auditLogTableDaoService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ge(HussarBaseEntity::getCreateTime, (Object)startTime)).le(HussarBaseEntity::getCreateTime, (Object)endTime));
    }

    @Override
    protected Long recoverColdDataByJson(String jsonFileContent) {
        List logTableEntities = JsonUtil.parseArray((String)jsonFileContent, AuditLogTableEntity.class);
        if (HussarUtils.isEmpty((Object)logTableEntities)) {
            return 0L;
        }
        logger.debug("\u6062\u590d\u51b7\u6570\u636e\uff0c\u6279\u91cf\u6062\u590d\u81f3\u5ba1\u8ba1\u65e5\u5fd7\u8868\u8bb0\u5f55");
        this.auditLogTableDaoService.saveBatchNoTransaction((Collection)logTableEntities);
        return logTableEntities.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long getArchiveDataCount(String tableName, LocalDateTime archiveStartupTime, LocalDateTime archiveEndTime) {
        try {
            ArchiveTableNameContext.setArchiveTableName((String)tableName);
            long l = this.auditLogTableDaoService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ge(HussarBaseEntity::getCreateTime, (Object)archiveStartupTime)).le(HussarBaseEntity::getCreateTime, (Object)archiveEndTime));
            return l;
        }
        finally {
            ArchiveTableNameContext.removeArchiveTableName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeArchiveTableData(String tableName, LocalDateTime archiveStartTime, LocalDateTime archiveEndTime) {
        try {
            ArchiveTableNameContext.setArchiveTableName((String)tableName);
            this.auditLogTableDaoService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ge(HussarBaseEntity::getCreateTime, (Object)archiveStartTime)).le(HussarBaseEntity::getCreateTime, (Object)archiveEndTime));
        }
        finally {
            ArchiveTableNameContext.removeArchiveTableName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void recoverWarmDataByDay(String tableName, YearMonth yearMonth, Integer day, Integer batchSize) {
        List auditLogTableEntities;
        logger.debug("\u5f00\u59cb\u6309\u5929\u6062\u590d\u5ba1\u8ba1\u65e5\u5fd7\u8868\u6e29\u6570\u636e");
        LocalDateTime startTime = LocalDateTime.of(yearMonth.getYear(), yearMonth.getMonth(), (int)day, 0, 0);
        LocalDateTime endTime = LocalDateTime.of(yearMonth.getYear(), yearMonth.getMonth(), (int)day, 23, 59, 59);
        try {
            ArchiveTableNameContext.setArchiveTableName((String)tableName);
            auditLogTableEntities = this.auditLogTableDaoService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ge(HussarBaseEntity::getCreateTime, (Object)startTime)).le(HussarBaseEntity::getCreateTime, (Object)endTime));
        }
        finally {
            ArchiveTableNameContext.removeArchiveTableName();
        }
        if (HussarUtils.isEmpty((Object)auditLogTableEntities)) {
            logger.debug("\u5ba1\u8ba1\u65e5\u5fd7\u8868\u5f52\u6863\u6062\u590d\u6570\u636e\u4e3a\u7a7a");
            return;
        }
        logger.debug("\u6309\u5929\u6062\u590d\u6e29\u6570\u636e\uff0c\u6279\u91cf\u6062\u590d\u81f3\u5ba1\u8ba1\u65e5\u5fd7\u8868\u8bb0\u5f55\uff0c\u6279\u91cf\u6570\u91cf\uff1a{}", (Object)batchSize);
        for (int i = 0; i < auditLogTableEntities.size(); i += batchSize.intValue()) {
            int endIndex = Math.min(i + batchSize, auditLogTableEntities.size());
            List batch = auditLogTableEntities.subList(i, endIndex);
            this.auditLogTableDaoService.saveBatchNoTransaction(batch);
        }
    }

    @Override
    public void registryRecoverHandler() {
        RecoverHandlerFactory.register("SYS_SUPPORT_AUDIT_LOG_TABLE", this);
    }
}

