/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.handler;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.FileUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.audit.core.archive.context.ArchiveTableNameContext;
import com.jxdinfo.hussar.support.audit.core.archive.enums.ArchiveDataType;
import com.jxdinfo.hussar.support.audit.plugin.archive.conditions.MybatisCondition;
import com.jxdinfo.hussar.support.audit.plugin.archive.factory.ArchiveHandlerFactory;
import com.jxdinfo.hussar.support.audit.plugin.archive.handler.AbstractArchiveHandler;
import com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.service.AuditLogTableArchiveDaoService;
import com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.service.DruidDynamicInserter;
import com.jxdinfo.hussar.support.audit.plugin.dao.service.AuditLogTableDaoService;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import java.io.File;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service(value="auditLogTableArchiveHandler")
@HussarDs(value="master")
@Conditional(value={MybatisCondition.class})
public class AuditLogTableArchiveHandler
extends AbstractArchiveHandler {
    private static final Logger logger = LoggerFactory.getLogger(AuditLogTableArchiveHandler.class);
    @Autowired
    private AuditLogTableDaoService auditLogTableDaoService;
    @Autowired
    private AuditLogTableArchiveDaoService auditLogTableArchiveDaoService;
    @Autowired
    private DruidDynamicInserter druidDynamicInserter;

    @Override
    public void registryArchiveHandler() {
        ArchiveHandlerFactory.registry("SYS_SUPPORT_AUDIT_LOG_TABLE", this);
    }

    @Override
    protected LocalDateTime getMinCreateTime(LocalDateTime startTime) {
        logger.debug("\u67e5\u8be2\u5ba1\u8ba1\u65e5\u5fd7\u8868\u6700\u5c0f\u521b\u5efa\u65f6\u95f4\uff0c\u5f00\u59cb\u65f6\u95f4\uff1a{}", (Object)startTime);
        return this.auditLogTableArchiveDaoService.selectMinCreateTime(startTime);
    }

    @Override
    protected Long getSourceDataCount(LocalDateTime startTime, LocalDateTime endTime) {
        logger.debug("\u67e5\u8be2\u5ba1\u8ba1\u65e5\u5fd7\u8868SYS_SUPPORT_AUDIT_LOG\u6570\u636e\u884c\u6570\uff0c\u5f00\u59cb\u65f6\u95f4\uff1a{}\uff0c\u7ed3\u675f\u65f6\u95f4\uff1a{}", (Object)startTime, (Object)endTime);
        return this.auditLogTableDaoService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ge(HussarBaseEntity::getCreateTime, (Object)startTime)).le(HussarBaseEntity::getCreateTime, (Object)endTime));
    }

    @Override
    protected void removeSourceData(LocalDateTime startTime, LocalDateTime endTime) {
        logger.debug("\u5220\u9664\u5ba1\u8ba1\u65e5\u5fd7\u8868SYS_SUPPORT_AUDIT_LOG\u6570\u636e\uff0c\u5f00\u59cb\u65f6\u95f4\uff1a{}\uff0c\u7ed3\u675f\u65f6\u95f4\uff1a{}", (Object)startTime, (Object)endTime);
        for (int i = 0; i < 3; ++i) {
            boolean flag;
            block3: {
                try {
                    flag = this.auditLogTableDaoService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ge(HussarBaseEntity::getCreateTime, (Object)startTime)).le(HussarBaseEntity::getCreateTime, (Object)endTime));
                }
                catch (Exception ex) {
                    logger.error("\u6e90\u6570\u636e\u8868\u6570\u636e\u5220\u9664\u5931\u8d25\uff0c", (Throwable)ex);
                    flag = false;
                    if (i != 2) break block3;
                    throw ex;
                }
            }
            if (!flag) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long getArchiveDataCount(String newTableName, LocalDateTime startTime, LocalDateTime endTime) {
        logger.debug("\u67e5\u8be2\u5ba1\u8ba1\u65e5\u5fd7\u5f52\u6863\u8868{}\u6570\u636e\u884c\u6570\uff0c\u5f00\u59cb\u65f6\u95f4\uff1a{}\uff0c\u7ed3\u675f\u65f6\u95f4\uff1a{}", new Object[]{newTableName, startTime, endTime});
        try {
            ArchiveTableNameContext.setArchiveTableName((String)newTableName);
            long l = this.auditLogTableDaoService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ge(HussarBaseEntity::getCreateTime, (Object)startTime)).le(HussarBaseEntity::getCreateTime, (Object)endTime));
            return l;
        }
        finally {
            ArchiveTableNameContext.removeArchiveTableName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void archiveColdDataByDay(String newTableName, File archiveFile, ArchiveDataType archiveDataType, LocalDateTime dayStartTime, LocalDateTime dayEndTime) {
        List auditLogTableEntities;
        try {
            if (archiveDataType == ArchiveDataType.WARM_DATA) {
                logger.debug("\u6309\u5929\u5f52\u6863\u5ba1\u8ba1\u65e5\u5fd7\u8868\u51b7\u6570\u636e\uff0c\u67e5\u8be2\u5f52\u6863\u8868{}\u6570\u636e\uff0c\u5f00\u59cb\u65f6\u95f4\uff1a{}\uff0c\u7ed3\u675f\u65f6\u95f4\uff1a{}", new Object[]{newTableName, dayStartTime, dayEndTime});
                ArchiveTableNameContext.setArchiveTableName((String)newTableName);
            } else {
                logger.debug("\u6309\u5929\u5f52\u6863\u5ba1\u8ba1\u65e5\u5fd7\u8868\u8bb0\u5f55\u51b7\u6570\u636e\uff0c\u5f00\u59cb\u67e5\u8be2\u5ba1\u8ba1\u65e5\u5fd7\u8868\u8bb0\u5f55\u51b7\u6570\u636e\uff0c\u5f00\u59cb\u65f6\u95f4\uff1a{}\uff0c\u7ed3\u675f\u65f6\u95f4\uff1a{}", (Object)dayStartTime, (Object)dayEndTime);
            }
            auditLogTableEntities = this.auditLogTableDaoService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ge(HussarBaseEntity::getCreateTime, (Object)dayStartTime)).le(HussarBaseEntity::getCreateTime, (Object)dayEndTime));
        }
        finally {
            ArchiveTableNameContext.removeArchiveTableName();
        }
        if (HussarUtils.isEmpty((Object)auditLogTableEntities)) {
            logger.debug("\u672a\u67e5\u8be2\u5230\u5ba1\u8ba1\u65e5\u5fd7\u8868\u8bb0\u5f55\u51b7\u6570\u636e\uff0c\u5f00\u59cb\u65f6\u95f4\uff1a{}\uff0c\u7ed3\u675f\u65f6\u95f4\uff1a{}", (Object)dayStartTime, (Object)dayEndTime);
            return;
        }
        logger.debug("\u6309\u5929\u5f52\u6863\u5ba1\u8ba1\u65e5\u5fd7\u8868\u8bb0\u5f55\u51b7\u6570\u636e\uff0c\u6279\u91cf\u5199\u5165\u5f52\u6863\u6587\u4ef6\uff0c\u6bcf\u6279{}\u6761", (Object)100);
        int batchSize = 100;
        for (int i = 0; i < auditLogTableEntities.size(); i += batchSize) {
            int endIndex = Math.min(i + batchSize, auditLogTableEntities.size());
            List batch = auditLogTableEntities.subList(i, endIndex);
            String jsonData = JsonUtil.toJson(batch);
            FileUtil.writeToFile((File)archiveFile, (String)(jsonData + System.lineSeparator()), (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeArchiveData(String newTableName, LocalDateTime stratTime, LocalDateTime endTime) {
        logger.debug("\u5220\u9664\u5f52\u6863\u8868{}\u6570\u636e\uff0c\u5f00\u59cb\u65f6\u95f4:{}\uff0c\u7ed3\u675f\u65f6\u95f4:{}", new Object[]{newTableName, stratTime, endTime});
        try {
            ArchiveTableNameContext.setArchiveTableName((String)newTableName);
            this.auditLogTableDaoService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ge(HussarBaseEntity::getCreateTime, (Object)stratTime)).le(HussarBaseEntity::getCreateTime, (Object)endTime));
        }
        finally {
            ArchiveTableNameContext.removeArchiveTableName();
        }
    }

    @Override
    protected int archiveWarmDataByPage(String newTableName, LocalDateTime dayStartTime, LocalDateTime dayEndTime, Integer pageNum) {
        int pageSize = 500;
        logger.debug("\u5206\u9875\u5f52\u6863\u5ba1\u8ba1\u65e5\u5fd7\u8868\u8bb0\u5f55\u6e29\u6570\u636e\uff0c\u5f00\u59cb\u67e5\u8be2\u539f\u8868{}\u6570\u636e\uff0c\u5f00\u59cb\u65f6\u95f4\uff1a{}\uff0c\u7ed3\u675f\u65f6\u95f4\uff1a{}\uff0c\u7b2c{}\u9875", new Object[]{"SYS_SUPPORT_AUDIT_LOG_TABLE", dayStartTime, dayEndTime, pageNum});
        Page page = new Page((long)pageNum.intValue(), (long)pageSize);
        IPage pageResult = this.auditLogTableDaoService.page((IPage)page, (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ge(HussarBaseEntity::getCreateTime, (Object)dayStartTime)).le(HussarBaseEntity::getCreateTime, (Object)dayEndTime));
        if (HussarUtils.isEmpty((Object)pageResult) || HussarUtils.isEmpty((Object)pageResult.getRecords())) {
            logger.debug("\u5206\u9875\u5f52\u6863\u5ba1\u8ba1\u65e5\u5fd7\u8868\u8bb0\u5f55\u6e29\u6570\u636e\uff0c\u672a\u67e5\u8be2\u5230\u5ba1\u8ba1\u65e5\u5fd7\u6e29\u6570\u636e");
            return 0;
        }
        logger.debug("\u5206\u9875\u5f52\u6863\u5ba1\u8ba1\u65e5\u5fd7\u8868\u8bb0\u5f55\u6e29\u6570\u636e\uff0c\u6279\u91cf\u5199\u5165\u5f52\u6863\u8868{}\uff0c\u5f00\u59cb\u65f6\u95f4\uff1a{}\uff0c\u7ed3\u675f\u65f6\u95f4\uff1a{}\uff0c\u7b2c{}\u9875", new Object[]{newTableName, dayStartTime, dayEndTime, pageNum});
        this.druidDynamicInserter.insertWithDynamicBatch(pageResult.getRecords(), auditLogTableEntities -> {
            try {
                ArchiveTableNameContext.setArchiveTableName((String)newTableName);
                Boolean bl = this.auditLogTableDaoService.saveBatchNoTransaction((Collection)auditLogTableEntities);
                return bl;
            }
            finally {
                ArchiveTableNameContext.removeArchiveTableName();
            }
        });
        return pageResult.getRecords().size();
    }
}

