/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.handler;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.audit.core.archive.context.ArchiveTableNameContext;
import com.jxdinfo.hussar.support.audit.core.auditlog.entity.AuditLogEntity;
import com.jxdinfo.hussar.support.audit.plugin.archive.conditions.MybatisCondition;
import com.jxdinfo.hussar.support.audit.plugin.archive.factory.RecoverHandlerFactory;
import com.jxdinfo.hussar.support.audit.plugin.archive.handler.AbstractRecoverHandler;
import com.jxdinfo.hussar.support.audit.plugin.dao.service.AuditLogDaoService;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service(value="auditLogRecoverHandler")
@HussarDs(value="master")
@Conditional(value={MybatisCondition.class})
public class AuditLogRecoverHandler
extends AbstractRecoverHandler {
    private static final Logger logger = LoggerFactory.getLogger(AuditLogRecoverHandler.class);
    @Autowired
    private AuditLogDaoService auditLogDaoService;

    @Override
    protected long getSourceDataCount(LocalDateTime startTime, LocalDateTime endTime) {
        return this.auditLogDaoService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ge(HussarBaseEntity::getCreateTime, (Object)startTime)).le(HussarBaseEntity::getCreateTime, (Object)endTime));
    }

    @Override
    protected Long recoverColdDataByJson(String jsonFileContent) {
        List logEntities = JsonUtil.parseArray((String)jsonFileContent, AuditLogEntity.class);
        if (HussarUtils.isEmpty((Object)logEntities)) {
            return 0L;
        }
        logger.debug("\u6062\u590d\u51b7\u6570\u636e\uff0c\u6279\u91cf\u6062\u590d\u81f3\u6e90\u6570\u636e\u8868");
        this.auditLogDaoService.saveBatchNoTransaction((Collection)logEntities);
        return logEntities.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long getArchiveDataCount(String tableName, LocalDateTime archiveStartupTime, LocalDateTime archiveEndTime) {
        try {
            ArchiveTableNameContext.setArchiveTableName((String)tableName);
            long l = this.auditLogDaoService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ge(HussarBaseEntity::getCreateTime, (Object)archiveStartupTime)).le(HussarBaseEntity::getCreateTime, (Object)archiveEndTime));
            return l;
        }
        finally {
            ArchiveTableNameContext.removeArchiveTableName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeArchiveTableData(String tableName, LocalDateTime archiveStartTime, LocalDateTime archiveEndTime) {
        try {
            ArchiveTableNameContext.setArchiveTableName((String)tableName);
            this.auditLogDaoService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ge(HussarBaseEntity::getCreateTime, (Object)archiveStartTime)).le(HussarBaseEntity::getCreateTime, (Object)archiveEndTime));
        }
        finally {
            ArchiveTableNameContext.removeArchiveTableName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void recoverWarmDataByDay(String tableName, YearMonth yearMonth, Integer day, Integer batchSize) {
        List auditLogEntityList;
        logger.debug("\u5f00\u59cb\u6309\u5929\u6062\u590d\u5ba1\u8ba1\u65e5\u5fd7\u6e29\u6570\u636e");
        LocalDateTime startTime = LocalDateTime.of(yearMonth.getYear(), yearMonth.getMonth(), (int)day, 0, 0);
        LocalDateTime endTime = LocalDateTime.of(yearMonth.getYear(), yearMonth.getMonth(), (int)day, 23, 59, 59);
        try {
            ArchiveTableNameContext.setArchiveTableName((String)tableName);
            auditLogEntityList = this.auditLogDaoService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ge(HussarBaseEntity::getCreateTime, (Object)startTime)).le(HussarBaseEntity::getCreateTime, (Object)endTime));
        }
        finally {
            ArchiveTableNameContext.removeArchiveTableName();
        }
        if (HussarUtils.isEmpty((Object)auditLogEntityList)) {
            logger.debug("\u6ca1\u6709\u9700\u8981\u6062\u590d\u7684\u5ba1\u8ba1\u65e5\u5fd7\u6e29\u6570\u636e");
            return;
        }
        logger.debug("\u6309\u5929\u6062\u590d\u6e29\u6570\u636e\uff0c\u6279\u91cf\u6062\u590d\u81f3\u5ba1\u8ba1\u65e5\u5fd7\u8868\uff0c\u6279\u91cf\u6570\u91cf\uff1a{}", (Object)batchSize);
        for (int i = 0; i < auditLogEntityList.size(); i += batchSize.intValue()) {
            int endIndex = Math.min(i + batchSize, auditLogEntityList.size());
            List batch = auditLogEntityList.subList(i, endIndex);
            this.auditLogDaoService.saveBatchNoTransaction(batch);
        }
    }

    @Override
    public void registryRecoverHandler() {
        RecoverHandlerFactory.register("SYS_SUPPORT_AUDIT_LOG", this);
    }
}

