/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.convertor;

import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.convertor.BaseDataTypeConvertor;
import java.sql.JDBCType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class OracleDataTypeConvertor
extends BaseDataTypeConvertor {
    private static final Map<String, Consumer<ColumnInfoDto>> JDBC_TYPE_2_METHOD = new ConcurrentHashMap<String, Consumer<ColumnInfoDto>>(8);

    @Override
    protected List<ColumnInfoDto> convertDataTypeByJdbcType(List<ColumnInfoDto> columnInfos) {
        return columnInfos.stream().peek(action -> {
            String jdbcType = action.getJdbcType();
            Consumer<ColumnInfoDto> columnInfoDtoConsumer = JDBC_TYPE_2_METHOD.get(jdbcType);
            if (ObjectUtils.isNull((Object[])new Object[]{columnInfoDtoConsumer})) {
                throw new IllegalStateException(String.format("\u6682\u4e0d\u652f\u6301\u7c7b\u578b%s", jdbcType));
            }
            columnInfoDtoConsumer.accept((ColumnInfoDto)action);
        }).collect(Collectors.toList());
    }

    static {
        JDBC_TYPE_2_METHOD.put(JDBCType.CHAR.name(), columnInfoDto -> columnInfoDto.setDataType("char"));
        JDBC_TYPE_2_METHOD.put(JDBCType.VARCHAR.name(), columnInfoDto -> {
            columnInfoDto.setDataType("varchar2");
            columnInfoDto.setDataLength(Long.valueOf(Math.min(columnInfoDto.getDataLength() * 3L, 3999L)));
        });
        JDBC_TYPE_2_METHOD.put(JDBCType.TIMESTAMP.name(), columnInfoDto -> {
            columnInfoDto.setDataType("TIMESTAMP");
            columnInfoDto.setDataLength(Optional.ofNullable(columnInfoDto.getDataLength()).orElse(6L));
        });
        JDBC_TYPE_2_METHOD.put(JDBCType.CLOB.name(), columnInfoDto -> columnInfoDto.setDataType("clob"));
        JDBC_TYPE_2_METHOD.put(JDBCType.INTEGER.name(), columnInfoDto -> {
            columnInfoDto.setDataType("NUMBER");
            columnInfoDto.setDataDot(Optional.ofNullable(columnInfoDto.getDataDot()).orElse(0));
        });
        JDBC_TYPE_2_METHOD.put(JDBCType.BIGINT.name(), columnInfoDto -> {
            columnInfoDto.setDataType("NUMBER");
            columnInfoDto.setDataDot(Optional.ofNullable(columnInfoDto.getDataDot()).orElse(0));
        });
    }
}

