/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.convertor;

import com.baomidou.mybatisplus.annotation.DbType;
import com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.convertor.BaseDataTypeConvertor;
import com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.convertor.DmDataTypeConvertor;
import com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.convertor.GaussDataTypeConvertor;
import com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.convertor.HighGoDataTypeConvertor;
import com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.convertor.KingBaseDataTypeConvertor;
import com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.convertor.MySQLDataTypeConvertor;
import com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.convertor.OracleDataTypeConvertor;
import com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.convertor.OscarDataTypeConvertor;
import com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.convertor.PostgreSqlDataTypeConvertor;
import com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.convertor.SqlServerDataTypeConvertor;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DataTypeConvertorFactory {
    private static final Map<String, BaseDataTypeConvertor> DATA_TYPE_CONVERTOR_MAP = new ConcurrentHashMap<String, BaseDataTypeConvertor>(16);

    public static void registryConvertor(String dataBaseType, BaseDataTypeConvertor convertor) {
        DATA_TYPE_CONVERTOR_MAP.put(dataBaseType, convertor);
    }

    public static BaseDataTypeConvertor getConvertor(String dataBaseType) {
        return DATA_TYPE_CONVERTOR_MAP.get(dataBaseType);
    }

    public static Collection<BaseDataTypeConvertor> getAllConvertor() {
        return DATA_TYPE_CONVERTOR_MAP.values();
    }

    static {
        DataTypeConvertorFactory.registryConvertor(DbType.MYSQL.getDb(), new MySQLDataTypeConvertor());
        DataTypeConvertorFactory.registryConvertor(DbType.ORACLE.getDb(), new OracleDataTypeConvertor());
        DataTypeConvertorFactory.registryConvertor(DbType.ORACLE_12C.getDb(), new OracleDataTypeConvertor());
        DataTypeConvertorFactory.registryConvertor(DbType.KINGBASE_ES.getDb(), new KingBaseDataTypeConvertor());
        DataTypeConvertorFactory.registryConvertor(DbType.POSTGRE_SQL.getDb(), new PostgreSqlDataTypeConvertor());
        DataTypeConvertorFactory.registryConvertor(DbType.DM.getDb(), new DmDataTypeConvertor());
        DataTypeConvertorFactory.registryConvertor(DbType.OSCAR.getDb(), new OscarDataTypeConvertor());
        DataTypeConvertorFactory.registryConvertor(DbType.GAUSS.getDb(), new GaussDataTypeConvertor());
        DataTypeConvertorFactory.registryConvertor(DbType.SQL_SERVER.getDb(), new SqlServerDataTypeConvertor());
        DataTypeConvertorFactory.registryConvertor(DbType.SQL_SERVER2005.getDb(), new SqlServerDataTypeConvertor());
        DataTypeConvertorFactory.registryConvertor(DbType.HIGH_GO.getDb(), new HighGoDataTypeConvertor());
    }
}

