/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.archive.mongo.repository;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.auditlog.entity.AuditLogEntity;
import com.jxdinfo.hussar.support.audit.plugin.archive.conditions.MongoCondition;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Repository
@Conditional(value={MongoCondition.class})
public class AuditLogArchiveRepository {
    @Autowired
    private MongoTemplate mongoTemplate;

    public Integer batchInsert(String newTableName, List<AuditLogEntity> auditLogEntities) {
        this.mongoTemplate.insert(auditLogEntities, newTableName);
        return auditLogEntities.size();
    }

    public List<AuditLogEntity> selectListByCreateTime(String newTableName, LocalDateTime startTime, LocalDateTime endTime) {
        Criteria criteria = Criteria.where((String)"createTime").gte((Object)startTime).lte((Object)endTime);
        Query query = Query.query((CriteriaDefinition)criteria);
        return this.mongoTemplate.find(query, AuditLogEntity.class, newTableName);
    }

    public LocalDateTime selectMinCreateTime() {
        Query query = new Query().with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"createTime"})).limit(1);
        AuditLogEntity auditLogEntity = (AuditLogEntity)this.mongoTemplate.findOne(query, AuditLogEntity.class);
        if (HussarUtils.isNotEmpty((Object)auditLogEntity)) {
            return auditLogEntity.getCreateTime();
        }
        return null;
    }

    public Long deleteByCreateTime(String newTableName, LocalDateTime startTime, LocalDateTime endTime) {
        Criteria criteria = Criteria.where((String)"createTime").gte((Object)startTime).lte((Object)endTime);
        Query query = Query.query((CriteriaDefinition)criteria);
        return this.mongoTemplate.remove(query, newTableName).getDeletedCount();
    }
}

