/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.archive.mongo.handler;

import com.jxdinfo.hussar.platform.core.utils.FileUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.audit.core.archive.enums.ArchiveDataType;
import com.jxdinfo.hussar.support.audit.core.auditlog.entity.AuditLogTableEntity;
import com.jxdinfo.hussar.support.audit.plugin.archive.conditions.MongoCondition;
import com.jxdinfo.hussar.support.audit.plugin.archive.factory.ArchiveHandlerFactory;
import com.jxdinfo.hussar.support.audit.plugin.archive.handler.AbstractArchiveHandler;
import com.jxdinfo.hussar.support.audit.plugin.archive.mongo.repository.AuditLogTableArchiveRepository;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import java.io.File;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service(value="auditLogTableMongoArchiveHandler")
@HussarDs(value="master")
@Conditional(value={MongoCondition.class})
public class AuditLogTableMongoArchiveHandler
extends AbstractArchiveHandler {
    private static final Logger logger = LoggerFactory.getLogger(AuditLogTableMongoArchiveHandler.class);
    @Autowired
    private AuditLogTableArchiveRepository auditLogTableArchiveRepository;
    @Autowired
    private MongoTemplate mongoTemplate;

    @Override
    public void registryArchiveHandler() {
        ArchiveHandlerFactory.registry("SYS_SUPPORT_AUDIT_LOG_TABLE", this);
    }

    @Override
    protected LocalDateTime getMinCreateTime(LocalDateTime startTime) {
        return this.auditLogTableArchiveRepository.selectMinCreateTime();
    }

    @Override
    protected Long getSourceDataCount(LocalDateTime startTime, LocalDateTime endTime) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"createTime").gte((Object)startTime).lte((Object)endTime));
        return this.mongoTemplate.count(query, AuditLogTableEntity.class);
    }

    @Override
    protected void removeSourceData(LocalDateTime startTime, LocalDateTime endTime) {
        this.mongoTemplate.remove(Query.query((CriteriaDefinition)Criteria.where((String)"createTime").gte((Object)startTime).lte((Object)endTime)), AuditLogTableEntity.class);
    }

    @Override
    protected long getArchiveDataCount(String newTableName, LocalDateTime startTime, LocalDateTime endTime) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"createTime").gte((Object)startTime).lte((Object)endTime));
        return this.mongoTemplate.count(query, AuditLogTableEntity.class, newTableName);
    }

    @Override
    protected void archiveColdDataByDay(String newTableName, File archiveFile, ArchiveDataType archiveDataType, LocalDateTime dayStartTime, LocalDateTime dayEndTime) {
        logger.debug("\u6309\u5929\u5f52\u6863\u5ba1\u8ba1\u65e5\u5fd7\u8868\u8bb0\u5f55\u51b7\u6570\u636e\uff0c\u5f00\u59cb\u65f6\u95f4:{}\uff0c\u7ed3\u675f\u65f6\u95f4:{}", (Object)dayStartTime, (Object)dayEndTime);
        List auditLogTableEntities = archiveDataType == ArchiveDataType.COLD_DATA ? this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"createTime").gte((Object)dayStartTime).lte((Object)dayEndTime)), AuditLogTableEntity.class) : this.auditLogTableArchiveRepository.selectListByCreateTime(newTableName, dayStartTime, dayEndTime);
        if (HussarUtils.isEmpty(auditLogTableEntities)) {
            logger.debug("\u5ba1\u8ba1\u65e5\u5fd7\u8868\u8bb0\u5f55\u51b7\u6570\u636e\u4e3a\u7a7a\uff0c\u7ed3\u675f\u5f52\u6863");
            return;
        }
        logger.debug("\u6309\u5929\u5f52\u6863\u5ba1\u8ba1\u65e5\u5fd7\u8868\u8bb0\u5f55\u51b7\u6570\u636e\uff0c\u5206\u6279\u5199\u5165\u5f52\u6863\u6587\u4ef6\uff0c\u6bcf\u6279{}\u6761", (Object)100);
        int batchSize = 100;
        for (int i = 0; i < auditLogTableEntities.size(); i += batchSize) {
            int endIndex = Math.min(i + batchSize, auditLogTableEntities.size());
            List batch = auditLogTableEntities.subList(i, endIndex);
            String jsonData = JsonUtil.toJson(batch);
            FileUtil.writeToFile((File)archiveFile, (String)(jsonData + System.lineSeparator()), (boolean)true);
        }
    }

    @Override
    protected void removeArchiveData(String newTableName, LocalDateTime stratTime, LocalDateTime endTime) {
        this.auditLogTableArchiveRepository.deleteByCreateTime(newTableName, stratTime, endTime);
    }

    @Override
    protected int archiveWarmDataByPage(String newTableName, LocalDateTime dayStartTime, LocalDateTime dayEndTime, Integer pageNum) {
        int pageSize = 500;
        logger.debug("\u5206\u9875\u5f52\u6863\u5ba1\u8ba1\u65e5\u5fd7\u8868\u8bb0\u5f55\u6e29\u6570\u636e\uff0c\u5f00\u59cb\u67e5\u8be2\u539f\u8868\u6570\u636e\uff0c\u5f00\u59cb\u65f6\u95f4\uff1a{}\uff0c\u7ed3\u675f\u65f6\u95f4\uff1a{}\uff0c\u7b2c{}\u9875", new Object[]{dayStartTime, dayEndTime, pageNum});
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"createTime").gte((Object)dayStartTime).lte((Object)dayEndTime)).skip((long)pageSize * (long)(pageNum - 1)).limit(pageSize);
        List logTableEntities = this.mongoTemplate.find(query, AuditLogTableEntity.class);
        if (HussarUtils.isEmpty((Object)logTableEntities)) {
            logger.debug("\u5206\u9875\u5f52\u6863\u5ba1\u8ba1\u65e5\u5fd7\u8868\u8bb0\u5f55\u6e29\u6570\u636e\uff0c\u672a\u67e5\u8be2\u5230\u5ba1\u8ba1\u65e5\u5fd7\u6e29\u6570\u636e");
            return 0;
        }
        logger.debug("\u5206\u9875\u5f52\u6863\u5ba1\u8ba1\u65e5\u5fd7\u8868\u8bb0\u5f55\u6e29\u6570\u636e\uff0c\u6279\u91cf\u5199\u5165\u5f52\u6863\u8868\uff0c\u5f00\u59cb\u65f6\u95f4\uff1a{}\uff0c\u7ed3\u675f\u65f6\u95f4\uff1a{}\uff0c\u7b2c{}\u9875", new Object[]{dayStartTime, dayEndTime, pageNum});
        this.auditLogTableArchiveRepository.batchInsert(newTableName, logTableEntities);
        return logTableEntities.size();
    }
}

