/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.archive.handler;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.FileUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.file.ZipUtil;
import com.jxdinfo.hussar.support.audit.core.archive.enums.ArchiveDataType;
import com.jxdinfo.hussar.support.audit.core.archive.enums.ArchiveRecoverStatus;
import com.jxdinfo.hussar.support.audit.core.archive.handler.RecoverHandler;
import com.jxdinfo.hussar.support.audit.core.archive.model.ArchiveBaseConfig;
import com.jxdinfo.hussar.support.audit.core.archive.model.ArchiveRecordEntity;
import com.jxdinfo.hussar.support.audit.core.archive.model.ArchiveRecoverEntity;
import com.jxdinfo.hussar.support.audit.core.archive.service.ArchiveBaseConfigService;
import com.jxdinfo.hussar.support.audit.core.archive.vo.ArchiveRecordVo;
import com.jxdinfo.hussar.support.audit.core.archive.vo.ArchiveRecoverVo;
import com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.service.ArchiveRecordDaoService;
import com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.service.ArchiveRecoverDaoService;
import com.jxdinfo.hussar.support.audit.plugin.archive.utils.LocalDateTimeUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.lock.HussarLockGuard;
import com.jxdinfo.hussar.support.lock.HussarLockManager;
import com.jxdinfo.hussar.support.lock.HussarLockType;
import com.jxdinfo.hussar.support.lock.annotation.HussarLockExecutionStrategy;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.thread.core.RejectedExecutionHandlerEnum;
import com.jxdinfo.hussar.support.thread.support.executor.HussarTaskExecutor;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.FileCopyUtils;

public abstract class AbstractRecoverHandler
implements RecoverHandler,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRecoverHandler.class);
    @Autowired
    private ArchiveRecoverDaoService archiveRecoverService;
    @Autowired
    private ArchiveBaseConfigService archiveBaseConfigService;
    @Autowired
    private HussarLockManager hussarLockManager;
    @Autowired
    private OssService ossService;
    @Autowired
    private ArchiveRecordDaoService archiveRecordService;
    @Autowired
    private HussarTaskExecutor hussarTaskExecutor;

    public void recover(ArchiveRecordVo archiveRecordVo, LocalDateTime dataStorageTime) {
        if (HussarUtils.isEmpty((Object)archiveRecordVo)) {
            logger.debug("\u5f52\u6863\u8bb0\u5f55\u4e3a\u7a7a");
            return;
        }
        this.recoverData(archiveRecordVo, dataStorageTime);
    }

    private void recoverData(ArchiveRecordVo archiveRecordVo, LocalDateTime dataStorageTime) {
        LocalDateTime archiveStartTime = archiveRecordVo.getArchiveStartupTime();
        LocalDateTime archiveEndTime = archiveRecordVo.getArchiveEndTime();
        String sourceTableName = archiveRecordVo.getSourceTableName();
        logger.debug("\u5f00\u59cb\u6062\u590d\u6570\u636e\u8868{}\u6570\u636e\uff0c\u5f00\u59cb\u65f6\u95f4:{}\uff0c\u7ed3\u675f\u65f6\u95f4:{}", new Object[]{sourceTableName, archiveStartTime, archiveEndTime});
        logger.debug("\u6062\u590d\u6570\u636e\uff0c\u68c0\u67e5\u662f\u5426\u6709\u5df2\u7ecf\u6210\u529f\u6062\u590d\u4e14\u672a\u8d85\u671f\u7684\u6570\u636e");
        long count = this.getRecoverCount(sourceTableName, ArchiveRecoverStatus.RECOVER_SUCCESS, archiveRecordVo.getArchiveStartupTime(), archiveRecordVo.getArchiveEndTime(), LocalDateTime.now());
        if (count > 0L) {
            logger.debug("\u5ba1\u8ba1\u65e5\u5fd7\u6570\u636e\u5df2\u6062\u590d\u4e14\u8fd8\u672a\u8d85\u671f\uff0c\u65e0\u9700\u91cd\u590d\u6062\u590d");
            return;
        }
        Integer archiveDataType = archiveRecordVo.getArchiveType();
        if (ArchiveDataType.WARM_DATA.getCode().equals(archiveDataType)) {
            this.hussarTaskExecutor.execute(() -> this.recoverWarmData(archiveRecordVo, dataStorageTime, null));
            return;
        }
        this.hussarTaskExecutor.execute(() -> this.recoverColdData(archiveRecordVo, dataStorageTime, null));
        logger.debug("\u6570\u636e\u8868{}\u6570\u636e\u6062\u590d\u5b8c\u6210", (Object)sourceTableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void recoverColdData(ArchiveRecordVo archiveRecordVo, LocalDateTime dataStorageTime, ArchiveRecoverVo recoverVo) {
        File archiveFile;
        File zipFile;
        HussarLockGuard lockGuard;
        block12: {
            block11: {
                LocalDateTime startTime = archiveRecordVo.getArchiveStartupTime();
                LocalDateTime endTime = archiveRecordVo.getArchiveEndTime();
                String sourceTableName = archiveRecordVo.getSourceTableName();
                logger.debug("\u6062\u590d\u51b7\u6570\u636e\uff0c\u5f00\u59cb\u68c0\u67e5\u6e90\u6570\u636e\u8868{}\u6570\u636e\uff0c\u5f00\u59cb\u65f6\u95f4:{}\uff0c\u7ed3\u675f\u65f6\u95f4:{}", new Object[]{sourceTableName, startTime, endTime});
                long count = this.getSourceDataCount(startTime, endTime);
                if (count > 0L) {
                    logger.debug("\u6e90\u6570\u636e\u8868{}\u4e2d\u5df2\u5b58\u5728{}\u6708\u4efd\u7684\u6570\u636e\uff0c\u6570\u636e\u6761\u6570\u4e3a{}\uff0c\u4e0d\u518d\u8fdb\u884c\u6062\u590d\uff01", new Object[]{sourceTableName, YearMonth.from(startTime), count});
                    return;
                }
                LocalDateTime archiveStartTime = archiveRecordVo.getArchiveStartupTime();
                YearMonth yearMonth = YearMonth.from(archiveStartTime);
                DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMM");
                String tableNameSuffix = yearMonth.format(dateTimeFormatter);
                String lockKey = "hussar:recover:lock:" + sourceTableName + ":" + tableNameSuffix;
                logger.debug("\u5f00\u59cb\u6062\u590d\u51b7\u6570\u636e\uff0c\u52a0\u5206\u5e03\u5f0f\u9501,\u952e:{}", (Object)lockKey);
                lockGuard = this.lock(lockKey);
                if (HussarUtils.isEmpty((Object)lockGuard)) {
                    logger.debug("\u6062\u590d\u51b7\u6570\u636e\uff0c\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25");
                    return;
                }
                logger.debug("\u6062\u590d\u51b7\u6570\u636e\uff0c\u5199\u5165\u6062\u590d\u8bb0\u5f55");
                ArchiveRecoverEntity archiveRecoverEntity = this.saveOrUpdateArchiveRecover(archiveRecordVo, dataStorageTime, recoverVo);
                zipFile = null;
                archiveFile = null;
                try {
                    Long fileId = Long.valueOf(archiveRecordVo.getDataLocation());
                    String tmpDir = FileUtil.getTempDirPath();
                    String fileName = tmpDir + File.separator + sourceTableName + "_" + tableNameSuffix + "_" + fileId + "." + "zip";
                    zipFile = new File(fileName);
                    if (!zipFile.exists()) {
                        logger.debug("\u6062\u590d\u51b7\u6570\u636e\uff0c\u521b\u5efa\u6587\u4ef6\uff0c\u6587\u4ef6\u540d\u79f0\uff1a{}", (Object)fileName);
                        zipFile.createNewFile();
                    }
                    logger.debug("\u6062\u590d\u51b7\u6570\u636e\uff0c\u4e0b\u8f7d\u6587\u4ef6\uff0c\u6587\u4ef6ID\uff1a{}", (Object)fileId);
                    ApiResponse response = this.ossService.backgroundDownload(fileId);
                    if (!response.isSuccess()) {
                        throw new HussarException("\u51b7\u6570\u636e\u5f52\u6863\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
                    }
                    byte[] bytes = (byte[])response.getData();
                    logger.debug("\u6062\u590d\u51b7\u6570\u636e\uff0c\u5199\u5165\u538b\u7f29\u6587\u4ef6\uff0c\u538b\u7f29\u6587\u4ef6\u540d\u79f0\uff1a{}", (Object)fileName);
                    FileCopyUtils.copy((byte[])bytes, (File)zipFile);
                    logger.debug("\u6062\u590d\u51b7\u6570\u636e\uff0c\u51c6\u5907\u89e3\u538b\u538b\u7f29\u6587\u4ef6");
                    File zipDir = ZipUtil.unzip((File)zipFile);
                    logger.debug("\u6062\u590d\u51b7\u6570\u636e\uff0c\u89e3\u538b\u538b\u7f29\u6587\u4ef6\uff0c\u89e3\u538b\u76ee\u5f55\uff1a{}", (Object)zipDir.getAbsolutePath());
                    List files = FileUtil.list((File)zipDir);
                    if (HussarUtils.isEmpty((Object)files)) {
                        logger.debug("\u6062\u590d\u51b7\u6570\u636e\uff0c\u89e3\u538b\u540e\u7684\u538b\u7f29\u6587\u4ef6\u4e3a\u7a7a");
                        logger.debug("\u6062\u590d\u51b7\u6570\u636e\uff0c\u91ca\u653e\u5206\u5e03\u5f0f\u9501");
                        break block11;
                    }
                    archiveFile = (File)files.get(0);
                    logger.debug("\u6062\u590d\u51b7\u6570\u636e\uff0c\u8bfb\u53d6\u89e3\u538b\u76ee\u5f55\u4e2d\u7b2c\u4e00\u4e2a\u6587\u4ef6\uff0c\u6587\u4ef6\u540d\u79f0\uff1a{}", (Object)archiveFile.getName());
                    List lines = Files.readLines((File)archiveFile, (Charset)StandardCharsets.UTF_8);
                    logger.debug("\u6062\u590d\u51b7\u6570\u636e\uff0c\u8bfb\u53d6\u89e3\u538b\u76ee\u5f55\u4e2d\u7b2c\u4e00\u4e2a\u6587\u4ef6\uff0c\u6587\u4ef6\u884c\u6570\uff1a{}", (Object)lines.size());
                    this.saveDataBatch(lines);
                    logger.debug("\u6062\u590d\u51b7\u6570\u636e\uff0c\u66f4\u65b0\u5f52\u6863\u6062\u590d\u8bb0\u5f55\u6062\u590d\u72b6\u6001\u4e3a\u6062\u590d\u6210\u529f");
                    this.updateArchiveRecover(archiveRecoverEntity, ArchiveRecoverStatus.RECOVER_SUCCESS, null, archiveRecordVo.getArchiveDataCount());
                    logger.debug("\u6062\u590d\u51b7\u6570\u636e\uff0c\u91ca\u653e\u5206\u5e03\u5f0f\u9501");
                    break block12;
                }
                catch (Exception e) {
                    logger.debug("\u51b7\u6570\u636e\u6062\u590d\u5f02\u5e38", (Throwable)e);
                    String exceptionMsg = String.format("\u51b7\u6570\u636e\u6062\u590d\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%s", e.getMessage());
                    this.updateArchiveRecover(archiveRecoverEntity, ArchiveRecoverStatus.RECOVER_FAIL, exceptionMsg, null);
                    return;
                }
            }
            lockGuard.releaseLock();
            FileUtil.deleteQuietly((File)zipFile);
            FileUtil.deleteQuietly((File)archiveFile);
            return;
        }
        lockGuard.releaseLock();
        FileUtil.deleteQuietly((File)zipFile);
        FileUtil.deleteQuietly((File)archiveFile);
        return;
        finally {
            logger.debug("\u6062\u590d\u51b7\u6570\u636e\uff0c\u91ca\u653e\u5206\u5e03\u5f0f\u9501");
            lockGuard.releaseLock();
            FileUtil.deleteQuietly(zipFile);
            FileUtil.deleteQuietly(archiveFile);
        }
    }

    protected abstract long getSourceDataCount(LocalDateTime var1, LocalDateTime var2);

    protected void saveDataBatch(List<String> fileContentLines) {
        if (HussarUtils.isEmpty(fileContentLines)) {
            logger.debug("\u6062\u590d\u51b7\u6570\u636e\uff0c\u5f52\u6863\u6587\u4ef6\u8bfb\u53d6\u540e\u5185\u5bb9\u4e3a\u7a7a");
            return;
        }
        long count = 0L;
        for (String jsonFileContent : fileContentLines) {
            count += this.recoverColdDataByJson(jsonFileContent).longValue();
        }
        logger.debug("\u6062\u590d\u51b7\u6570\u636e\uff0c\u4fdd\u5b58\u6570\u636e\u6210\u529f\uff0c\u6570\u636e\u884c\u6570\uff1a{}", (Object)count);
    }

    protected abstract Long recoverColdDataByJson(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverWarmData(ArchiveRecordVo archiveRecordVo, LocalDateTime dataStorageTime, ArchiveRecoverVo recoverVo) {
        String sourceTableName = archiveRecordVo.getSourceTableName();
        LocalDateTime archiveStartTime = archiveRecordVo.getArchiveStartupTime();
        LocalDateTime archiveEndTime = archiveRecordVo.getArchiveEndTime();
        String archiveTableName = archiveRecordVo.getDataLocation();
        logger.debug("\u5f00\u59cb\u6062\u590d\u6e29\u6570\u636e\uff0c\u4ece\u5f52\u6863\u8868{}\u6062\u590d\u81f3\u6e90\u6570\u636e\u8868{}\uff0c\u5f00\u59cb\u65f6\u95f4:{}\uff0c\u7ed3\u675f\u65f6\u95f4:{}", new Object[]{archiveTableName, sourceTableName, archiveStartTime, archiveEndTime});
        YearMonth yearMonth = YearMonth.from(archiveStartTime);
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMM");
        String tableNameSuffix = yearMonth.format(dateTimeFormatter);
        logger.debug("\u6062\u590d\u6e29\u6570\u636e\uff0c\u83b7\u53d6\u5f52\u6863\u8868{}\u4e2d\u6570\u636e\u884c\u6570", (Object)archiveTableName);
        long count = this.getArchiveDataCount(archiveTableName, archiveStartTime, archiveEndTime);
        if (count <= 0L) {
            logger.debug("\u6062\u590d\u6e29\u6570\u636e\uff0c\u5f52\u6863\u8868{}\u4e2d\u6708\u65e0\u6570\u636e\uff0c\u65e0\u9700\u6062\u590d\uff01", (Object)archiveTableName);
            return;
        }
        String lockKey = "hussar:recover:lock:" + sourceTableName + ":" + tableNameSuffix;
        logger.debug("\u6062\u590d\u6e29\u6570\u636e\uff0c\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\uff0c\u952e:{}", (Object)lockKey);
        HussarLockGuard lockGuard = this.lock(lockKey);
        if (HussarUtils.isEmpty((Object)lockGuard)) {
            logger.debug("\u6062\u590d\u6e29\u6570\u636e\uff0c\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25");
            return;
        }
        logger.debug("\u6062\u590d\u6e29\u6570\u636e\uff0c\u5199\u5165\u6062\u590d\u8bb0\u5f55");
        ArchiveRecoverEntity archiveRecoverEntity = this.saveOrUpdateArchiveRecover(archiveRecordVo, dataStorageTime, recoverVo);
        try {
            logger.debug("\u6062\u590d\u6e29\u6570\u636e\uff0c\u4ece\u8fd0\u884c\u53c2\u6570\u914d\u7f6e\u4e2d\u83b7\u53d6\u6062\u590d\u6570\u636e\u6279\u91cf\u5904\u7406\u6570\u91cf\uff0c\u9ed8\u8ba4\u4e3a100");
            ArchiveBaseConfig archiveBaseConfig = this.archiveBaseConfigService.getRecoverBatchSizeConfig();
            int recoverBatchSize = HussarUtils.isNotEmpty((Object)archiveBaseConfig) && HussarUtils.isNotBlank((CharSequence)archiveBaseConfig.getConfigValue()) ? Integer.parseInt(archiveBaseConfig.getConfigValue()) : 100;
            int days = LocalDateTimeUtils.getDaysOfMonth(yearMonth);
            logger.debug("\u6062\u590d\u6e29\u6570\u636e\uff0c\u6309\u5929\u6062\u590d\u6570\u636e\uff0c\u5171{}\u5929\uff0c\u4f7f\u7528\u7ebf\u7a0b\u6c60\u5e76\u884c\u6267\u884c", (Object)days);
            ThreadPoolTaskExecutor taskExecutor = this.buildTaskExecutor();
            ArrayList futures = Lists.newArrayListWithCapacity((int)days);
            int i = 1;
            while (i <= days) {
                int day = i++;
                Future future = taskExecutor.submit(() -> this.recoverWarmDataByDay(archiveTableName, yearMonth, day, recoverBatchSize));
                futures.add(future);
            }
            logger.debug("\u6062\u590d\u6e29\u6570\u636e\uff0c\u7b49\u5f85\u6240\u6709\u4efb\u52a1\u5b8c\u6210");
            for (Future future1 : futures) {
                future1.get();
            }
            logger.debug("\u6062\u590d\u6e29\u6570\u636e\uff0c\u5220\u9664\u5f52\u6863\u8868{}\u5f52\u6863\u6570\u636e", (Object)archiveTableName);
            this.removeArchiveTableData(archiveTableName, archiveStartTime, archiveEndTime);
            logger.debug("\u6062\u590d\u6e29\u6570\u636e\uff0c\u66f4\u65b0\u5f52\u6863\u6062\u590d\u8bb0\u5f55\uff0c\u5f52\u6863\u8bb0\u5f55ID:{}", (Object)archiveRecoverEntity.getArchiveRecoverId());
            this.updateArchiveRecover(archiveRecoverEntity, ArchiveRecoverStatus.RECOVER_SUCCESS, null, archiveRecordVo.getArchiveDataCount());
        }
        catch (Exception e) {
            logger.error("\u5f52\u6863\u6570\u636e\u6062\u590d\u5931\u8d25", (Throwable)e);
            String exceptionMsg = String.format("\u6e29\u6570\u636e\u6062\u590d\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%s", e.getMessage());
            this.updateArchiveRecover(archiveRecoverEntity, ArchiveRecoverStatus.RECOVER_FAIL, exceptionMsg, null);
        }
        finally {
            logger.debug("\u6062\u590d\u6e29\u6570\u636e\uff0c\u91ca\u653e\u5206\u5e03\u5f0f\u9501");
            lockGuard.releaseLock();
        }
    }

    protected abstract long getArchiveDataCount(String var1, LocalDateTime var2, LocalDateTime var3);

    @NotNull
    private ArchiveRecoverEntity saveOrUpdateArchiveRecover(ArchiveRecordVo archiveRecordVo, LocalDateTime dataStorageTime, ArchiveRecoverVo recoverVo) {
        if (HussarUtils.isEmpty((Object)recoverVo)) {
            ArchiveRecoverEntity archiveRecoverEntity = new ArchiveRecoverEntity();
            archiveRecoverEntity.setSourceTableName(archiveRecordVo.getSourceTableName());
            archiveRecoverEntity.setArchiveRecordId(archiveRecordVo.getArchiveRecordId());
            archiveRecoverEntity.setRecoverStartupTime(archiveRecordVo.getArchiveStartupTime());
            archiveRecoverEntity.setRecoverEndTime(archiveRecordVo.getArchiveEndTime());
            archiveRecoverEntity.setDataStorageTime(dataStorageTime);
            archiveRecoverEntity.setRecoverStatus(ArchiveRecoverStatus.RECOVERING.getCode());
            this.archiveRecoverService.save(archiveRecoverEntity);
            return archiveRecoverEntity;
        }
        ArchiveRecoverEntity archiveRecoverEntity = new ArchiveRecoverEntity();
        BeanUtil.copy((Object)recoverVo, (Object)archiveRecoverEntity);
        archiveRecoverEntity.setRecoverStatus(ArchiveRecoverStatus.RECOVERING.getCode());
        return archiveRecoverEntity;
    }

    private void updateArchiveRecover(ArchiveRecoverEntity archiveRecoverEntity, ArchiveRecoverStatus status, String failMsg, Integer dataCount) {
        archiveRecoverEntity.setRecoverStatus(status.getCode());
        if (HussarUtils.isNotEmpty((Object)failMsg)) {
            archiveRecoverEntity.setRecoverFailMsg(failMsg);
        }
        if (HussarUtils.isNotEmpty((Object)dataCount)) {
            archiveRecoverEntity.setRecoverDataCount(dataCount);
        }
        this.archiveRecoverService.updateById(archiveRecoverEntity);
    }

    private HussarLockGuard lock(String lockKey) {
        return this.hussarLockManager.acquire(HussarLockType.REENTRANT_LOCK, HussarLockExecutionStrategy.UNLIMITED, lockKey, Duration.ofMillis(100L), Duration.ofMinutes(30L));
    }

    private Map<String, ArchiveBaseConfig> getArchiveConfig() {
        List configs = this.archiveBaseConfigService.getArchiveConfigList();
        if (HussarUtils.isEmpty((Object)configs)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        return configs.stream().collect(Collectors.toMap(ArchiveBaseConfig::getConfigKey, archiveBaseConfig -> archiveBaseConfig));
    }

    protected abstract void removeArchiveTableData(String var1, LocalDateTime var2, LocalDateTime var3);

    protected abstract void recoverWarmDataByDay(String var1, YearMonth var2, Integer var3, Integer var4);

    public void recover(ArchiveRecoverVo recoverVo) {
        String sourceTableName = recoverVo.getSourceTableName();
        LocalDateTime startTime = recoverVo.getRecoverStartupTime();
        logger.debug("\u5f00\u59cb\u6062\u590d\u6570\u636e\uff0c\u6e90\u6570\u636e\u8868:{}", (Object)sourceTableName);
        Map<String, ArchiveBaseConfig> configMap = this.getArchiveConfig();
        if (HussarUtils.isEmpty(configMap)) {
            logger.debug("\u5f52\u6863\u914d\u7f6e\u4e0d\u5b58\u5728");
            return;
        }
        ArchiveRecordEntity archiveRecordEntity = (ArchiveRecordEntity)this.archiveRecordService.getById(recoverVo.getArchiveRecordId());
        ArchiveRecordVo archiveRecordVo = new ArchiveRecordVo();
        BeanUtil.copy((Object)archiveRecordEntity, (Object)archiveRecordVo);
        if (ArchiveDataType.WARM_DATA.getCode().equals(archiveRecordEntity.getArchiveType())) {
            this.recoverWarmData(archiveRecordVo, startTime, recoverVo);
            return;
        }
        this.recoverColdData(archiveRecordVo, recoverVo.getDataStorageTime(), recoverVo);
    }

    private long getRecoverCount(String sourceTableName, ArchiveRecoverStatus recoverStatus, LocalDateTime recoverStartupTime, LocalDateTime recoverEndTime, LocalDateTime dataStorageTime) {
        logger.debug("\u6062\u590d\u6570\u636e\uff0c\u6839\u636e\u6761\u4ef6\u83b7\u53d6\u6062\u590d\u8bb0\u5f55\u884c\u6570\uff0c\u8868\u540d:{}\uff0c\u6062\u590d\u72b6\u6001:{}\uff0c\u5f00\u59cb\u65f6\u95f4:{}\uff0c\u7ed3\u675f\u65f6\u95f4:{}", new Object[]{sourceTableName, recoverStatus, recoverStartupTime, recoverEndTime});
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ArchiveRecoverEntity::getSourceTableName, (Object)sourceTableName)).eq(ArchiveRecoverEntity::getRecoverStatus, (Object)recoverStatus.getCode())).eq(ArchiveRecoverEntity::getRecoverStartupTime, (Object)recoverStartupTime)).eq(ArchiveRecoverEntity::getRecoverEndTime, (Object)recoverEndTime);
        if (HussarUtils.isNotEmpty((Object)dataStorageTime)) {
            queryWrapper.gt(ArchiveRecoverEntity::getDataStorageTime, (Object)dataStorageTime);
        }
        return this.archiveRecoverService.count((Wrapper)queryWrapper);
    }

    public abstract void registryRecoverHandler();

    public void afterPropertiesSet() throws Exception {
        this.registryRecoverHandler();
    }

    private ThreadPoolTaskExecutor buildTaskExecutor() {
        int cpuCores = Runtime.getRuntime().availableProcessors();
        String key = RejectedExecutionHandlerEnum.Abort.getKey();
        return this.hussarTaskExecutor.createThreadPoolTaskExecutor(cpuCores, cpuCores * 4, 1024, RejectedExecutionHandlerEnum.instantiationHandler((String)key));
    }
}

