/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.archive.service.impl;

import com.google.common.collect.Lists;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.archive.enums.ArchiveExecType;
import com.jxdinfo.hussar.support.audit.core.archive.model.ArchiveBaseConfig;
import com.jxdinfo.hussar.support.audit.core.archive.service.ArchiveBaseConfigService;
import com.jxdinfo.hussar.support.audit.core.archive.service.ArchiveJobService;
import com.jxdinfo.hussar.support.audit.core.archive.service.ArchiveService;
import com.jxdinfo.hussar.support.audit.core.archive.vo.ArchiveConfigVo;
import com.jxdinfo.hussar.support.audit.core.config.AuditLogArchiveProperties;
import com.jxdinfo.hussar.support.audit.plugin.archive.utils.LocalDateTimeUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarDs(value="master")
public class AuditLogArchiveJobServiceImpl
implements ArchiveJobService {
    private static final Logger logger = LoggerFactory.getLogger(AuditLogArchiveJobServiceImpl.class);
    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private AuditLogArchiveProperties auditLogArchiveProperties;
    @Autowired
    private ArchiveBaseConfigService archiveBaseConfigService;

    public void archive() {
        if (!this.auditLogArchiveProperties.getEnable()) {
            logger.debug("\u5ba1\u8ba1\u65e5\u5fd7\u5f52\u6863\u672a\u5f00\u542f...");
            return;
        }
        List configs = this.archiveBaseConfigService.getArchiveConfigList();
        if (HussarUtils.isEmpty((Object)configs)) {
            throw new HussarException("\u5f52\u6863\u914d\u7f6e\u4e3a\u7a7a");
        }
        Map<String, ArchiveBaseConfig> configMap = configs.stream().collect(Collectors.toMap(ArchiveBaseConfig::getConfigKey, archiveBaseConfig -> archiveBaseConfig));
        ArrayList tableNames = Lists.newArrayList((Object[])new String[]{"SYS_SUPPORT_AUDIT_LOG", "SYS_SUPPORT_AUDIT_LOG_TABLE", "SYS_SUPPORT_AUDIT_LOG_COLUMN"});
        ArrayList configVos = Lists.newArrayListWithCapacity((int)configs.size());
        for (String tableName : tableNames) {
            ArchiveConfigVo configVo = new ArchiveConfigVo();
            configVo.setSourceTableName(tableName);
            configVo.setArchiveTablePrefix(tableName.replace("_SUPPORT", ""));
            int hotPeriod = Integer.parseInt(configMap.get("hot_archive_period").getConfigValue());
            int hotPeriodType = Integer.parseInt(configMap.get("hot_archive_period_type").getConfigValue());
            configVo.setWarmArchiveTime(LocalDateTimeUtils.calculateDateTime(hotPeriod, hotPeriodType));
            int warmPeriod = Integer.parseInt(configMap.get("warm_archive_period").getConfigValue());
            int warmPeriodType = Integer.parseInt(configMap.get("warm_archive_period_type").getConfigValue());
            configVo.setColdArchiveTime(LocalDateTimeUtils.calculateDateTime(warmPeriod, warmPeriodType));
            configVos.add(configVo);
        }
        this.archiveService.archiveData((List)configVos, ArchiveExecType.AUTO);
    }
}

