/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.archive.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.archive.enums.ArchiveExecType;
import com.jxdinfo.hussar.support.audit.core.archive.enums.ArchiveRecoverStatus;
import com.jxdinfo.hussar.support.audit.core.archive.enums.ArchiveStatus;
import com.jxdinfo.hussar.support.audit.core.archive.model.ArchiveBaseConfig;
import com.jxdinfo.hussar.support.audit.core.archive.model.ArchiveRecordEntity;
import com.jxdinfo.hussar.support.audit.core.archive.model.ArchiveRecoverEntity;
import com.jxdinfo.hussar.support.audit.core.archive.service.ArchiveBaseConfigService;
import com.jxdinfo.hussar.support.audit.core.archive.service.ArchiveRecordService;
import com.jxdinfo.hussar.support.audit.core.archive.service.ArchiveService;
import com.jxdinfo.hussar.support.audit.core.archive.service.RecoverService;
import com.jxdinfo.hussar.support.audit.core.archive.vo.ArchiveConfigVo;
import com.jxdinfo.hussar.support.audit.core.archive.vo.ArchiveRecordParam;
import com.jxdinfo.hussar.support.audit.core.archive.vo.ArchiveRecordVo;
import com.jxdinfo.hussar.support.audit.core.archive.vo.ArchiveRecoverVo;
import com.jxdinfo.hussar.support.audit.core.archive.vo.RecoverDataParam;
import com.jxdinfo.hussar.support.audit.core.config.AuditLogArchiveProperties;
import com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.service.ArchiveRecordDaoService;
import com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.service.ArchiveRecoverDaoService;
import com.jxdinfo.hussar.support.audit.plugin.archive.utils.LocalDateTimeUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarDs(value="master")
public class ArchiveRecordServiceImpl
implements ArchiveRecordService {
    @Autowired
    private ArchiveRecordDaoService archiveRecordDaoService;
    @Autowired
    private ArchiveBaseConfigService archiveBaseConfigService;
    @Autowired
    private ArchiveService archiveService;
    @Autowired
    private RecoverService recoverService;
    @Autowired
    private AuditLogArchiveProperties auditLogArchiveProperties;
    @Autowired
    private ArchiveRecoverDaoService archiveRecoverDaoService;

    public IPage<ArchiveRecordVo> selectPage(IPage<ArchiveRecordVo> page, ArchiveRecordParam recordParam) {
        IPage pageList;
        Page pageParams = new Page(page.getCurrent(), page.getSize());
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(HussarUtils.isNotBlank((CharSequence)recordParam.getSourceTableName()), ArchiveRecordEntity::getSourceTableName, (Object)recordParam.getSourceTableName().replace("%", "\\%"))).eq(HussarUtils.isNotEmpty((Object)recordParam.getArchiveDataType()), ArchiveRecordEntity::getArchiveType, (Object)recordParam.getArchiveDataType())).eq(HussarUtils.isNotEmpty((Object)recordParam.getArchiveExecType()), ArchiveRecordEntity::getArchiveExecType, (Object)recordParam.getArchiveExecType())).eq(HussarUtils.isNotEmpty((Object)recordParam.getArchiveStatus()), ArchiveRecordEntity::getArchiveStatus, (Object)recordParam.getArchiveStatus())).orderByDesc(ArchiveRecordEntity::getArchiveStartupTime)).orderByAsc(ArchiveRecordEntity::getSourceTableName);
        if (HussarUtils.isNotBlank((CharSequence)recordParam.getArchiveStartupTime())) {
            queryWrapper.ge(ArchiveRecordEntity::getArchiveStartupTime, (Object)LocalDateTime.parse(recordParam.getArchiveStartupTime(), dateTimeFormatter));
        }
        if (HussarUtils.isNotBlank((CharSequence)recordParam.getArchiveEndTime())) {
            queryWrapper.le(ArchiveRecordEntity::getArchiveEndTime, (Object)LocalDateTime.parse(recordParam.getArchiveEndTime(), dateTimeFormatter));
        }
        if (HussarUtils.isEmpty((Object)(pageList = this.archiveRecordDaoService.page((IPage)pageParams, (Wrapper)queryWrapper))) || HussarUtils.isEmpty((Object)pageList.getRecords())) {
            return new Page(page.getCurrent(), page.getSize());
        }
        Set<Object> recoverIds = Sets.newHashSetWithExpectedSize((int)pageList.getRecords().size());
        List archiveRecordIds = pageList.getRecords().stream().filter(archiveRecord -> ArchiveStatus.ARCHIVE_SUCCESS.getCode().equals(archiveRecord.getArchiveStatus())).map(ArchiveRecordEntity::getArchiveRecordId).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(archiveRecordIds)) {
            List failRecovers;
            ArrayList allRecovers = Lists.newArrayListWithCapacity((int)archiveRecordIds.size());
            List protectedRecovers = this.archiveRecoverDaoService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(ArchiveRecoverEntity::getArchiveRecordId, archiveRecordIds)).eq(ArchiveRecoverEntity::getRecoverStatus, (Object)ArchiveRecoverStatus.RECOVER_SUCCESS.getCode())).gt(ArchiveRecoverEntity::getDataStorageTime, (Object)LocalDateTime.now()));
            if (HussarUtils.isNotEmpty((Object)protectedRecovers)) {
                allRecovers.addAll(protectedRecovers);
            }
            if (HussarUtils.isNotEmpty((Object)(failRecovers = this.archiveRecoverDaoService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(ArchiveRecoverEntity::getArchiveRecordId, archiveRecordIds)).eq(ArchiveRecoverEntity::getRecoverStatus, (Object)ArchiveRecoverStatus.RECOVER_FAIL.getCode()))))) {
                allRecovers.addAll(failRecovers);
            }
            if (HussarUtils.isNotEmpty((Object)allRecovers)) {
                recoverIds = allRecovers.stream().map(ArchiveRecoverEntity::getArchiveRecordId).collect(Collectors.toSet());
            }
        }
        HashMap tableNameMap = Maps.newHashMapWithExpectedSize((int)3);
        tableNameMap.put("SYS_SUPPORT_AUDIT_LOG", Lists.newArrayList((Object[])new String[]{"SYS_SUPPORT_AUDIT_LOG_TABLE", "SYS_SUPPORT_AUDIT_LOG_COLUMN"}));
        tableNameMap.put("SYS_SUPPORT_AUDIT_LOG_TABLE", Lists.newArrayList((Object[])new String[]{"SYS_SUPPORT_AUDIT_LOG", "SYS_SUPPORT_AUDIT_LOG_COLUMN"}));
        tableNameMap.put("SYS_SUPPORT_AUDIT_LOG_COLUMN", Lists.newArrayList((Object[])new String[]{"SYS_SUPPORT_AUDIT_LOG", "SYS_SUPPORT_AUDIT_LOG_TABLE"}));
        List records = pageList.getRecords();
        ArrayList archiveConfigVos = Lists.newArrayListWithCapacity((int)records.size());
        HashSet finalRecoverIds = recoverIds;
        records.forEach(record -> {
            ArchiveRecordVo configVo = new ArchiveRecordVo();
            BeanUtil.copy((Object)record, (Object)configVo);
            configVo.setOtherTableNames((List)tableNameMap.get(configVo.getSourceTableName()));
            if (finalRecoverIds.contains(record.getArchiveRecordId())) {
                configVo.setRecovered(Boolean.TRUE);
            }
            archiveConfigVos.add(configVo);
        });
        Page pageResult = new Page(page.getCurrent(), page.getSize());
        pageResult.setRecords((List)archiveConfigVos);
        pageResult.setTotal(pageList.getTotal());
        return pageResult;
    }

    public Boolean archive(Long archiveRecordId) {
        ArchiveRecordEntity archiveRecordEntity = (ArchiveRecordEntity)this.archiveRecordDaoService.getById(archiveRecordId);
        if (HussarUtils.isEmpty((Object)archiveRecordEntity)) {
            throw new HussarException("\u5f52\u6863\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        if (!ArchiveStatus.ARCHIVE_FAIL.getCode().equals(archiveRecordEntity.getArchiveStatus())) {
            throw new HussarException("\u5f52\u6863\u72b6\u6001\u4e0d\u6b63\u786e");
        }
        String sourceTableName = archiveRecordEntity.getSourceTableName();
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ArchiveRecordEntity::getSourceTableName, (Object)sourceTableName)).eq(ArchiveRecordEntity::getArchiveStatus, (Object)ArchiveStatus.ARCHIVING.getCode())).eq(ArchiveRecordEntity::getArchiveStartupTime, (Object)archiveRecordEntity.getArchiveStartupTime())).eq(ArchiveRecordEntity::getArchiveEndTime, (Object)archiveRecordEntity.getArchiveEndTime());
        long count = this.archiveRecordDaoService.count((Wrapper)queryWrapper);
        if (count > 0L) {
            throw new HussarException("\u8be5\u8868\u6570\u636e\u6b63\u5728\u5f52\u6863\u4e2d");
        }
        queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ArchiveRecordEntity::getSourceTableName, (Object)sourceTableName)).eq(ArchiveRecordEntity::getArchiveStatus, (Object)ArchiveStatus.ARCHIVE_SUCCESS.getCode())).eq(ArchiveRecordEntity::getArchiveStartupTime, (Object)archiveRecordEntity.getArchiveStartupTime())).eq(ArchiveRecordEntity::getArchiveEndTime, (Object)archiveRecordEntity.getArchiveEndTime());
        count = this.archiveRecordDaoService.count((Wrapper)queryWrapper);
        if (count > 0L) {
            throw new HussarException("\u8be5\u8868\u6570\u636e\u5df2\u7ecf\u5f52\u6863\u6210\u529f");
        }
        LambdaQueryWrapper recoverQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ArchiveRecoverEntity::getArchiveRecordId, (Object)archiveRecordId)).eq(ArchiveRecoverEntity::getRecoverStatus, (Object)ArchiveRecoverStatus.RECOVER_SUCCESS.getCode())).gt(ArchiveRecoverEntity::getDataStorageTime, (Object)LocalDateTime.now());
        long recoverCount = this.archiveRecoverDaoService.count((Wrapper)recoverQueryWrapper);
        if (recoverCount > 0L) {
            throw new HussarException("\u8be5\u8868\u6570\u636e\u5df2\u7ecf\u6062\u590d\u4e14\u672a\u8d85\u8fc7\u4fdd\u62a4\u65f6\u95f4");
        }
        queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ArchiveRecordEntity::getSourceTableName, (Object)sourceTableName)).eq(ArchiveRecordEntity::getArchiveStatus, (Object)ArchiveStatus.ARCHIVE_SUCCESS.getCode())).eq(ArchiveRecordEntity::getArchiveStartupTime, (Object)archiveRecordEntity.getArchiveStartupTime())).gt(ArchiveRecordEntity::getArchiveEndTime, (Object)archiveRecordEntity.getArchiveEndTime());
        count = this.archiveRecordDaoService.count((Wrapper)queryWrapper);
        if (count > 0L) {
            throw new HussarException("\u8be5\u8868\u8be5\u6708\u4efd\u6570\u636e\u5df2\u7ecf\u5f52\u6863\u6210\u529f\uff0c\u65e0\u9700\u91cd\u590d\u5f52\u6863");
        }
        archiveRecordEntity.setArchiveStatus(ArchiveStatus.ARCHIVING.getCode());
        this.archiveRecordDaoService.updateById(archiveRecordEntity);
        ArchiveRecordVo archiveRecordVo = new ArchiveRecordVo();
        BeanUtil.copy((Object)archiveRecordEntity, (Object)archiveRecordVo);
        this.archiveService.archiveData((List)Lists.newArrayList((Object[])new ArchiveRecordVo[]{archiveRecordVo}));
        return Boolean.TRUE;
    }

    public Boolean recover(ArchiveRecoverVo archiveRecoverVo) {
        List recordEntities;
        YearMonth archiveEndMonth;
        Long archiveRecordId = archiveRecoverVo.getArchiveRecordId();
        ArchiveRecordEntity archiveRecordEntity = (ArchiveRecordEntity)this.archiveRecordDaoService.getById(archiveRecordId);
        if (HussarUtils.isEmpty((Object)archiveRecordEntity)) {
            return Boolean.FALSE;
        }
        if (!ArchiveStatus.ARCHIVE_SUCCESS.getCode().equals(archiveRecordEntity.getArchiveStatus())) {
            throw new HussarException("\u5f52\u6863\u72b6\u6001\u4e0d\u6b63\u786e");
        }
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ArchiveRecoverEntity::getSourceTableName, (Object)archiveRecordEntity.getSourceTableName())).eq(ArchiveRecoverEntity::getRecoverStatus, (Object)ArchiveRecoverStatus.RECOVERING.getCode())).eq(ArchiveRecoverEntity::getRecoverStartupTime, (Object)archiveRecordEntity.getArchiveStartupTime())).eq(ArchiveRecoverEntity::getRecoverEndTime, (Object)archiveRecordEntity.getArchiveEndTime());
        long count = this.archiveRecoverDaoService.count((Wrapper)queryWrapper);
        if (count > 0L) {
            throw new HussarException("\u8be5\u8868\u6570\u636e\u6b63\u5728\u6062\u590d\u4e2d");
        }
        queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ArchiveRecoverEntity::getSourceTableName, (Object)archiveRecordEntity.getSourceTableName())).eq(ArchiveRecoverEntity::getRecoverStatus, (Object)ArchiveRecoverStatus.RECOVER_SUCCESS.getCode())).eq(ArchiveRecoverEntity::getRecoverStartupTime, (Object)archiveRecordEntity.getArchiveStartupTime())).eq(ArchiveRecoverEntity::getRecoverEndTime, (Object)archiveRecordEntity.getArchiveEndTime())).gt(ArchiveRecoverEntity::getDataStorageTime, (Object)LocalDateTime.now());
        count = this.archiveRecoverDaoService.count((Wrapper)queryWrapper);
        if (count > 0L) {
            throw new HussarException("\u8be5\u8868\u6570\u636e\u5df2\u7ecf\u6062\u590d");
        }
        LocalDateTime archiveStartupTime = archiveRecordEntity.getArchiveStartupTime();
        LocalDateTime archiveEndTime = archiveRecordEntity.getArchiveEndTime();
        LambdaQueryWrapper archiveRecordQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ArchiveRecordEntity::getArchiveStatus, (Object)ArchiveStatus.ARCHIVE_SUCCESS.getCode())).eq(ArchiveRecordEntity::getArchiveStartupTime, (Object)archiveStartupTime);
        YearMonth currentMonth = YearMonth.from(LocalDateTime.now());
        if (!currentMonth.equals(archiveEndMonth = YearMonth.from(archiveStartupTime))) {
            archiveRecordQueryWrapper.eq(ArchiveRecordEntity::getArchiveEndTime, (Object)archiveEndTime);
        }
        if (HussarUtils.isEmpty((Object)(recordEntities = this.archiveRecordDaoService.list((Wrapper)archiveRecordQueryWrapper)))) {
            throw new HussarException("\u5f52\u6863\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        List archiveRecordVos = recordEntities.stream().map(record -> {
            ArchiveRecordVo archiveRecordVo = new ArchiveRecordVo();
            BeanUtil.copy((Object)record, (Object)archiveRecordVo);
            return archiveRecordVo;
        }).collect(Collectors.toList());
        LocalDateTime dataStorageTime = archiveRecoverVo.getDataStorageTime();
        RecoverDataParam recoverDataParam = new RecoverDataParam();
        recoverDataParam.setArchiveRecordVos(archiveRecordVos);
        recoverDataParam.setDataStorageTime(dataStorageTime);
        this.recoverService.recoverData(recoverDataParam);
        return Boolean.TRUE;
    }

    public Boolean archive(ArchiveExecType archiveExecType) {
        if (!this.auditLogArchiveProperties.getEnable()) {
            throw new HussarException("\u5ba1\u8ba1\u65e5\u5fd7\u5f52\u6863\u672a\u5f00\u542f");
        }
        List configs = this.archiveBaseConfigService.getArchiveConfigList();
        if (HussarUtils.isEmpty((Object)configs)) {
            throw new HussarException("\u5f52\u6863\u914d\u7f6e\u4e3a\u7a7a");
        }
        Map<String, ArchiveBaseConfig> configMap = configs.stream().collect(Collectors.toMap(ArchiveBaseConfig::getConfigKey, archiveBaseConfig -> archiveBaseConfig));
        ArrayList tableNames = Lists.newArrayList((Object[])new String[]{"SYS_SUPPORT_AUDIT_LOG", "SYS_SUPPORT_AUDIT_LOG_TABLE", "SYS_SUPPORT_AUDIT_LOG_COLUMN"});
        ArrayList configVos = Lists.newArrayListWithCapacity((int)configs.size());
        for (String tableName : tableNames) {
            ArchiveConfigVo configVo = new ArchiveConfigVo();
            configVo.setSourceTableName(tableName);
            configVo.setArchiveTablePrefix(tableName.replace("_SUPPORT", ""));
            int hotPeriod = Integer.parseInt(configMap.get("hot_archive_period").getConfigValue());
            int hotPeriodType = Integer.parseInt(configMap.get("hot_archive_period_type").getConfigValue());
            configVo.setWarmArchiveTime(LocalDateTimeUtils.calculateDateTime(hotPeriod, hotPeriodType));
            int warmPeriod = Integer.parseInt(configMap.get("warm_archive_period").getConfigValue());
            int warmPeriodType = Integer.parseInt(configMap.get("warm_archive_period_type").getConfigValue());
            configVo.setColdArchiveTime(LocalDateTimeUtils.calculateDateTime(warmPeriod, warmPeriodType));
            configVos.add(configVo);
        }
        this.archiveService.archiveData((List)configVos, HussarUtils.isEmpty((Object)archiveExecType) ? ArchiveExecType.AUTO : archiveExecType);
        return Boolean.TRUE;
    }
}

