/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.service.impl;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.auditlog.entity.AuditLogColumnEntity;
import com.jxdinfo.hussar.support.audit.plugin.archive.conditions.MybatisCondition;
import com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.dao.AuditLogColumnArchiveMapper;
import com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.service.AuditLogColumnArchiveDaoService;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@HussarDs(value="master")
@Conditional(value={MybatisCondition.class})
public class AuditLogColumnArchiveDaoServiceImpl
implements AuditLogColumnArchiveDaoService {
    private static final int MAX_BATCH_SIZE = 100;
    @Autowired
    private AuditLogColumnArchiveMapper auditLogColumnArchiveMapper;

    @Override
    public int batchInsert(String tableNamePrefix, String tableNameSuffix, List<AuditLogColumnEntity> auditLogColumnEntities) {
        if (HussarUtils.isEmpty(auditLogColumnEntities)) {
            return 0;
        }
        int size = auditLogColumnEntities.size();
        int batchIndex = size % 100 == 0 ? size / 100 : size / 100 + 1;
        for (int i = 0; i < batchIndex; ++i) {
            int start = i * 100;
            int end = (i + 1) * 100;
            end = Math.min(end, size);
            this.auditLogColumnArchiveMapper.batchInsert(tableNamePrefix, tableNameSuffix, auditLogColumnEntities.subList(start, end));
        }
        return size;
    }

    @Override
    public int deleteByCreateTime(String tableNamePrefix, String tableNameSuffix, LocalDateTime startTime, LocalDateTime endTime) {
        return this.auditLogColumnArchiveMapper.deleteByCreateTime(tableNamePrefix, tableNameSuffix, startTime, endTime);
    }

    @Override
    public List<AuditLogColumnEntity> selectByCreateTime(String tableNamePrefix, String tableNameSuffix, LocalDateTime startTime, LocalDateTime endTime) {
        return this.auditLogColumnArchiveMapper.selectListByCreateTime(tableNamePrefix, tableNameSuffix, startTime, endTime);
    }

    @Override
    public LocalDateTime selectMinCreateTime(LocalDateTime endTime) {
        return this.auditLogColumnArchiveMapper.selectMinCreateTime(endTime);
    }
}

