/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.IndexInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.factory.CreateTableHandlerFactory;
import com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.service.impl.AbstractArchiveCreateTableService;
import com.jxdinfo.hussar.support.audit.plugin.archive.utils.ColumnInfoDtoUtil;
import com.jxdinfo.hussar.support.mp.utils.MpUtils;
import java.sql.JDBCType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.stereotype.Service;

@Service(value="auditLogArchiveCreateTableService")
public class AuditLogArchiveCreateTableServiceImpl
extends AbstractArchiveCreateTableService {
    @Override
    protected TableInfoDto getTableInfo(String newTableName) {
        TableInfoDto tableInfoDto = new TableInfoDto();
        tableInfoDto.setTableName(newTableName);
        tableInfoDto.setTableDec("\u5ba1\u8ba1\u65e5\u5fd7\u5f52\u6863\u8868");
        tableInfoDto.setPollName("master");
        return tableInfoDto;
    }

    @Override
    protected List<ColumnInfoDto> getColumnInfoList() {
        ColumnInfoDtoUtil columnInfoDtoUtil = new ColumnInfoDtoUtil(Lists.newArrayListWithCapacity((int)41));
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "COMMIT_ID", "\u5f53\u6b21\u4f1a\u8bdd\u63d0\u4ea4\u552f\u4e00\u6807\u8bc6", 128L);
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "USER_NAME", "\u7528\u6237\u540d\u79f0", 32L);
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "NAME", "\u65e5\u5fd7\u540d\u79f0", 255L);
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "SERVER_ADDR", "\u670d\u52a1\u7aefip", 128L);
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "SERVER_PORT", "\u670d\u52a1\u7aef\u7aef\u53e3\u53f7", 8L);
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "SERVER_HOST", "\u670d\u52a1\u7aef\u4e3b\u673a\u540d", 128L);
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "PATH", "\u5168\u8def\u5f84", 2048L);
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "URL", "\u8bbf\u95ee\u8def\u5f84", 2048L);
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "SERVER_NAME", "\u670d\u52a1\u540d\u79f0", 128L);
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "MODULE_NAME", "\u6a21\u5757\u540d\u79f0", 128L);
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "PACKAGE_NAME", "\u5305\u540d", 1024L);
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "CLASS_NAME", "\u7c7b\u540d", 128L);
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "METHOD_NAME", "\u65b9\u6cd5\u540d\u79f0", 128L);
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "EVENT_DESC", "\u4e8b\u4ef6\u63cf\u8ff0", 255L);
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "REQUEST_METHOD", "\u8bf7\u6c42\u65b9\u5f0f\uff0cGET/POST", 16L);
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "TOKEN", "token", 1024L);
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "CLIENT_ADDR", "\u5ba2\u6237\u7aefip", 128L);
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "CLIENT_PORT", "\u5ba2\u6237\u7aef\u7aef\u53e3\u53f7", 8L);
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "CLIENT_HOST", "\u5ba2\u6237\u7aef\u4e3b\u673a\u540d", 128L);
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "THREAD_NAME", "\u7ebf\u7a0b\u540d\u79f0", 128L);
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "REMARK", "\u5907\u6ce8", 255L);
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "SERVER_VERSION", "\u670d\u52a1\u7248\u672c", 255L);
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "CREATOR_NAME", "\u521b\u5efa\u4eba\u59d3\u540d", 255L);
        columnInfoDtoUtil.add(JDBCType.VARCHAR, "LAST_EDITOR_NAME", "\u6700\u540e\u4e00\u6b21\u4fee\u6539\u4eba\u59d3\u540d", 255L);
        columnInfoDtoUtil.add(JDBCType.INTEGER, "EVENT_GRADE", "\u4e8b\u4ef6\u7ea7\u522b", 4L);
        columnInfoDtoUtil.add(JDBCType.INTEGER, "EVENT_TYPE", "\u4e8b\u4ef6\u7c7b\u578b", 4L);
        columnInfoDtoUtil.add(JDBCType.INTEGER, "SEVERITY_LEVEL", "\u4e8b\u4ef6\u4e25\u91cd\u7b49\u7ea7", 4L);
        columnInfoDtoUtil.add(JDBCType.INTEGER, "REQUEST_RESULT", "\u8bf7\u6c42\u7ed3\u679c", 4L);
        columnInfoDtoUtil.add(JDBCType.INTEGER, "TABLE_TOTAL", "\u4fee\u6539\u8868\u6570\u91cf", 11L);
        columnInfoDtoUtil.add(JDBCType.BIGINT, "AUDIT_LOG_ID", "\u4e3b\u952e", 20L);
        columnInfoDtoUtil.add(JDBCType.BIGINT, "USER_ID", "\u7528\u6237ID", 20L);
        columnInfoDtoUtil.add(JDBCType.BIGINT, "CREATOR", "\u521b\u5efa\u4eba", 20L);
        columnInfoDtoUtil.add(JDBCType.BIGINT, "LAST_EDITOR", "\u66f4\u65b0\u4eba", 20L);
        columnInfoDtoUtil.add(JDBCType.BIGINT, "TENANT_ID", "\u6240\u5c5e\u79df\u6237", 20L);
        columnInfoDtoUtil.add(JDBCType.CLOB, "REQUEST_PARAMS", "\u8bf7\u6c42\u53c2\u6570");
        columnInfoDtoUtil.add(JDBCType.CLOB, "EXCEPTION_INFO", "\u5f02\u5e38\u4fe1\u606f");
        columnInfoDtoUtil.add(JDBCType.TIMESTAMP, "ACCESS_TIME", "\u8bbf\u95ee\u65f6\u95f4");
        columnInfoDtoUtil.add(JDBCType.TIMESTAMP, "CREATE_TIME", "\u521b\u5efa\u65f6\u95f4");
        columnInfoDtoUtil.add(JDBCType.TIMESTAMP, "LAST_TIME", "\u66f4\u65b0\u65f6\u95f4");
        columnInfoDtoUtil.add(JDBCType.CHAR, "DEL_FLAG", "\u5220\u9664\u6807\u8bc6", 1L);
        HashMap consumerMap = Maps.newHashMapWithExpectedSize((int)2);
        consumerMap.put("TENANT_ID", action -> action.setDefaultValue("0"));
        consumerMap.put("DEL_FLAG", action -> action.setDefaultValue("0"));
        consumerMap.put("AUDIT_LOG_ID", action -> {
            action.setPk("1");
            action.setRequired("1");
        });
        List<ColumnInfoDto> result = columnInfoDtoUtil.getColumnInfoDtoList();
        result.forEach(action -> {
            if (consumerMap.containsKey(action.getColumnName())) {
                ((Consumer)consumerMap.get(action.getColumnName())).accept(action);
            }
        });
        return result;
    }

    @Override
    protected List<IndexInfoDto> getIndexInfoList() {
        ArrayList indexInfoList = Lists.newArrayListWithCapacity((int)2);
        IndexInfoDto indexInfoDto = new IndexInfoDto();
        indexInfoDto.setIndexColumns(Collections.singletonList("CREATE_TIME"));
        indexInfoDto.setUnique(false);
        indexInfoDto.setIndexName("IDX_" + MpUtils.idCreatorStr());
        indexInfoDto.setIndexComment("\u521b\u5efa\u65f6\u95f4\u7d22\u5f15");
        indexInfoList.add(indexInfoDto);
        return indexInfoList;
    }

    @Override
    protected void registerArchiveCreateTableService() {
        CreateTableHandlerFactory.register("SYS_SUPPORT_AUDIT_LOG", this);
    }
}

