/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.convertor;

import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.plugin.archive.mybatis.convertor.BaseDataTypeConvertor;
import java.sql.JDBCType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class KingBaseDataTypeConvertor
extends BaseDataTypeConvertor {
    private static final Map<String, Consumer<ColumnInfoDto>> JDBC_TYPE_2_METHOD = new ConcurrentHashMap<String, Consumer<ColumnInfoDto>>(8);

    private void init() {
        if (HussarUtils.isEmpty(JDBC_TYPE_2_METHOD)) {
            JDBC_TYPE_2_METHOD.put(JDBCType.CHAR.name(), action -> action.setDataType("char"));
            JDBC_TYPE_2_METHOD.put(JDBCType.VARCHAR.name(), action -> action.setDataType("varying"));
            JDBC_TYPE_2_METHOD.put(JDBCType.TIMESTAMP.name(), this::buildDateColumn);
            JDBC_TYPE_2_METHOD.put(JDBCType.CLOB.name(), action -> action.setDataType("text"));
            JDBC_TYPE_2_METHOD.put(JDBCType.INTEGER.name(), this::buildIntColumn);
            JDBC_TYPE_2_METHOD.put(JDBCType.BIGINT.name(), this::buildBigIntColumn);
        }
    }

    @Override
    protected List<ColumnInfoDto> convertDataTypeByJdbcType(List<ColumnInfoDto> columnInfos) {
        this.init();
        return columnInfos.stream().peek(action -> {
            String jdbcType = action.getJdbcType();
            Consumer<ColumnInfoDto> columnInfoDtoConsumer = JDBC_TYPE_2_METHOD.get(jdbcType);
            if (ObjectUtils.isNull((Object[])new Object[]{columnInfoDtoConsumer})) {
                throw new IllegalStateException(String.format("\u6682\u4e0d\u652f\u6301\u7c7b\u578b%s", jdbcType));
            }
            columnInfoDtoConsumer.accept((ColumnInfoDto)action);
        }).collect(Collectors.toList());
    }

    private void buildDateColumn(ColumnInfoDto action) {
        action.setDataType("TIMESTAMP");
        action.setDataLength(Optional.ofNullable(action.getDataLength()).orElse(6L));
    }

    private void buildIntColumn(ColumnInfoDto action) {
        action.setDataType("numeric");
        action.setDataDot(Optional.ofNullable(action.getDataDot()).orElse(0));
    }

    private void buildBigIntColumn(ColumnInfoDto action) {
        action.setDataType("numeric");
        action.setDataDot(Optional.ofNullable(action.getDataDot()).orElse(0));
    }
}

