/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.audit.plugin.archive.mongo.service.impl;

import com.google.common.collect.Maps;
import com.jxdinfo.hussar.support.audit.plugin.archive.conditions.MongoCondition;
import com.jxdinfo.hussar.support.audit.plugin.archive.service.ArchiveCreateTableService;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.index.Index;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.stereotype.Service;

@Service(value="archiveCreateTableMongoService")
@HussarDs(value="master")
@Conditional(value={MongoCondition.class})
public class ArchiveCreateTableMongoServiceImpl
implements ArchiveCreateTableService {
    private static final Logger logger = LoggerFactory.getLogger(ArchiveCreateTableMongoServiceImpl.class);
    private static final Map<String, String> TABLE_NAME_MAP = Maps.newHashMapWithExpectedSize((int)3);
    @Autowired
    private MongoTemplate mongoTemplate;

    @Override
    public Boolean checkTableExist(String tableName, String originTableName) {
        logger.debug("\u68c0\u67e5\u8868\u662f\u5426\u5b58\u5728\uff1a{}", (Object)tableName);
        return this.mongoTemplate.collectionExists(tableName);
    }

    @Override
    public void createTable(String newTableName, String originTableName) {
        logger.debug("\u521b\u5efa\u8868\uff1a{}", (Object)newTableName);
        List indexInfoList = this.mongoTemplate.indexOps(originTableName).getIndexInfo();
        String tableNameSuffix = originTableName.substring(originTableName.lastIndexOf("_") + 1);
        String tableNamePrefix = TABLE_NAME_MAP.get(originTableName);
        indexInfoList.stream().filter(indexInfo -> !"_id".equals(indexInfo.getName())).forEach(indexInfo -> {
            Index indexDefinition = new Index();
            indexInfo.getIndexFields().forEach(indexField -> indexDefinition.on(indexField.getKey(), indexField.getDirection() != null ? indexField.getDirection() : Sort.Direction.ASC));
            indexDefinition.named(indexInfo.getName());
            indexInfo.getExpireAfter().ifPresent(arg_0 -> ((Index)indexDefinition).expire(arg_0));
            if (indexInfo.isUnique()) {
                indexDefinition.unique();
            }
            if (indexInfo.isSparse()) {
                indexDefinition.sparse();
            }
            this.mongoTemplate.indexOps(tableNamePrefix + tableNameSuffix).ensureIndex((IndexDefinition)indexDefinition);
        });
    }

    static {
        TABLE_NAME_MAP.put("SYS_SUPPORT_AUDIT_LOG", "auditLogEntity");
        TABLE_NAME_MAP.put("SYS_SUPPORT_AUDIT_LOG_TABLE", "auditLogTableEntity");
        TABLE_NAME_MAP.put("SYS_SUPPORT_AUDIT_LOG_COLUMN", "auditLogColumnEntity");
    }
}

