/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.monitor.spring.boot.autoconfigure.stat;

import com.jxdinfo.hussar.monitor.spring.boot.autoconfigure.properties.HussarMonitorProperties;
import com.jxdinfo.hussar.monitor.web.servlet.DispatchServlet;
import javax.servlet.Servlet;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;

@ConditionalOnWebApplication
@ConditionalOnProperty(name={"hussar.monitor.stat-view-servlet.enabled"}, havingValue="true", matchIfMissing=true)
public class HussarMonitorServletConfiguration {
    @Bean
    public ServletRegistrationBean statViewServletRegistrationBean(HussarMonitorProperties properties) {
        HussarMonitorProperties.StatViewServlet config = properties.getStatViewServlet();
        ServletRegistrationBean registrationBean = new ServletRegistrationBean();
        registrationBean.setServlet((Servlet)new DispatchServlet());
        registrationBean.addUrlMappings(new String[]{config.getUrlPattern() != null ? config.getUrlPattern() : "/smon/*"});
        if (config.getPackages() != null) {
            registrationBean.addInitParameter("package", config.getPackages());
        }
        if (config.getLocal() != null) {
            registrationBean.addInitParameter("local", config.getLocal());
        }
        if (config.getHosts() != null) {
            registrationBean.addInitParameter("hosts", config.getHosts());
        }
        if (config.getHtmlPath() != null) {
            registrationBean.addInitParameter("htmlPath", config.getHtmlPath());
        } else {
            registrationBean.addInitParameter("htmlPath", "/smon/index.html");
        }
        return registrationBean;
    }
}

