/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.monitor.spring.boot.autoconfigure.stat;

import com.jxdinfo.hussar.monitor.spring.boot.autoconfigure.properties.HussarMonitorProperties;
import com.jxdinfo.hussar.monitor.web.filter.CharacterEncodingFilter;
import javax.servlet.Filter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;

@ConditionalOnWebApplication
@ConditionalOnProperty(name={"hussar.monitor.web-stat-filter.enabled"}, havingValue="true", matchIfMissing=true)
public class HussarMonitorFilterConfiguration {
    @Bean
    public FilterRegistrationBean webStatFilterRegistrationBean(HussarMonitorProperties properties) {
        HussarMonitorProperties.WebStatFilter config = properties.getWebStatFilter();
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        CharacterEncodingFilter filter = new CharacterEncodingFilter();
        registrationBean.setFilter((Filter)filter);
        registrationBean.addUrlPatterns(new String[]{config.getUrlPattern() != null ? config.getUrlPattern() : "/*"});
        registrationBean.addInitParameter("exclusions", config.getExclusions() != null ? config.getExclusions() : "*.js,*.gif,*.jpg,*.png,*.css,*.ico");
        if (config.getEncoding() != null) {
            registrationBean.addInitParameter("encoding", config.getEncoding());
        }
        return registrationBean;
    }
}

