<el-collapse
        v-loading="${instanceKey!}CollapseLoading"
        v-model="${instanceKey!}ActiveNames"
        :accordion="${instanceKey!}Accordion">
    <template v-for="(${instanceKey!}CollapseItem, ${instanceKey!}Index) in ${valueData!}">
        <#list statusConfig as statusItem>
            <#if statusItem??>
                <template
                        <#if statusItem.condition?? && statusItem_index==0>
                            v-if="${instanceKey!}Condition${statusItem_index}(${instanceKey!}Index, ${instanceKey!}CollapseItem)"
                        <#elseif statusItem.condition??>
                            v-else-if="${instanceKey!}Condition${statusItem_index}(${instanceKey!}Index, ${instanceKey!}CollapseItem)"
                        </#if>>
                    <el-collapse-item
                            :name="<#if primaryKey??>${instanceKey!}CollapseItem.${primaryKey}<#else>${instanceKey!}Index</#if>"
                            :key="${instanceKey!}Index">
                        <template slot="title">
                            <#if default && !slotCodes[statusItem.slotConfig.titleSlotName]??>
                                <div class="header-tip" @click.stop="">暂无标题</div>
                            <#else>
                                <div class="collapse-element-head" @click.stop="">
                                    ${slotCodes[statusItem.slotConfig.titleSlotName]!}
                                </div>
                            </#if>
                        </template>
                        <div class="collapse-content"
                            <#if statusItem.contentLayout=='autoHeight'>
                                style="height:auto;padding:${statusItem.contentPadding!0}"
                            <#else>
                                style="height:${statusItem.contentHeight!200}px;"
                            </#if>>
                            <#if default && !slotCodes[statusItem.slotConfig.contentSlotName]??>
                                <div class="content-tip">
                                    暂无数据
                                </div>
                            <#else>
                                ${slotCodes[statusItem.slotConfig.contentSlotName]!}
                            </#if>
                        </div>
                    </el-collapse-item>
                </template>
            </#if>
        </#list>
    </template>
    <#if default>
        <template v-if="${valueData!}.length===0">
            <el-collapse-item name="0">
                <template slot="title">
                    <div class="header-tip" @click.stop="">暂无标题</div>
                </template>
                <div class="collapse-content" style="height:200px;">
                    <div class="content-tip">
                        暂无数据
                    </div>
                </div>
            </el-collapse-item>
        </template>
    </#if>
</el-collapse>