/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.pubplat.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.mail.core.bean.BeanUtil;
import com.jxdinfo.hussar.mail.core.date.DateUtil;
import com.jxdinfo.hussar.mail.core.util.StrUtil;
import com.jxdinfo.hussar.pubplat.dao.PubPlatMapper;
import com.jxdinfo.hussar.pubplat.dao.PubPlatTypeMapper;
import com.jxdinfo.hussar.pubplat.model.PageDTO;
import com.jxdinfo.hussar.pubplat.model.Result;
import com.jxdinfo.hussar.pubplat.model.SuperEntity;
import com.jxdinfo.hussar.pubplat.model.pubplat.PubPlatDO;
import com.jxdinfo.hussar.pubplat.model.type.PubPlatTypeDO;
import com.jxdinfo.hussar.pubplat.model.type.PubPlatTypeDTO;
import com.jxdinfo.hussar.pubplat.service.PubPlatTypeService;
import com.jxdinfo.hussar.pubplat.util.StringUtil;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PubPlatTypeServiceImpl
extends ServiceImpl<PubPlatTypeMapper, PubPlatTypeDO>
implements PubPlatTypeService {
    @Resource
    private PubPlatTypeMapper pubPlatTypeMapper;
    @Resource
    private PubPlatMapper pubPlatMapper;

    @Override
    public Result<Boolean> saveType(PubPlatTypeDTO pubPlatTypeDTO) {
        PubPlatTypeDO pubPlatTypeDO = new PubPlatTypeDO();
        BeanUtil.copyProperties((Object)pubPlatTypeDTO, (Object)pubPlatTypeDO);
        pubPlatTypeDO.setTypeId(UUID.randomUUID().toString().toUpperCase());
        pubPlatTypeDO.setCreateTime(DateUtil.now());
        pubPlatTypeDO.setModifyTime(DateUtil.now());
        pubPlatTypeDO.setCreateUserName(ShiroKit.getUser().getName());
        pubPlatTypeDO.setCreateUserID(ShiroKit.getUser().getId());
        pubPlatTypeDO.setOrganiseId(ShiroKit.getUser().getDeptId());
        PageDTO<PubPlatTypeDO> pageDTO = new PageDTO<PubPlatTypeDO>();
        pageDTO.setPageNum(1);
        pageDTO.setPageSize(1);
        PageDTO<PubPlatTypeDO> page = this.pubPlatTypeMapper.listTypes(pageDTO, (Wrapper<PubPlatTypeDO>)((Wrapper)new QueryWrapper().lambda().orderByDesc(PubPlatTypeDO::getShowOrder)));
        pubPlatTypeDO.setShowOrder(page.getTotal() == 0L ? 0 : page.getRecords().get(0).getShowOrder() + 1);
        this.save(pubPlatTypeDO);
        return Result.succeed(true);
    }

    @Override
    public PageDTO<PubPlatTypeDO> listTypes(PageDTO<PubPlatTypeDO> pageDTO, String typeName) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StrUtil.isNotEmpty((CharSequence)typeName)) {
            queryWrapper.like((Object)"type_name", (Object)StringUtil.replaceSpecialChar(typeName.trim()));
        }
        queryWrapper.orderByAsc((Object)"type_show_order");
        return this.pubPlatTypeMapper.listTypes(pageDTO, (Wrapper<PubPlatTypeDO>)queryWrapper);
    }

    @Override
    public Result<Boolean> updateType(PubPlatTypeDO pubPlatTypeDO) {
        if (StrUtil.isEmpty((CharSequence)pubPlatTypeDO.getTypeName())) {
            Result.failed("\u5fae\u5e94\u7528\u5206\u7c7b\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a");
        }
        pubPlatTypeDO.setModifyTime(DateUtil.now());
        this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().eq(PubPlatTypeDO::getTypeId, (Object)pubPlatTypeDO.getTypeId())).set(PubPlatTypeDO::getTypeName, (Object)pubPlatTypeDO.getTypeName())).set(SuperEntity::getModifyTime, (Object)DateUtil.now()));
        return Result.succeed(true);
    }

    @Override
    public Result<Boolean> removeType(String typeIds) {
        List<String> list = Arrays.asList(typeIds.split(","));
        int count = this.pubPlatMapper.selectCount((Wrapper)new QueryWrapper().lambda().in(PubPlatDO::getCategoryId, list));
        if (count > 0 && list.size() > 1) {
            return Result.failed("\u65e0\u6cd5\u5220\u9664\uff01\uff08\u5b58\u5728\u5df2\u5173\u8054\u5fae\u5e94\u7528\u7684\u5206\u7c7b!\uff09");
        }
        if (count > 0 && list.size() == 1) {
            return Result.failed("\u65e0\u6cd5\u5220\u9664\uff01\uff08\u5206\u7c7b\u5df2\u5173\u8054\u5fae\u5e94\u7528\uff01\uff09");
        }
        this.remove((Wrapper)new QueryWrapper().lambda().in(PubPlatTypeDO::getTypeId, list));
        return Result.succeed(true);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public Result<Boolean> updateShowOrder(String littleId, String largeId, String upDown) {
        Integer little = this.pubPlatTypeMapper.getShowOrder(littleId);
        Integer large = this.pubPlatTypeMapper.getShowOrder(largeId);
        if ("0".equals(upDown)) {
            this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().ge(PubPlatTypeDO::getShowOrder, (Object)little)).le(PubPlatTypeDO::getShowOrder, (Object)large)).setSql("type_show_order=type_show_order+1"));
            this.update((Wrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().eq(PubPlatTypeDO::getTypeId, (Object)largeId)).set(PubPlatTypeDO::getShowOrder, (Object)little));
        }
        if ("1".equals(upDown)) {
            this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().ge(PubPlatTypeDO::getShowOrder, (Object)little)).le(PubPlatTypeDO::getShowOrder, (Object)large)).setSql("type_show_order=type_show_order-1"));
            this.update((Wrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().eq(PubPlatTypeDO::getTypeId, (Object)littleId)).set(PubPlatTypeDO::getShowOrder, (Object)large));
        }
        return Result.succeed(true);
    }
}

