/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.pubplat.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.mail.core.collection.CollUtil;
import com.jxdinfo.hussar.mail.core.date.DateUtil;
import com.jxdinfo.hussar.mail.core.util.StrUtil;
import com.jxdinfo.hussar.pubplat.dao.PubPlatPermissionMapper;
import com.jxdinfo.hussar.pubplat.dao.UserRoleMapper;
import com.jxdinfo.hussar.pubplat.model.AuthorizeDTO;
import com.jxdinfo.hussar.pubplat.model.UserRoleVO;
import com.jxdinfo.hussar.pubplat.model.pubplat.PubPlatPermissionDO;
import com.jxdinfo.hussar.pubplat.service.PubPlatPermissionService;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PubPlatPermissionServiceImpl
extends ServiceImpl<PubPlatPermissionMapper, PubPlatPermissionDO>
implements PubPlatPermissionService {
    @Resource
    private PubPlatPermissionMapper pubPlatPermissionMapper;
    @Resource
    private UserRoleMapper userRoleMapper;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void savePubPlatPermission(AuthorizeDTO authorizeDTO) {
        PubPlatPermissionDO pubPlatPermissionDO;
        ArrayList<PubPlatPermissionDO> list;
        this.remove((Wrapper)new QueryWrapper().lambda().eq(PubPlatPermissionDO::getBId, (Object)authorizeDTO.getPubPlatID()));
        if (StrUtil.isNotEmpty((CharSequence)authorizeDTO.getUserIDs())) {
            list = new ArrayList<PubPlatPermissionDO>();
            for (String i : authorizeDTO.getUserIDs().split(",")) {
                pubPlatPermissionDO = new PubPlatPermissionDO();
                pubPlatPermissionDO.setPermitId(UUID.randomUUID().toString().toUpperCase());
                pubPlatPermissionDO.setPermitType(1);
                pubPlatPermissionDO.setObjId(i);
                pubPlatPermissionDO.setBId(authorizeDTO.getPubPlatID());
                pubPlatPermissionDO.setModifyTime(DateUtil.now());
                pubPlatPermissionDO.setCreateTime(DateUtil.now());
                list.add(pubPlatPermissionDO);
            }
            this.saveBatch(list);
        }
        if (StrUtil.isNotEmpty((CharSequence)authorizeDTO.getRoleIDs())) {
            list = new ArrayList();
            for (String i : authorizeDTO.getRoleIDs().split(",")) {
                pubPlatPermissionDO = new PubPlatPermissionDO();
                pubPlatPermissionDO.setPermitId(UUID.randomUUID().toString().toUpperCase());
                pubPlatPermissionDO.setPermitType(3);
                pubPlatPermissionDO.setObjId(i);
                pubPlatPermissionDO.setBId(authorizeDTO.getPubPlatID());
                pubPlatPermissionDO.setModifyTime(DateUtil.now());
                pubPlatPermissionDO.setCreateTime(DateUtil.now());
                list.add(pubPlatPermissionDO);
            }
            this.saveBatch(list);
        }
    }

    @Override
    public UserRoleVO getUserRoleVO(String pubId) {
        UserRoleVO userRoleVO = new UserRoleVO();
        List<String> usrIds = this.pubPlatPermissionMapper.getPermittedUserId(pubId);
        List<String> roleIds = this.pubPlatPermissionMapper.getPermittedRoleId(pubId);
        if (CollUtil.isNotEmpty(usrIds)) {
            userRoleVO.setUser(this.userRoleMapper.getUsersByIds(usrIds));
        }
        if (CollUtil.isNotEmpty(roleIds)) {
            userRoleVO.setRole(this.userRoleMapper.getRoleByIds(roleIds));
        }
        return userRoleVO;
    }
}

