/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.pubplat.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.mail.core.bean.BeanUtil;
import com.jxdinfo.hussar.mail.core.collection.CollUtil;
import com.jxdinfo.hussar.mail.core.date.DateUtil;
import com.jxdinfo.hussar.mail.core.util.StrUtil;
import com.jxdinfo.hussar.pubplat.dao.HeadImgMapper;
import com.jxdinfo.hussar.pubplat.dao.IPubPlatMapper;
import com.jxdinfo.hussar.pubplat.dao.OperateMapper;
import com.jxdinfo.hussar.pubplat.dao.PubPlatPermissionMapper;
import com.jxdinfo.hussar.pubplat.dao.PubPlatTypeMapper;
import com.jxdinfo.hussar.pubplat.dao.UserRoleMapper;
import com.jxdinfo.hussar.pubplat.model.PageDTO;
import com.jxdinfo.hussar.pubplat.model.Result;
import com.jxdinfo.hussar.pubplat.model.SearchParamDTO;
import com.jxdinfo.hussar.pubplat.model.UserVO;
import com.jxdinfo.hussar.pubplat.model.enums.PubType;
import com.jxdinfo.hussar.pubplat.model.file.HeadingImgDO;
import com.jxdinfo.hussar.pubplat.model.file.PubPlatCodeFileDO;
import com.jxdinfo.hussar.pubplat.model.pubplat.PubPlatDO;
import com.jxdinfo.hussar.pubplat.model.pubplat.PubPlatDTO;
import com.jxdinfo.hussar.pubplat.model.pubplat.PubPlatOperateDO;
import com.jxdinfo.hussar.pubplat.model.pubplat.PubPlatPermissionDO;
import com.jxdinfo.hussar.pubplat.service.CodeFileService;
import com.jxdinfo.hussar.pubplat.service.HeadImgService;
import com.jxdinfo.hussar.pubplat.service.IPubPlatService;
import com.jxdinfo.hussar.pubplat.util.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class IPubPlatServiceImpl
extends ServiceImpl<IPubPlatMapper, PubPlatDO>
implements IPubPlatService {
    @Resource
    private IPubPlatMapper iPubPlatMapper;
    @Resource
    private OperateMapper operateMapper;
    @Resource
    private HeadImgMapper headImgMapper;
    @Resource
    private CodeFileService codeFileService;
    @Resource
    private HeadImgService headImgService;
    @Resource
    private PubPlatPermissionMapper permissionMapper;
    @Resource
    private UserRoleMapper userRoleMapper;
    @Resource
    private PubPlatTypeMapper pubPlatTypeMapper;

    @Override
    public PageDTO<PubPlatDO> getPubPlatList(String searchKey, PageDTO<PubPlatDO> pageDTO, String classifyId, String pubType) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!ShiroKit.isAdmin()) {
            List<String> operatePubId = this.operateMapper.getPubIds(ShiroKit.getUser().getId());
            if (CollUtil.isEmpty(operatePubId)) {
                pageDTO.setPageCount(0);
                return pageDTO;
            }
            queryWrapper.in((Object)"t1.pub_id", this.operateMapper.getPubIds(ShiroKit.getUser().getId()));
        }
        if (!StrUtil.isEmpty((CharSequence)searchKey)) {
            queryWrapper.like((Object)"t1.pub_name", (Object)StringUtil.replaceSpecialChar(searchKey.trim()));
        }
        if (!StrUtil.isEmpty((CharSequence)classifyId)) {
            queryWrapper.eq((Object)"t1.pub_category_id", (Object)classifyId);
        }
        if (!StrUtil.isEmpty((CharSequence)pubType)) {
            queryWrapper.eq((Object)"t1.pub_type", (Object)Integer.valueOf(pubType));
        }
        queryWrapper.orderByAsc((Object)"t1.pub_show_order");
        return this.iPubPlatMapper.getPubPlatList(pageDTO, (Wrapper<PubPlatDO>)queryWrapper);
    }

    @Override
    public PubPlatDTO getPubPlat(String pubPlatId) {
        PubPlatDTO pubPlatDTO;
        pubPlatDTO.setAssistInfo(StrUtil.isNotEmpty((CharSequence)(pubPlatDTO = this.iPubPlatMapper.getPubPlatDTO(pubPlatId)).getAssistInfo()) ? pubPlatDTO.getAssistInfo().replace(" ", "") : pubPlatDTO.getAssistInfo());
        pubPlatDTO.setImg(this.headImgMapper.getHeadImage(pubPlatId));
        pubPlatDTO.setPath(StrUtil.isEmpty((CharSequence)pubPlatDTO.getPath()) ? "" : pubPlatDTO.getPath());
        pubPlatDTO.setCategoryName(this.pubPlatTypeMapper.getTypeById(pubPlatDTO.getCategoryId()).getTypeName());
        pubPlatDTO.setFileBeanList(this.codeFileService.listFile((Wrapper<PubPlatCodeFileDO>)((Wrapper)new QueryWrapper().lambda().eq(PubPlatCodeFileDO::getPubId, (Object)pubPlatId))));
        return pubPlatDTO;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public Result<Boolean> savePubPlat(PubPlatDTO pubPlatDTO) {
        PubPlatDO pubPlatDO = new PubPlatDO();
        BeanUtil.copyProperties((Object)pubPlatDTO, (Object)pubPlatDO);
        if (StrUtil.isEmpty((CharSequence)pubPlatDTO.getObjID())) {
            pubPlatDO.setObjId(UUID.randomUUID().toString().toUpperCase());
        } else {
            pubPlatDO.setObjId(pubPlatDTO.getObjID());
            HeadingImgDO headingImgDO = pubPlatDTO.getImg();
            headingImgDO.setObjId(pubPlatDO.getObjId());
            this.saveOrUpdateHeadImg(headingImgDO);
        }
        pubPlatDO.setHomePage(Integer.valueOf(pubPlatDTO.getHomePage()));
        PageDTO<PubPlatDO> page = new PageDTO<PubPlatDO>();
        page.setPageSize(1);
        page.setPageNum(1);
        page = this.iPubPlatMapper.getPubPlatList(page, (Wrapper<PubPlatDO>)((Wrapper)new QueryWrapper().lambda().orderByDesc(PubPlatDO::getShowOrder)));
        if (page.getTotal() > 0L) {
            pubPlatDO.setShowOrder(page.getRecords().get(0).getShowOrder() + 1);
        } else {
            pubPlatDO.setShowOrder(0);
        }
        pubPlatDO.setPubType(Integer.valueOf(pubPlatDTO.getPubType()));
        pubPlatDO.setCreateTime(DateUtil.now());
        pubPlatDO.setModifyTime(DateUtil.now());
        pubPlatDO.setUpdateTime(DateUtil.now());
        pubPlatDO.setSecretKey(UUID.randomUUID().toString().substring(0, 16));
        if (String.valueOf(PubType.WEBAPP.ordinal()).equals(pubPlatDTO.getPubType())) {
            pubPlatDO.setPath(pubPlatDTO.getPath());
        }
        if (CollUtil.isNotEmpty(pubPlatDTO.getFileBeanList()) && String.valueOf(PubType.HYBRIDAPP.ordinal()).equals(pubPlatDTO.getPubType())) {
            pubPlatDTO.getFileBeanList().forEach(i -> this.pubPlatCodeFileDO((PubPlatCodeFileDO)i, pubPlatDO.getObjId()));
            this.codeFileService.saveBatch(pubPlatDTO.getFileBeanList());
        }
        this.save(pubPlatDO);
        return Result.succeed(true);
    }

    private void saveOrUpdateHeadImg(HeadingImgDO headingImgDO) {
        headingImgDO.setCreateTime(DateUtil.now());
        headingImgDO.setModifyTime(DateUtil.now());
        this.headImgService.saveOrUpdate(headingImgDO);
    }

    @Override
    public Result<Boolean> updatePubPlat(PubPlatDTO pubPlatDTO) {
        PubPlatDO pubPlatDO = new PubPlatDO();
        pubPlatDO.setObjId(pubPlatDTO.getObjID());
        pubPlatDO.setName(pubPlatDTO.getName());
        pubPlatDO.setIntroduce(pubPlatDTO.getIntroduce());
        pubPlatDO.setPubType(Integer.valueOf(pubPlatDTO.getPubType()));
        pubPlatDO.setHomePage(Integer.valueOf(pubPlatDTO.getHomePage()));
        pubPlatDO.setPath(pubPlatDTO.getPath());
        pubPlatDO.setIsDefault(pubPlatDTO.getIsDefault());
        pubPlatDO.setAssistInfo(pubPlatDTO.getAssistInfo());
        pubPlatDO.setCategoryId(pubPlatDTO.getCategoryId());
        pubPlatDO.setSecretKey(pubPlatDTO.getSecretKey());
        pubPlatDO.setModifyTime(DateUtil.now());
        if (pubPlatDTO.getImg() != null) {
            pubPlatDTO.getImg().setObjId(pubPlatDTO.getObjID());
            this.saveOrUpdateHeadImg(pubPlatDTO.getImg());
            pubPlatDO.setUpdateTime(DateUtil.now());
        } else {
            this.headImgMapper.deleteById((Serializable)((Object)pubPlatDTO.getObjID()));
        }
        this.updateCodeFile(pubPlatDTO);
        this.updateById(pubPlatDO);
        return Result.succeed(true);
    }

    private void updateCodeFile(PubPlatDTO pubPlatDTO) {
        boolean androidChange = "1".equals(pubPlatDTO.getAndroidChange());
        boolean iosChange = "1".equals(pubPlatDTO.getIosChange());
        boolean pcChange = "1".equals(pubPlatDTO.getPcChange());
        if (!(androidChange || iosChange || pcChange)) {
            return;
        }
        this.codeFileService.remove((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(PubPlatCodeFileDO::getPubId, (Object)pubPlatDTO.getObjID())).and(i -> {
            if (androidChange) {
                ((LambdaQueryWrapper)i.eq(PubPlatCodeFileDO::getType, (Object)"0")).or();
            }
            if (iosChange) {
                ((LambdaQueryWrapper)i.eq(PubPlatCodeFileDO::getType, (Object)"1")).or();
            }
            if (pcChange) {
                i.eq(PubPlatCodeFileDO::getType, (Object)"2");
            }
        }));
        ArrayList list = new ArrayList();
        pubPlatDTO.getFileBeanList().forEach(i -> {
            if (androidChange && i.getType() == 0 || iosChange && i.getType() == 1 || pcChange && i.getType() == 2) {
                this.pubPlatCodeFileDO((PubPlatCodeFileDO)i, pubPlatDTO.getObjID());
                list.add(i);
            }
        });
        if (list.size() > 0) {
            this.codeFileService.saveBatch(list);
        }
    }

    private void pubPlatCodeFileDO(PubPlatCodeFileDO pubPlatCodeFileDO, String pubId) {
        pubPlatCodeFileDO.setCreateTime(DateUtil.now());
        pubPlatCodeFileDO.setModifyTime(DateUtil.now());
        pubPlatCodeFileDO.setObjID(UUID.randomUUID().toString().toUpperCase());
        pubPlatCodeFileDO.setPubId(pubId);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public boolean deletePubPlat(String id) {
        ArrayList idList = CollUtil.toList((Object[])id.split(","));
        this.permissionMapper.delete((Wrapper)new QueryWrapper().lambda().in(PubPlatPermissionDO::getBId, (Collection)idList));
        this.codeFileService.remove((Wrapper)new QueryWrapper().lambda().in(PubPlatCodeFileDO::getPubId, (Collection)idList));
        this.headImgMapper.delete((Wrapper)new QueryWrapper().lambda().in(HeadingImgDO::getObjId, (Collection)idList));
        this.operateMapper.delete((Wrapper)new QueryWrapper().lambda().in(PubPlatOperateDO::getPubId, (Collection)idList));
        this.remove((Wrapper)new QueryWrapper().lambda().in(PubPlatDO::getObjId, (Collection)idList));
        return true;
    }

    @Override
    public Boolean updateKey(String id) {
        String secretKey = UUID.randomUUID().toString().substring(0, 16).toUpperCase();
        if (this.count((Wrapper)new QueryWrapper().lambda().eq(PubPlatDO::getSecretKey, (Object)secretKey)) == 0) {
            PubPlatDO pubPlat = new PubPlatDO();
            pubPlat.setObjId(id);
            pubPlat.setSecretKey(secretKey);
            pubPlat.setModifyTime(DateUtil.now());
            this.updateById(pubPlat);
            return true;
        }
        return this.updateKey(id);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public Result<Boolean> updateShowOrder(String littleId, String largeId, String upDown) {
        Integer little = this.iPubPlatMapper.getShowOrder(littleId);
        Integer large = this.iPubPlatMapper.getShowOrder(largeId);
        if ("0".equals(upDown)) {
            this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().ge(PubPlatDO::getShowOrder, (Object)little)).le(PubPlatDO::getShowOrder, (Object)large)).setSql("pub_show_order=pub_show_order+1"));
            this.update((Wrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().eq(PubPlatDO::getObjId, (Object)largeId)).set(PubPlatDO::getShowOrder, (Object)little));
        }
        if ("1".equals(upDown)) {
            this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().ge(PubPlatDO::getShowOrder, (Object)little)).le(PubPlatDO::getShowOrder, (Object)large)).setSql("pub_show_order=pub_show_order-1"));
            this.update((Wrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().eq(PubPlatDO::getObjId, (Object)littleId)).set(PubPlatDO::getShowOrder, (Object)large));
        }
        return Result.succeed(true);
    }

    @Override
    public PageDTO<UserVO> pageUsers(SearchParamDTO searchParamDTO) {
        PageDTO<UserVO> pageDTO = new PageDTO<UserVO>();
        pageDTO.setPageSize(searchParamDTO.getPageSize());
        pageDTO.setPageNum(searchParamDTO.getPageNum());
        QueryWrapper wrapper = new QueryWrapper();
        if (StrUtil.isNotEmpty((CharSequence)searchParamDTO.getIsAuthorized())) {
            boolean isEmpty = StrUtil.isEmpty((CharSequence)searchParamDTO.getAuthorizedIDs());
            if ("1".equals(searchParamDTO.getIsAuthorized())) {
                if (isEmpty) {
                    return pageDTO;
                }
                wrapper.in((Object)"user_id", Arrays.asList(searchParamDTO.getAuthorizedIDs().split(",")));
            } else if (!isEmpty) {
                wrapper.notIn((Object)"user_id", Arrays.asList(searchParamDTO.getAuthorizedIDs().split(",")));
            }
        }
        if (StrUtil.isNotEmpty((CharSequence)searchParamDTO.getSearchKey())) {
            wrapper.like((Object)"user_name", (Object)searchParamDTO.getSearchKey());
        }
        if (StrUtil.isNotEmpty((CharSequence)searchParamDTO.getOrgId())) {
            wrapper.in((Object)"corporation_id", Arrays.asList(searchParamDTO.getOrgId().split(",")));
        }
        wrapper.ne((Object)"account_status", (Object)2);
        return this.userRoleMapper.pageUsers(pageDTO, (Wrapper<UserVO>)wrapper);
    }
}

