/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.pubplat.controller;

import com.jxdinfo.hussar.pubplat.model.AuthorizeDTO;
import com.jxdinfo.hussar.pubplat.model.PageDTO;
import com.jxdinfo.hussar.pubplat.model.Result;
import com.jxdinfo.hussar.pubplat.model.SearchParamDTO;
import com.jxdinfo.hussar.pubplat.model.UserRoleVO;
import com.jxdinfo.hussar.pubplat.model.UserVO;
import com.jxdinfo.hussar.pubplat.model.pubplat.PubPlatDO;
import com.jxdinfo.hussar.pubplat.model.pubplat.PubPlatDTO;
import com.jxdinfo.hussar.pubplat.model.type.PubPlatTypeDO;
import com.jxdinfo.hussar.pubplat.model.type.PubPlatTypeDTO;
import com.jxdinfo.hussar.pubplat.service.IPubPlatService;
import com.jxdinfo.hussar.pubplat.service.OperateService;
import com.jxdinfo.hussar.pubplat.service.PubPlatPermissionService;
import com.jxdinfo.hussar.pubplat.service.PubPlatTypeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.annotation.Resource;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5fae\u5e94\u7528\u540e\u53f0\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/v1/pubPlat/manager"})
public class PubPlatManageController {
    private static final Logger log = LoggerFactory.getLogger(PubPlatManageController.class);
    @Resource
    private IPubPlatService iPubPlatService;
    @Resource
    private OperateService operateService;
    @Resource
    private PubPlatTypeService typeService;
    @Resource
    private PubPlatPermissionService pubPlatPermissionService;

    @ApiOperation(value="*\u67e5\u8be2\u5fae\u5e94\u7528\u5217\u8868")
    @GetMapping(value={"/pageList"})
    @RequiresPermissions(value={"microAppMain:microList"})
    public Result<PageDTO<PubPlatDO>> getPageList(@RequestParam(required=false) @ApiParam(value="\u5fae\u5e94\u7528\u540d\u79f0") String searchKey, @RequestParam(defaultValue="1") @ApiParam(value="\u5f53\u524d\u9875") int pageNum, @RequestParam(defaultValue="30") @ApiParam(value="\u6bcf\u9875\u5927\u5c0f") int pageSize, @RequestParam(required=false) @ApiParam(value="\u5206\u7c7bId") String classifyId, @RequestParam(required=false) @ApiParam(value="\u7c7b\u578b") String pubType) {
        PageDTO<PubPlatDO> pageDTO = new PageDTO<PubPlatDO>();
        pageDTO.setPageNum(pageNum);
        pageDTO.setPageSize(pageSize);
        return Result.succeed(this.iPubPlatService.getPubPlatList(searchKey, pageDTO, classifyId, pubType));
    }

    @ApiOperation(value="*\u67e5\u770b\u5fae\u5e94\u7528\u8be6\u60c5")
    @GetMapping(value={"{id}"})
    public Result<PubPlatDTO> getPubPlat(@PathVariable @ApiParam(value="\u5fae\u5e94\u7528id") String id) {
        return Result.succeed(this.iPubPlatService.getPubPlat(id));
    }

    @ApiOperation(value="*\u65b0\u589e\u5fae\u5e94\u7528")
    @PostMapping(value={"save"})
    @RequiresPermissions(value={"microAppMain:add"})
    public Result<Boolean> savePubPlat(@RequestBody PubPlatDTO pubPlatDTO) {
        return this.iPubPlatService.savePubPlat(pubPlatDTO);
    }

    @ApiOperation(value="*\u4fee\u6539\u5fae\u5e94\u7528")
    @PostMapping(value={"update"})
    public Result<Boolean> updatePubPlat(@RequestBody PubPlatDTO pubPlatDTO) {
        return this.iPubPlatService.updatePubPlat(pubPlatDTO);
    }

    @ApiOperation(value="*\u5220\u9664\u5fae\u5e94\u7528")
    @GetMapping(value={"delete"})
    public Result<Boolean> deletePubPlat(@RequestParam @ApiParam(value="\u5fae\u5e94\u7528id") String id) {
        return Result.succeed(this.iPubPlatService.deletePubPlat(id));
    }

    @ApiOperation(value="*\u5237\u65b0\u5fae\u5e94\u7528key")
    @GetMapping(value={"/key"})
    public Result<Boolean> updateKey(@RequestParam(required=false) @ApiParam(value="\u5fae\u5e94\u7528id") String id) {
        return Result.succeed(this.iPubPlatService.updateKey(id));
    }

    @ApiOperation(value="*\u65b0\u589e\u5fae\u5e94\u7528\u7ba1\u7406\u6743\u9650")
    @GetMapping(value={"/manager"})
    public Result<Boolean> saveOperatePermission(@RequestParam @ApiParam(value="\u5fae\u5e94\u7528id") String bId, @RequestParam(value="userId", required=false) @ApiParam(value="\u7528\u6237id,\u82e5\u4e3a\u591a\u4e2aid\u4ee5\uff0c\u62fc\u63a5") String userIds) {
        return Result.succeed(this.operateService.saveOperatePermission(bId, userIds));
    }

    @ApiOperation(value="*\u6839\u636e\u5fae\u5e94\u7528id\u83b7\u53d6\u6b64\u5fae\u5e94\u7528\u7ba1\u7406\u6743\u9650\u7684\u4eba\u5458\u5217\u8868")
    @GetMapping(value={"/manager/user"})
    public Result<UserRoleVO> getOperatePermissionUser(@RequestParam @ApiParam(value="\u5fae\u5e94\u7528id") String objId) {
        return Result.succeed(this.operateService.getUserRoleVO(objId));
    }

    @ApiOperation(value="*\u65b0\u589e\u79fb\u52a8\u7aef\u7535\u8111\u7aef\u5fae\u5e94\u7528\u5bdf\u770b\u6743\u9650")
    @PostMapping(value={"/view"})
    public Result<Boolean> savePubPlatPermission(@RequestBody AuthorizeDTO authorizeDTO) {
        this.pubPlatPermissionService.savePubPlatPermission(authorizeDTO);
        return Result.succeed(true);
    }

    @ApiOperation(value="*\u6839\u636e\u5fae\u5e94\u7528id\u83b7\u53d6\u79fb\u52a8\u7aef\u7535\u8111\u7aef\u53ef\u89c1\u6b64\u5fae\u5e94\u7528\u7684\u4eba\u5458\u5217\u8868")
    @GetMapping(value={"/pubViewer"})
    public Result<UserRoleVO> getPubPlatPermissionUserRole(@RequestParam @ApiParam(value="\u5fae\u5e94\u7528id") String objId) {
        return Result.succeed(this.pubPlatPermissionService.getUserRoleVO(objId));
    }

    @ApiOperation(value="*\u5fae\u5e94\u7528\u62d6\u62fd\u4fee\u6539\u5c55\u793a\u987a\u5e8f")
    @GetMapping(value={"/showOrder"})
    public Result<Boolean> dragPubPlat(@RequestParam(value="littleID") @ApiParam(value="\u987a\u5e8f\u5c0f\u7684\u5fae\u5e94\u7528id") String littleId, @RequestParam(value="largeID") @ApiParam(value="\u987a\u5e8f\u5927\u7684\u5fae\u5e94\u7528id") String largeId, @RequestParam @ApiParam(value="\u4e0a\u79fb\u6216\u4e0b\u79fb") String upDown) {
        return this.iPubPlatService.updateShowOrder(littleId, largeId, upDown);
    }

    @ApiOperation(value="*\u5fae\u5e94\u7528\u7ba1\u7406\u6743\u9650\u4eba\u5458\u5217\u8868")
    @PostMapping(value={"/authUsers"})
    public Result<PageDTO<UserVO>> selectAuthUsers(@RequestBody SearchParamDTO searchParamDTO) {
        return Result.succeed(this.iPubPlatService.pageUsers(searchParamDTO));
    }

    @ApiOperation(value="*\u540e\u53f0\u83b7\u53d6\u5fae\u5e94\u7528\u5206\u7c7b\u5217\u8868")
    @GetMapping(value={"/type"})
    public Result<PageDTO<PubPlatTypeDO>> getPubPlatTypeList(@RequestParam(required=false) @ApiParam(value="\u5fae\u5e94\u7528\u5206\u7c7b\u540d") String typeName, @RequestParam(defaultValue="1") @ApiParam(value="\u5f53\u524d\u9875") int pageNum, @RequestParam(defaultValue="20") @ApiParam(value="\u6bcf\u9875\u5927\u5c0f") int pageSize) {
        PageDTO<PubPlatTypeDO> pageDTO = new PageDTO<PubPlatTypeDO>();
        pageDTO.setPageSize(pageSize);
        pageDTO.setPageNum(pageNum);
        return Result.succeed(this.typeService.listTypes(pageDTO, typeName));
    }

    @ApiOperation(value="*\u65b0\u589e\u5fae\u5e94\u7528\u5206\u7c7b")
    @PostMapping(value={"save/type"})
    public Result<Boolean> saveAddType(@RequestBody @ApiParam(value="\u5fae\u5e94\u7528\u5206\u7c7b\u4fe1\u606f") PubPlatTypeDTO pubPlatTypeDTO) {
        return this.typeService.saveType(pubPlatTypeDTO);
    }

    @ApiOperation(value="*\u4fee\u6539\u5fae\u5e94\u7528\u5206\u7c7b")
    @PostMapping(value={"update/type"})
    public Result<Boolean> saveEditType(@RequestBody @ApiParam(value="\u4e3a\u5e94\u7528\u5206\u7c7b\u4fe1\u606f") PubPlatTypeDO pubPlatTypeDO) {
        return this.typeService.updateType(pubPlatTypeDO);
    }

    @ApiOperation(value="*\u5220\u9664\u5fae\u5e94\u7528\u5206\u7c7b")
    @GetMapping(value={"delete/type"})
    public Result<Boolean> deletePubPlatType(@RequestParam @ApiParam(value="\u5206\u7c7bids") String typeIds) {
        return this.typeService.removeType(typeIds);
    }

    @ApiOperation(value="*\u79fb\u52a8\u4fee\u6539\u5fae\u5e94\u7528\u5206\u7c7b\u5c55\u793a\u987a\u5e8f")
    @GetMapping(value={"/typeOrder"})
    public Result<Boolean> updatePubPlatTypeShowOrder(@RequestParam(value="littleID") @ApiParam(value="\u987a\u5e8f\u5c0f\u7684\u5fae\u5e94\u7528\u5206\u7c7bid") String littleId, @RequestParam(value="largeID") @ApiParam(value="\u987a\u5e8f\u5927\u7684\u5fae\u5e94\u7528\u5206\u7c7bid") String largeId, @RequestParam @ApiParam(value="\u4e0a\u79fb\u6216\u4e0b\u79fb\uff0c0\u4e0a1\u4e0b") String upDown) {
        return this.typeService.updateShowOrder(littleId, largeId, upDown);
    }
}

