/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.pubplat.controller;

import com.jxdinfo.hussar.core.config.HussarConfig;
import com.jxdinfo.hussar.mail.core.collection.CollUtil;
import com.jxdinfo.hussar.mail.core.date.DateUtil;
import com.jxdinfo.hussar.mail.core.util.StrUtil;
import com.jxdinfo.hussar.pubplat.model.file.FileDO;
import com.jxdinfo.hussar.pubplat.service.FileService;
import com.jxdinfo.hussar.pubplat.util.FileUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RequestMapping(value={"file/v1"})
@Api(tags={"\u6587\u4ef6\u4e0a\u4f20\u4e0e\u4e0b\u8f7d"})
@RestController
public class FileController {
    @Resource
    private FileService fileService;
    @Resource
    HussarConfig hussarConfig;

    @ApiOperation(value="\u4e0a\u4f20", notes="\u6587\u4ef6\u4e0a\u4f20")
    @PostMapping
    @ResponseBody
    public Object uploadFile(String fileId, MultipartFile file) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(5);
        boolean success = true;
        try {
            BufferedImage bufferedImage;
            String fileName = file.getOriginalFilename();
            String fileType = "";
            if (fileName.contains(".")) {
                fileType = fileName.substring(fileName.lastIndexOf(".") + 1);
            }
            long fileSizeLong = file.getSize();
            int widthInt = 0;
            int heightInt = 0;
            InputStream fileInput = file.getInputStream();
            if (FileUtil.imageBoolean(fileType) && (bufferedImage = ImageIO.read(file.getInputStream())) != null) {
                widthInt = bufferedImage.getWidth();
                heightInt = bufferedImage.getHeight();
            }
            String filePath = FileUtil.uploadFileToLocal(this.hussarConfig.getFileUploadPath(), fileInput);
            Float fileSize = Float.valueOf(new BigDecimal(fileSizeLong / 1024L).setScale(2, 4).floatValue());
            FileDO fileDO = new FileDO();
            fileDO.setObjId(UUID.randomUUID().toString().toUpperCase());
            fileDO.setFileName(fileName);
            fileDO.setFileId(StrUtil.isNotEmpty((CharSequence)fileId) ? fileId : UUID.randomUUID().toString().toUpperCase());
            fileDO.setFileType(fileType);
            fileDO.setFileSize(fileSize);
            fileDO.setWidth(widthInt);
            fileDO.setHeight(heightInt);
            fileDO.setFilePath(filePath);
            fileDO.setCreateTime(DateUtil.now());
            this.fileService.save(fileDO);
            resultMap.put("msg", "\u4e0a\u4f20\u6210\u529f");
            resultMap.put("errcode", 200);
            resultMap.put("data", fileDO.getFileId());
        }
        catch (Exception e) {
            e.printStackTrace();
            success = false;
            resultMap.put("errcode", 500);
            resultMap.put("msg", e.getMessage());
        }
        resultMap.put("success", success);
        return resultMap;
    }

    @ApiOperation(value="\u539f\u6587\u4ef6\u4e0b\u8f7d", notes="\u539f\u6587\u4ef6\u4e0b\u8f7d")
    @GetMapping(value={"/{fileId}"})
    public void downloadFile(@PathVariable(value="fileId") String fileId, HttpServletResponse response) throws IOException {
        List<FileDO> listFile = this.fileService.listFiles(fileId);
        if (CollUtil.isNotEmpty(listFile)) {
            FileDO fileDO = listFile.get(0);
            FileInputStream fileInputStream = new FileInputStream(fileDO.getFilePath());
            byte[] buff = new byte[fileInputStream.available()];
            int filesize = fileInputStream.read(buff);
            fileInputStream.close();
            response.setContentType("application/octet-stream;charset=UTF-8");
            response.setHeader("Content-Length", String.valueOf(filesize));
            response.setHeader("Content-Disposition", "attachment;fileName=" + URLEncoder.encode(fileDO.getFileName(), "UTF-8"));
            ServletOutputStream outputStream = response.getOutputStream();
            outputStream.write(buff);
            outputStream.flush();
            outputStream.close();
        } else {
            response.sendError(404);
        }
    }
}

