/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.pubplat.util;

import cn.hutool.core.util.StrUtil;
import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.channels.FileChannel;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.env.Environment;

public class FileUtil {
    private static String VIDEOTYPE = "rm,rmvb,mov,mtv,dat,wmv,avi,amv,dmv,flv,mp4,mp5";
    private static String PICTURETYPE = "bmp,jpg,gif,psd,png,tiff,eps,jpeg,heic";

    public static boolean videoBoolean(String fileType) {
        if (StrUtil.isNotEmpty((CharSequence)fileType)) {
            String[] strs;
            for (String str : strs = VIDEOTYPE.split(",")) {
                if (!str.equals(fileType.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean imageBoolean(String fileType) {
        if (StrUtil.isNotEmpty((CharSequence)fileType)) {
            String[] strs;
            for (String str : strs = PICTURETYPE.split(",")) {
                if (!str.equals(fileType.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    public static Integer getNewHeight(Integer oldWidth, Integer oldHeight, Integer newWidth) {
        DecimalFormat df = new DecimalFormat("0");
        BigDecimal b1 = new BigDecimal(Integer.toString(newWidth));
        BigDecimal b2 = new BigDecimal(Integer.toString(oldWidth));
        BigDecimal b3 = new BigDecimal(Integer.toString(oldHeight));
        BigDecimal b4 = b1.divide(b2, 4, 4);
        BigDecimal b5 = b3.multiply(b4);
        return Integer.valueOf(df.format(b5));
    }

    public static Integer getNewWidth(Integer oldWidth, Integer oldHeight, Integer newHeight) {
        DecimalFormat df = new DecimalFormat("0");
        BigDecimal b1 = new BigDecimal(Integer.toString(newHeight));
        BigDecimal b2 = new BigDecimal(Integer.toString(oldHeight));
        BigDecimal b3 = new BigDecimal(Integer.toString(oldWidth));
        BigDecimal b4 = b1.divide(b2, 4, 4);
        BigDecimal b5 = b3.multiply(b4);
        return Integer.valueOf(df.format(b5));
    }

    public static String calculateFileSize(int fileSize, String unit, boolean unitBoolean) {
        if (unit != null) {
            unit = unit.toUpperCase();
        }
        String size = "";
        if ((unit == null || "".equals(unit)) && fileSize < 102 || "K".equals(unit)) {
            size = fileSize + "K";
        } else if ((unit == null || "".equals(unit)) && fileSize < 0x100000 || "M".equals(unit)) {
            BigDecimal newSize = new BigDecimal(Integer.toString(fileSize)).divide(new BigDecimal("1024"), 2, 4);
            size = newSize + "M";
        } else if ((unit == null || "".equals(unit)) && fileSize < 1300234240 || "G".equals(unit)) {
            BigDecimal newSize = new BigDecimal(Integer.toString(fileSize)).divide(new BigDecimal("1048576"), 2, 4);
            size = newSize + "G";
        } else {
            BigDecimal newSize = new BigDecimal(Integer.toString(fileSize)).divide(new BigDecimal("1300234240"), 2, 4);
            size = newSize + "T";
        }
        if (!unitBoolean && size.length() > 0) {
            size = size.substring(0, size.length() - 1);
        }
        return size;
    }

    public static String uploadFileToLocal(String storePath, InputStream fileStream, String fileName, String fileType, int width, int height) {
        String filePath = FileUtil.makePath(storePath, false);
        String saveName = UUID.randomUUID().toString().toUpperCase().replaceAll("-", "");
        try {
            File file = new File(filePath, saveName);
            FileOutputStream fos = new FileOutputStream(file);
            byte[] buff = new byte[1024];
            int bytesRead = 0;
            while (-1 != (bytesRead = fileStream.read(buff, 0, buff.length))) {
                fos.write(buff, 0, bytesRead);
            }
            fileStream.close();
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return filePath + "/" + saveName;
    }

    private static String makePath(String savePath, boolean sltBoolean) {
        File file;
        Date dt = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        SimpleDateFormat sdf1 = new SimpleDateFormat("MM");
        SimpleDateFormat sdf2 = new SimpleDateFormat("dd");
        String dir1 = sdf.format(dt);
        String dir2 = sdf1.format(dt);
        String dir3 = sdf2.format(dt);
        String dir = savePath + "/" + dir1 + "/" + dir2 + "/" + dir3;
        if (sltBoolean) {
            dir = dir + "/" + "slt";
        }
        if (!(file = new File(dir)).exists()) {
            file.mkdirs();
        }
        return dir;
    }

    public static boolean processImg(Environment environment, String veidoPath, String sltPath, int oldWidth, int oldHeight, String width, String heigth) {
        String ffmpegPath = environment.getProperty("efs.ffmpeg_path");
        File file = new File(veidoPath);
        if (!file.exists()) {
            System.err.println("\u8def\u5f84[" + veidoPath + "]\u5bf9\u5e94\u7684\u89c6\u9891\u6587\u4ef6\u4e0d\u5b58\u5728!");
            return false;
        }
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(ffmpegPath);
        commands.add("-i");
        commands.add(veidoPath);
        commands.add("-y");
        commands.add("-f");
        commands.add("image2");
        commands.add("-ss");
        commands.add("0.1");
        commands.add("-s");
        try {
            commands.add(width + "*" + heigth);
            commands.add(sltPath + "_" + width + "x" + heigth + ".png");
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.command(commands);
            Process process = builder.start();
            process.waitFor();
            int exit = process.exitValue();
            if (exit == 1) {
                System.out.println("\u622a\u53d6\u6210\u529f");
            } else {
                System.out.println("\u622a\u53d6\u5931\u8d25");
            }
            if (width != null && !"".equals(width) && heigth != null && !"".equals(heigth)) {
                Integer widthInt = Integer.valueOf(width);
                Integer heigthInt = Integer.valueOf(heigth);
                if (widthInt < heigthInt && oldWidth > oldHeight || widthInt > heigthInt && oldWidth < oldHeight) {
                    FileUtil.rotatePhonePhoto(sltPath + "_" + width + "x" + heigth + ".png", 90);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public static void downloadFileFromLocal(HttpServletResponse response, String filePath, String fileName, String fileType, boolean sltBoolean) throws IOException {
        File file = new File(filePath);
        if (!file.exists()) {
            if (sltBoolean) {
                String originalFilePath = filePath.substring(0, filePath.lastIndexOf("slt")) + filePath.substring(filePath.lastIndexOf("/") + 1, filePath.lastIndexOf("_"));
                String originalFileName = filePath.substring(filePath.lastIndexOf("/") + 1);
                String fileSize = fileName.substring(fileName.lastIndexOf("_") + 1, fileName.lastIndexOf("."));
                if (FileUtil.imageBoolean(fileType)) {
                    try {
                        FileUtil.downloadFile(response, filePath, fileName);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        response.sendError(500);
                    }
                }
            } else {
                response.sendError(500);
            }
        } else {
            FileUtil.downloadFile(response, filePath, fileName);
        }
    }

    private static void downloadFile(HttpServletResponse response, String filePath, String fileName) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(filePath);
        FileChannel fc = fileInputStream.getChannel();
        String filesize = fc.size() + "";
        int i = fileInputStream.available();
        byte[] buff = new byte[i];
        fileInputStream.read(buff);
        fileInputStream.close();
        response.setContentType("application/octet-stream;charset=UTF-8");
        response.setHeader("Content-Length", filesize);
        response.setHeader("Content-Disposition", "attachment;fileName=" + URLEncoder.encode(fileName, "UTF-8"));
        ServletOutputStream outputStream = response.getOutputStream();
        outputStream.write(buff);
        outputStream.flush();
        outputStream.close();
    }

    public static String getFileSize(String size, int width, int height, String fileType, String storeType) {
        if (!"local".equals(storeType) && FileUtil.videoBoolean(fileType)) {
            fileType = "png";
            if (size.indexOf("-") == size.length() - 1) {
                Integer newWidth = Integer.valueOf(size.replaceAll("-", ""));
                Integer newHeight = FileUtil.getNewHeight(width, height, newWidth);
                if (newWidth > width && newHeight > height) {
                    newWidth = width;
                    newHeight = height;
                }
                size = "_" + newWidth + "x" + newHeight + "_" + width + "x" + height + "." + fileType;
            } else if (size.indexOf("-") == 0) {
                Integer newHeight = Integer.valueOf(size.replaceAll("-", ""));
                Integer newWidth = FileUtil.getNewWidth(width, height, newHeight);
                if (newWidth > width && newHeight > height) {
                    newWidth = width;
                    newHeight = height;
                }
                size = "_" + newWidth + "x" + newHeight + "_" + width + "x" + height + "." + fileType;
            } else {
                String[] sizeArr = size.split("x");
                if (Integer.valueOf(sizeArr[0]) > width && Integer.valueOf(sizeArr[1]) > height) {
                    size = width + "x" + height;
                }
                size = "_" + size + "_" + width + "x" + height + "." + fileType;
            }
        } else {
            boolean flag = false;
            if (FileUtil.videoBoolean(fileType)) {
                fileType = "png";
            }
            if ("gif".equals(fileType.toLowerCase())) {
                fileType = "png";
                flag = true;
            }
            if (size.indexOf("-") == size.length() - 1) {
                Integer newWidth = Integer.valueOf(size.replaceAll("-", ""));
                Integer newHeight = FileUtil.getNewHeight(width, height, newWidth);
                size = "_" + newWidth + "x" + newHeight + "." + fileType;
                if (newWidth > width && flag) {
                    size = "_" + width + "x" + height + "." + fileType;
                    return size;
                }
                if (newWidth > width) {
                    size = "";
                }
            } else if (size.indexOf("-") == 0) {
                Integer newHeight = Integer.valueOf(size.replaceAll("-", ""));
                Integer newWidth = FileUtil.getNewWidth(width, height, newHeight);
                size = "_" + newWidth + "x" + newHeight + "." + fileType;
                if (newHeight > height && flag) {
                    size = "_" + width + "x" + height + "." + fileType;
                    return size;
                }
                if (newHeight > height) {
                    size = "";
                }
            } else {
                String[] sizeArr = size.split("x");
                size = "_" + size + "." + fileType;
                if (Integer.valueOf(sizeArr[0]) > width && Integer.valueOf(sizeArr[1]) > height && flag) {
                    size = "_" + width + "x" + height + "." + fileType;
                    return size;
                }
                if (Integer.valueOf(sizeArr[0]) > width && Integer.valueOf(sizeArr[1]) > height) {
                    size = "";
                }
            }
        }
        return size;
    }

    private static String rotatePhonePhoto(String fullPath, int angel) {
        try {
            for (int i = 0; i < 10; ++i) {
                File imgFile = new File(fullPath);
                if (imgFile.exists()) {
                    BufferedImage src = ImageIO.read(imgFile);
                    int srcWidth = src.getWidth(null);
                    int srcHeight = src.getHeight(null);
                    int swidth = srcWidth;
                    int sheight = srcHeight;
                    if (angel == 90 || angel == 270) {
                        swidth = srcHeight;
                        sheight = srcWidth;
                    }
                    Rectangle rectDes = new Rectangle(new Dimension(swidth, sheight));
                    BufferedImage res = new BufferedImage(rectDes.width, rectDes.height, 1);
                    Graphics2D g2 = res.createGraphics();
                    g2.translate((rectDes.width - srcWidth) / 2, (rectDes.height - srcHeight) / 2);
                    g2.rotate(Math.toRadians(angel), srcWidth / 2, srcHeight / 2);
                    g2.drawImage(src, null, null);
                    ImageIO.write((RenderedImage)res, "png", new File(fullPath));
                    break;
                }
                Robot r = new Robot();
                r.delay(1000);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
        return fullPath;
    }
}

