/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.pubplat.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.pubplat.dao.PubAttentionMapper;
import com.jxdinfo.hussar.pubplat.dao.PubPlatMapper;
import com.jxdinfo.hussar.pubplat.model.PageDTO;
import com.jxdinfo.hussar.pubplat.model.attention.PubPlatAttentionDO;
import com.jxdinfo.hussar.pubplat.model.attention.PubPlatAttentionVO;
import com.jxdinfo.hussar.pubplat.model.menu.PubPlatMenuVO;
import com.jxdinfo.hussar.pubplat.model.pubplat.PubPlatDO;
import com.jxdinfo.hussar.pubplat.model.pubplat.PubPlatVO;
import com.jxdinfo.hussar.pubplat.service.PubPlatService;
import com.jxdinfo.hussar.pubplat.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class PubPlatServiceImpl
extends ServiceImpl<PubPlatMapper, PubPlatDO>
implements PubPlatService {
    @Resource
    private PubAttentionMapper pubAttentionMapper;
    @Resource
    private PubPlatMapper pubPlatMapper;
    @Autowired
    Environment environment;

    private PubPlatVO loopQueryPubPlatMenuChild(PubPlatVO pubPlatVO, List<PubPlatMenuVO> pubMenuList) {
        if (pubMenuList != null && !pubMenuList.isEmpty()) {
            ArrayList<PubPlatMenuVO> pubPlatMenuList = new ArrayList<PubPlatMenuVO>();
            pubMenuList.forEach(pubPlatMenu -> {
                Integer menuLevel = pubPlatMenu.getMenuLevel();
                if (menuLevel != null && menuLevel == 1) {
                    String pubPlatMenuId = pubPlatMenu.getMenuId();
                    ArrayList<PubPlatMenuVO> pubPlatMenuList1 = new ArrayList<PubPlatMenuVO>();
                    System.out.println(pubPlatMenuId);
                    pubMenuList.forEach(item2 -> {
                        System.out.println(item2.getParentMenuId());
                        String parentPubPlatMenuId = item2.getParentMenuId();
                        if (pubPlatMenuId.equals(parentPubPlatMenuId)) {
                            pubPlatMenuList1.add((PubPlatMenuVO)item2);
                        }
                    });
                    pubPlatMenu.setChild(pubPlatMenuList1);
                    pubPlatMenuList.add((PubPlatMenuVO)pubPlatMenu);
                }
            });
            pubPlatVO.setMenuList(pubPlatMenuList);
        } else {
            pubPlatVO.setMenuList(new ArrayList<PubPlatMenuVO>());
        }
        return pubPlatVO;
    }

    @Override
    public PageDTO<PubPlatVO> getNotFocusPubPlatList(PageDTO<PubPlatVO> pageDTO, String searchKey, String deviceTag, String userId) {
        return this.pubPlatMapper.getNotFocusPubPlatList(pageDTO, userId, StringUtil.replaceSpecialChar(searchKey), deviceTag);
    }

    @Override
    public List<PubPlatVO> getFocusPubPlatList(String deviceTag, String userId) {
        String specialUser = this.environment.getProperty("mp.multi-tenant.special_User");
        ArrayList<PubPlatVO> pubPlatVOList = new ArrayList<PubPlatVO>();
        List<PubPlatVO> pubPlatList = this.pubPlatMapper.getPlatList(userId, deviceTag);
        pubPlatList.forEach(pubPlat -> {
            List<PubPlatMenuVO> pubMenuList = this.pubPlatMapper.getPubPlatMenuList(pubPlat.getPubID(), userId);
            pubPlatVOList.add(this.loopQueryPubPlatMenuChild((PubPlatVO)pubPlat, pubMenuList));
        });
        return pubPlatVOList;
    }

    @Override
    public boolean followPubPlat(String pubPlatIds, String deviceTag, String userId) {
        String[] pubPlatIdArray = pubPlatIds.split(",");
        ArrayList<PubPlatAttentionVO> list = new ArrayList<PubPlatAttentionVO>();
        for (String str : pubPlatIdArray) {
            PubPlatAttentionVO item = new PubPlatAttentionVO();
            item.setObjId(IdUtil.randomUUID().toUpperCase());
            item.setUserId(userId);
            item.setPubPlatId(str);
            item.setCreateTime(DateUtil.now());
            item.setIsRemind(1);
            item.setIsTop(0);
            list.add(item);
        }
        return this.pubPlatMapper.followPubPlat(list);
    }

    @Override
    public boolean unFollowPubPlat(String pubPlatId, String deviceTag, String userId) {
        List<String> pubIDList = Arrays.asList(pubPlatId.split(","));
        QueryWrapper qw = new QueryWrapper();
        ((QueryWrapper)qw.eq((Object)"USERID", (Object)userId)).in((Object)"PUBPLATID", pubIDList);
        return this.pubAttentionMapper.delete((Wrapper)qw) > 0;
    }

    @Override
    public boolean updatePubAttention(String pubPlatId, String remindOrTop, int flag, String deviceTag, String userId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        PubPlatAttentionVO pubPlatAttentionVO = this.pubPlatMapper.queryPubAttentionIsExist(userId, pubPlatId);
        if (pubPlatAttentionVO != null) {
            PubPlatAttentionDO pubPlatAttentionDO = new PubPlatAttentionDO();
            queryWrapper.eq((Object)"OBJID", (Object)pubPlatAttentionVO.getObjId());
            pubPlatAttentionDO.setModifyTime(DateUtil.now());
            if ("remind".equals(remindOrTop)) {
                pubPlatAttentionDO.setIsRemind(flag);
                pubPlatAttentionDO.setIsTop(0);
            } else {
                pubPlatAttentionDO.setIsRemind(1);
                pubPlatAttentionDO.setIsTop(flag);
            }
            return this.pubAttentionMapper.update(pubPlatAttentionDO, (Wrapper)queryWrapper) > 0;
        }
        ArrayList<PubPlatAttentionVO> list = new ArrayList<PubPlatAttentionVO>();
        PubPlatAttentionVO item = new PubPlatAttentionVO();
        item.setObjId(IdUtil.randomUUID().toUpperCase());
        item.setUserId(userId);
        item.setPubPlatId(pubPlatId);
        item.setCreateTime(DateUtil.now());
        if ("remind".equals(remindOrTop)) {
            item.setIsRemind(flag);
            item.setIsTop(0);
        } else {
            item.setIsRemind(1);
            item.setIsTop(flag);
        }
        list.add(item);
        return this.pubPlatMapper.followPubPlat(list);
    }

    @Override
    public PubPlatVO getPubPlatInfo(String pubPlatId, String deviceTag, String userId) {
        PubPlatVO pubPlatVO = new PubPlatVO();
        PubPlatVO pubPlatVO1 = this.pubPlatMapper.getPubPlatList(userId, pubPlatId, deviceTag);
        List<PubPlatMenuVO> pubMenuList = this.pubPlatMapper.getPubPlatMenuList(pubPlatVO1.getPubID(), userId);
        pubPlatVO = this.loopQueryPubPlatMenuChild(pubPlatVO1, pubMenuList);
        return pubPlatVO;
    }

    @Override
    public List<PubPlatVO> getPubStatusByUserID(String time, String userId) {
        return this.pubPlatMapper.getPubStatusByUserID(ShiroKit.getUser().getId(), time);
    }

    @Override
    public int queryPubPlatIsExit(String pubPlatID) {
        return this.pubPlatMapper.queryPubPlatIsExit(pubPlatID);
    }
}

