/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.pubplat.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.pubplat.dao.IHeadImgMapper;
import com.jxdinfo.hussar.pubplat.dao.IMenuPermissionMapper;
import com.jxdinfo.hussar.pubplat.dao.IPubPlatAttentionMapper;
import com.jxdinfo.hussar.pubplat.dao.IPubPlatCodeFileMapper;
import com.jxdinfo.hussar.pubplat.dao.IPubPlatMapper;
import com.jxdinfo.hussar.pubplat.dao.IPubPlatMenuMapper;
import com.jxdinfo.hussar.pubplat.dao.IPubPlatOperateMapper;
import com.jxdinfo.hussar.pubplat.dao.IPubPlatPermissionMapper;
import com.jxdinfo.hussar.pubplat.dao.IPubPlatTypeMapper;
import com.jxdinfo.hussar.pubplat.model.PageDTO;
import com.jxdinfo.hussar.pubplat.model.PageVO;
import com.jxdinfo.hussar.pubplat.model.Result;
import com.jxdinfo.hussar.pubplat.model.RoleVO;
import com.jxdinfo.hussar.pubplat.model.UserRoleVO;
import com.jxdinfo.hussar.pubplat.model.UserVO;
import com.jxdinfo.hussar.pubplat.model.file.FileBean;
import com.jxdinfo.hussar.pubplat.model.file.HeadingImg;
import com.jxdinfo.hussar.pubplat.model.menu.PubPlatMenuDO;
import com.jxdinfo.hussar.pubplat.model.menu.PubPlatMenuDTO;
import com.jxdinfo.hussar.pubplat.model.menu.PubPlatMenuVO;
import com.jxdinfo.hussar.pubplat.model.pubplat.PubPlatCodeFileDO;
import com.jxdinfo.hussar.pubplat.model.pubplat.PubPlatDO;
import com.jxdinfo.hussar.pubplat.model.pubplat.PubPlatDTO;
import com.jxdinfo.hussar.pubplat.model.pubplat.PubPlatOperateDO;
import com.jxdinfo.hussar.pubplat.model.pubplat.PubPlatPermission;
import com.jxdinfo.hussar.pubplat.model.type.PubPlatTypeDO;
import com.jxdinfo.hussar.pubplat.model.type.PubPlatTypeDTO;
import com.jxdinfo.hussar.pubplat.service.IFileService;
import com.jxdinfo.hussar.pubplat.service.IHeadImgService;
import com.jxdinfo.hussar.pubplat.service.IPubPlatDealService;
import com.jxdinfo.hussar.pubplat.service.IPubPlatService;
import com.jxdinfo.hussar.pubplat.service.IPubPlatTypeService;
import com.jxdinfo.hussar.pubplat.util.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class IPubPlatServiceImpl
implements IPubPlatService {
    @Resource
    private IPubPlatMapper iPubPlatMapper;
    @Resource
    private IHeadImgMapper iHeadImgMapper;
    @Resource
    private IPubPlatCodeFileMapper pubPlatCodeFileMapper;
    @Resource
    private IPubPlatAttentionMapper attentionMapper;
    @Resource
    private IPubPlatPermissionMapper permissionMapper;
    @Resource
    private IPubPlatMenuMapper menuMapper;
    @Resource
    private IPubPlatTypeMapper typeMapper;
    @Resource
    private IHeadImgService iHeadImgService;
    @Resource
    private IFileService iFileService;
    @Resource
    private IPubPlatOperateMapper iPubPlatOperateMapper;
    @Resource
    private IMenuPermissionMapper iMenuPermissionMapper;
    @Resource
    private IPubPlatDealService pubPlatDealService;
    @Resource
    private IPubPlatTypeService typeService;

    private void dealImage(PubPlatDTO pubPlatDTO) {
        HeadingImg img = new HeadingImg();
        img.setObjId(pubPlatDTO.getObjID());
        img.setFileId(pubPlatDTO.getObjID());
        img.setFilePath("");
        img.setFileName(pubPlatDTO.getImg().getFileName());
        img.setFileSize(pubPlatDTO.getImg().getFileSize());
        this.iHeadImgService.saveOrUpdate(img);
    }

    private void editPubPlat(PubPlatDO pubPlat, PubPlatDTO pubPlatDTO, String action, String androidChange, String iosChange, String pcChange) {
        if ("3".equals(pubPlatDTO.getPubType())) {
            if ("edit".equals(action)) {
                QueryWrapper wrapper = new QueryWrapper();
                wrapper = (QueryWrapper)wrapper.eq((Object)"PUBPLATID", (Object)pubPlatDTO.getObjID());
                if ("1".equals(androidChange) || "1".equals(iosChange) || "1".equals(pcChange)) {
                    wrapper.and(i -> {
                        if ("1".equals(androidChange)) {
                            ((QueryWrapper)i.eq((Object)"TYPE", (Object)"0")).or();
                        }
                        if ("1".equals(iosChange)) {
                            ((QueryWrapper)i.eq((Object)"TYPE", (Object)"1")).or();
                        }
                        if ("1".equals(pcChange)) {
                            i.eq((Object)"TYPE", (Object)"2");
                        }
                    });
                }
                this.pubPlatCodeFileMapper.delete((Wrapper)wrapper);
            }
            String time = DateUtil.now();
            PubPlatCodeFileDO pubPlatCodeFileDO = new PubPlatCodeFileDO();
            pubPlatCodeFileDO.setPubPlatID(pubPlat.getObjId());
            if (pubPlatDTO.getFileBeanList() != null && !pubPlatDTO.getFileBeanList().isEmpty()) {
                pubPlatDTO.getFileBeanList().forEach(fileBean -> {
                    if (0 == fileBean.getType()) {
                        if ("add".equals(action)) {
                            pubPlatCodeFileDO.setObjID(IdUtil.randomUUID().toUpperCase());
                            pubPlatCodeFileDO.setModifyTime(time);
                            pubPlatCodeFileDO.setCreateTime(time);
                        } else {
                            if ("1".equals(androidChange)) {
                                pubPlatCodeFileDO.setModifyTime(time);
                            }
                            if (!StrUtil.isEmpty((CharSequence)fileBean.getObjID())) {
                                pubPlatCodeFileDO.setObjID(fileBean.getObjID());
                            } else {
                                pubPlatCodeFileDO.setObjID(IdUtil.randomUUID().toUpperCase());
                            }
                        }
                        pubPlatCodeFileDO.setType(0);
                    }
                    if (1 == fileBean.getType()) {
                        if ("add".equals(action)) {
                            pubPlatCodeFileDO.setObjID(IdUtil.randomUUID().toUpperCase());
                            pubPlatCodeFileDO.setCreateTime(time);
                            pubPlatCodeFileDO.setModifyTime(time);
                        } else {
                            if ("1".equals(iosChange)) {
                                pubPlatCodeFileDO.setModifyTime(time);
                            }
                            if (!StrUtil.isEmpty((CharSequence)fileBean.getObjID())) {
                                pubPlatCodeFileDO.setObjID(fileBean.getObjID());
                            } else {
                                pubPlatCodeFileDO.setObjID(IdUtil.randomUUID().toUpperCase());
                            }
                        }
                        pubPlatCodeFileDO.setType(1);
                    }
                    if (2 == fileBean.getType()) {
                        if ("add".equals(action)) {
                            pubPlatCodeFileDO.setCreateTime(time);
                            pubPlatCodeFileDO.setObjID(IdUtil.randomUUID().toUpperCase());
                            pubPlatCodeFileDO.setModifyTime(time);
                        } else {
                            if ("1".equals(pcChange)) {
                                pubPlatCodeFileDO.setModifyTime(time);
                            }
                            if (!StrUtil.isEmpty((CharSequence)fileBean.getObjID())) {
                                pubPlatCodeFileDO.setObjID(fileBean.getObjID());
                            } else {
                                pubPlatCodeFileDO.setObjID(IdUtil.randomUUID().toUpperCase());
                            }
                        }
                        pubPlatCodeFileDO.setType(2);
                    }
                    pubPlatCodeFileDO.setFileType(0);
                    pubPlatCodeFileDO.setFileID(fileBean.getFileID());
                    pubPlatCodeFileDO.setFileSize(Float.valueOf(fileBean.getFileSize()));
                    pubPlatCodeFileDO.setFileName(fileBean.getFileName());
                    this.iFileService.saveOrUpdate(pubPlatCodeFileDO);
                });
            }
            pubPlat.setFileId("");
            pubPlat.setFileName("");
            pubPlat.setFileSize(null);
        }
        if ("5".equals(pubPlatDTO.getPubType())) {
            pubPlat.setPath("");
            pubPlat.setFileId(pubPlatDTO.getFileId());
            pubPlat.setFilePath("");
            pubPlat.setFileName(pubPlatDTO.getFileName());
            pubPlat.setFileSize(pubPlatDTO.getFileSize());
        }
        if ("4".equals(pubPlatDTO.getPubType())) {
            pubPlat.setPath(pubPlatDTO.getPath());
        }
    }

    @Override
    public PageDTO<PubPlatDO> getPubPlatList(String searchKey, PageDTO pageDTO, String classifyID, String pubType) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.and(i -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)i.apply("1=1", new Object[0]);
        });
        if (!StrUtil.isEmpty((CharSequence)searchKey)) {
            wrapper.and(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)i.like((Object)"EP.NAME", (Object)StringUtil.replaceSpecialChar(searchKey.trim()));
            });
        }
        if (!StrUtil.isEmpty((CharSequence)classifyID)) {
            wrapper.and(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)i.eq((Object)"EP.CATEGORYID", (Object)classifyID);
            });
        }
        if (!StrUtil.isEmpty((CharSequence)pubType)) {
            wrapper.and(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)i.eq((Object)"EP.PUBTYPE", (Object)Integer.valueOf(pubType));
            });
        }
        if (!ShiroKit.isAdmin()) {
            wrapper.and(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)i.inSql((Object)"EP.OBJID", "SELECT BID FROM EIM_PUBPLAT_OPERATE EPO WHERE EPO.OBJID='" + ShiroKit.getUser().getId() + "'");
            });
        }
        wrapper.last("ORDER BY EP.SHOWORDER");
        return this.iPubPlatMapper.getPubPlatList(pageDTO, (Wrapper)wrapper);
    }

    @Override
    public PubPlatDTO getPubPlat(String pubPlatID) {
        QueryWrapper wrapper = new QueryWrapper();
        PubPlatDTO pubPlatDTO = new PubPlatDTO();
        PageDTO<Object> pageDTO = new PageDTO();
        wrapper.eq((Object)"EP.OBJID", (Object)pubPlatID);
        pageDTO.setPageNum(1);
        pageDTO.setPageSize(10);
        pageDTO = this.iPubPlatMapper.getPubPlatList(pageDTO, (Wrapper)wrapper);
        if (pageDTO == null) {
            return null;
        }
        BeanUtil.copyProperties((Object)this.iPubPlatMapper.getPubPlatList(pageDTO, (Wrapper)wrapper).getList().get(0), (Object)pubPlatDTO);
        pubPlatDTO.setObjID(pubPlatID);
        pubPlatDTO.setAssistInfo(StrUtil.isNotEmpty((CharSequence)pubPlatDTO.getAssistInfo()) ? pubPlatDTO.getAssistInfo().replace(" ", "") : pubPlatDTO.getAssistInfo());
        pubPlatDTO.setImg((HeadingImg)this.iHeadImgMapper.selectById((Serializable)((Object)pubPlatID)));
        pubPlatDTO.setPath(StrUtil.isEmpty((CharSequence)pubPlatDTO.getPath()) ? "" : pubPlatDTO.getPath());
        QueryWrapper fileWrapper = new QueryWrapper();
        ((QueryWrapper)fileWrapper.apply("1=1", new Object[0])).eq((Object)"PUBPLATID", (Object)pubPlatID);
        List fileList = this.pubPlatCodeFileMapper.selectList((Wrapper)fileWrapper);
        ArrayList<FileBean> fileBeanList = new ArrayList<FileBean>();
        fileList.forEach(pubPlatCodeFileDO -> {
            FileBean fileBean = new FileBean();
            fileBean.setBID(pubPlatCodeFileDO.getPubPlatID());
            BeanUtil.copyProperties((Object)pubPlatCodeFileDO, (Object)fileBean);
            fileBeanList.add(fileBean);
        });
        pubPlatDTO.setFileBeanList(fileBeanList);
        return pubPlatDTO;
    }

    @Override
    public Result<Boolean> saveAdd(PubPlatDTO pubPlatDTO) {
        PubPlatDO pubPlat = new PubPlatDO();
        String objID = pubPlatDTO.getObjID();
        if (StrUtil.isEmpty((CharSequence)objID)) {
            pubPlat.setObjId(IdUtil.randomUUID().toUpperCase());
        } else {
            pubPlat.setObjId(objID);
        }
        String time = DateUtil.now();
        BeanUtil.copyProperties((Object)pubPlatDTO, (Object)pubPlat);
        pubPlat.setHomePage(Integer.valueOf(pubPlatDTO.getHomePage()));
        QueryWrapper orderWaper = new QueryWrapper();
        orderWaper.orderByDesc((Object)"SHOWORDER");
        List platDOS = this.iPubPlatMapper.selectList((Wrapper)orderWaper);
        pubPlat.setShowOrder(CollUtil.isEmpty((Collection)platDOS) ? 0 : ((PubPlatDO)platDOS.get(0)).getShowOrder() + 1);
        pubPlat.setPubType(Integer.valueOf(pubPlatDTO.getPubType()));
        pubPlat.setCreateTime(time);
        pubPlat.setModifyTime(time);
        pubPlat.setUpdateTime(time);
        pubPlat.setSecretKey(IdUtil.randomUUID().substring(0, 16));
        if (!StrUtil.isEmpty((CharSequence)objID)) {
            this.dealImage(pubPlatDTO);
        }
        this.editPubPlat(pubPlat, pubPlatDTO, "add", "", "", "");
        this.iPubPlatMapper.insert(pubPlat);
        String companyIDs = pubPlatDTO.getCompanyIds();
        if (!StrUtil.isEmpty((CharSequence)companyIDs)) {
            List companyIDList = Convert.toList((Object)companyIDs);
            ArrayList<PubPlatDTO> pubPlatDTOList = new ArrayList<PubPlatDTO>();
            companyIDList.forEach(compID -> {
                PubPlatDTO platDTO = new PubPlatDTO();
                platDTO.setCompanyIds((String)compID);
                platDTO.setObjID(IdUtil.randomUUID().toUpperCase());
                pubPlatDTOList.add(platDTO);
            });
            this.iPubPlatMapper.addPubPlat(pubPlat.getObjId(), pubPlatDTOList);
        }
        return Result.succeed(true);
    }

    @Override
    public Result<Boolean> saveEdit(PubPlatDTO pubPlatDTO, String androidChange, String iosChange, String pcChange) {
        String time = DateUtil.now();
        PubPlatDO pubPlat = new PubPlatDO();
        pubPlat.setHomePage(Integer.valueOf(pubPlatDTO.getHomePage()));
        pubPlat.setModifyTime(time);
        pubPlat.setPubType(Integer.valueOf(pubPlatDTO.getPubType()));
        pubPlat.setObjId(pubPlatDTO.getObjID());
        BeanUtil.copyProperties((Object)pubPlatDTO, (Object)pubPlat);
        if (null != pubPlatDTO.getImg()) {
            this.dealImage(pubPlatDTO);
            pubPlat.setUpdateTime(time);
        } else {
            this.iHeadImgMapper.deleteById((Serializable)((Object)pubPlatDTO.getObjID()));
        }
        this.editPubPlat(pubPlat, pubPlatDTO, "edit", androidChange, iosChange, pcChange);
        this.iPubPlatMapper.updateById(pubPlat);
        return Result.succeed(true);
    }

    @Override
    public boolean deletePubPlat(String id) {
        ArrayList idList = CollUtil.toList((Object[])id.split(","));
        QueryWrapper attentionWrapper = new QueryWrapper();
        attentionWrapper.in((Object)"PUBPLATID", (Collection)idList);
        QueryWrapper permissionWrapper = new QueryWrapper();
        permissionWrapper.in((Object)"BID", (Collection)idList);
        QueryWrapper fileWrapper = new QueryWrapper();
        fileWrapper.in((Object)"PUBPLATID", (Collection)idList);
        QueryWrapper pubPlatWrapper = new QueryWrapper();
        pubPlatWrapper.in((Object)"OBJID", (Collection)idList);
        QueryWrapper imgWrapper = new QueryWrapper();
        imgWrapper.in((Object)"OBJID", (Collection)idList);
        this.iPubPlatMapper.delete((Wrapper)pubPlatWrapper);
        this.attentionMapper.delete((Wrapper)attentionWrapper);
        this.permissionMapper.delete((Wrapper)permissionWrapper);
        this.pubPlatCodeFileMapper.delete((Wrapper)fileWrapper);
        this.iHeadImgMapper.delete((Wrapper)imgWrapper);
        return true;
    }

    @Override
    public Boolean updateKey(String id) {
        QueryWrapper wrapper = new QueryWrapper();
        PubPlatDO pubPlat = new PubPlatDO();
        String time = DateUtil.now();
        String secretKey = IdUtil.randomUUID().substring(0, 16).toUpperCase();
        wrapper.eq((Object)"SECRETKEY", (Object)secretKey);
        if (this.iPubPlatMapper.selectCount((Wrapper)wrapper) == 0) {
            pubPlat.setObjId(id);
            pubPlat.setSecretKey(secretKey);
            pubPlat.setModifyTime(time);
            this.iPubPlatMapper.updateById(pubPlat);
        }
        return true;
    }

    @Override
    public boolean powerManger(String bID, String userIDs) {
        String time = DateUtil.now();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"BID", (Object)bID);
        this.iPubPlatOperateMapper.delete((Wrapper)wrapper);
        if (!StrUtil.isEmpty((CharSequence)userIDs)) {
            ArrayList userIDList = CollUtil.toList((Object[])userIDs.split(","));
            ArrayList<PubPlatOperateDO> iDList = new ArrayList<PubPlatOperateDO>();
            userIDList.forEach(userID -> {
                PubPlatOperateDO pubPlatoperateDO = new PubPlatOperateDO();
                pubPlatoperateDO.setUserID((String)userID);
                iDList.add(pubPlatoperateDO);
            });
            iDList.forEach(pubPlatOperateDO -> pubPlatOperateDO.setPermitId(IdUtil.randomUUID().toUpperCase()));
            this.iPubPlatMapper.powerMangerPerson(iDList, bID, time);
        }
        return true;
    }

    @Override
    @Transactional
    public boolean powerPerson(String bID, String userIDs, String roleIDs, String flag) {
        ArrayList<PubPlatPermission> iDList;
        String time = DateUtil.now();
        QueryWrapper wrapper = new QueryWrapper();
        QueryWrapper menuWrapper = new QueryWrapper();
        if ("pubPlat".equals(flag)) {
            wrapper.eq((Object)"BID", (Object)bID);
            this.permissionMapper.delete((Wrapper)wrapper);
        } else {
            menuWrapper.eq((Object)"BID", (Object)bID);
            this.iMenuPermissionMapper.delete((Wrapper)menuWrapper);
        }
        if (!StrUtil.isEmpty((CharSequence)userIDs)) {
            ArrayList userIDList = CollUtil.toList((Object[])userIDs.split(","));
            iDList = new ArrayList<PubPlatPermission>();
            userIDList.forEach(userID -> {
                PubPlatPermission permission = new PubPlatPermission();
                permission.setUserID((String)userID);
                iDList.add(permission);
            });
            iDList.forEach(pubPlatPermission -> pubPlatPermission.setPermitId(IdUtil.randomUUID().toUpperCase()));
            if ("pubPlat".equals(flag)) {
                this.iPubPlatMapper.powerPerson(iDList, bID, 1, time);
            } else {
                this.iPubPlatMapper.powerViewPerson(iDList, bID, 1, time);
            }
        }
        if (!StrUtil.isEmpty((CharSequence)roleIDs)) {
            ArrayList roleList = CollUtil.toList((Object[])roleIDs.split(","));
            iDList = new ArrayList();
            roleList.forEach(roleID -> {
                PubPlatPermission permission = new PubPlatPermission();
                permission.setRoleID((String)roleID);
                iDList.add(permission);
            });
            iDList.forEach(pubPlatPermission -> pubPlatPermission.setPermitId(IdUtil.randomUUID().toUpperCase()));
            if ("pubPlat".equals(flag)) {
                this.iPubPlatMapper.powerPerson(iDList, bID, 3, time);
            } else {
                this.iPubPlatMapper.powerViewPerson(iDList, bID, 3, time);
            }
        }
        return true;
    }

    @Override
    public UserRoleVO getUsersByObjID(String objID, String authority) {
        HashMap map = new HashMap();
        List<String> ids = this.iPubPlatMapper.getIDs(objID, authority);
        UserRoleVO userRoleVO = new UserRoleVO();
        if (!ids.isEmpty()) {
            List<UserVO> rosterVOList = this.iPubPlatMapper.getUsersByIDs(ids);
            List<RoleVO> roleList = this.iPubPlatMapper.getRoleByIDs(ids);
            if ("manage".equals(authority)) {
                userRoleVO.setUser(rosterVOList);
            } else {
                userRoleVO.setUser(rosterVOList);
                userRoleVO.setRole(roleList);
            }
        }
        return userRoleVO;
    }

    @Override
    @Transactional
    public Result<Boolean> dragPubPlat(String littleID, String largeID, String upDown) {
        PubPlatDO pubPlat;
        String time = DateUtil.now();
        List<PubPlatDO> pubPlatList = this.iPubPlatMapper.getPubBetween(littleID, largeID);
        if ("0".equals(upDown)) {
            pubPlat = new PubPlatDO();
            pubPlat.setObjId(largeID);
            pubPlat.setModifyTime(time);
            pubPlat.setShowOrder(pubPlatList.get(0).getShowOrder());
            this.iPubPlatMapper.updateById(pubPlat);
            pubPlatList.remove(pubPlatList.size() - 1);
            pubPlatList.forEach(pubPlatDO -> pubPlatDO.setShowOrder(pubPlatDO.getShowOrder() + 1));
            this.pubPlatDealService.updateBatchById(pubPlatList);
        }
        if ("1".equals(upDown)) {
            pubPlat = new PubPlatDO();
            pubPlat.setObjId(littleID);
            pubPlat.setModifyTime(time);
            pubPlat.setShowOrder(pubPlatList.get(pubPlatList.size() - 1).getShowOrder());
            this.iPubPlatMapper.updateById(pubPlat);
            pubPlatList.remove(0);
            pubPlatList.forEach(pubPlatDO -> pubPlatDO.setShowOrder(pubPlatDO.getShowOrder() - 1));
            this.pubPlatDealService.updateBatchById(pubPlatList);
        }
        return Result.succeed(true);
    }

    @Override
    public List<PubPlatMenuVO> loadMenuTree(String objID) {
        return this.iPubPlatMapper.loadMenuTree(objID);
    }

    @Override
    public PageDTO<PubPlatMenuVO> selectMenuList(String objID, String menuName, String parentMenuID, int pageIndex, int pageSize) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.and(i -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)i.apply("1=1", new Object[0]);
        });
        if (!StrUtil.isEmpty((CharSequence)menuName)) {
            wrapper.and(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)i.like((Object)"T.MENUNAME", (Object)StringUtil.replaceSpecialChar(menuName));
            });
        }
        if (!StrUtil.isEmpty((CharSequence)objID)) {
            wrapper.and(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)i.eq((Object)"T.PUBPLATID", (Object)objID);
            });
        }
        if (!StrUtil.isEmpty((CharSequence)parentMenuID)) {
            wrapper.and(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)i.eq((Object)"T.PARENTMENUID", (Object)parentMenuID);
            });
        }
        wrapper.last("ORDER BY T.SHOWORDER");
        PageDTO<PubPlatMenuVO> pageDTO = new PageDTO<PubPlatMenuVO>();
        pageDTO.setPageNum(pageIndex);
        pageDTO.setPageSize(pageSize);
        this.iPubPlatMapper.selectMenuList(pageDTO, (Wrapper)wrapper);
        return pageDTO;
    }

    @Override
    public Result<Boolean> saveMenu(PubPlatMenuDTO pubPlatMenuDTO) {
        PubPlatMenuDO platMenuDO = new PubPlatMenuDO();
        BeanUtil.copyProperties((Object)pubPlatMenuDTO, (Object)platMenuDO);
        platMenuDO.setMenuId(IdUtil.randomUUID().toUpperCase());
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"SHOWORDER", (Object)pubPlatMenuDTO.getShowOrder());
        if (this.menuMapper.selectCount((Wrapper)wrapper) > 0) {
            return Result.succeed(false, "\u5df2\u5b58\u5728\u76f8\u540c\u7684\u5c55\u793a\u987a\u5e8f");
        }
        this.menuMapper.insert(platMenuDO);
        return Result.succeed(true);
    }

    @Override
    public Result<Boolean> editMenu(PubPlatMenuDO pubPlatMenuDO) {
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"SHOWORDER", (Object)pubPlatMenuDO.getShowOrder())).ne((Object)"MENUID", (Object)pubPlatMenuDO.getMenuId())).eq((Object)"PUBPLATID", (Object)pubPlatMenuDO.getPubPlatId());
        if (this.menuMapper.selectCount((Wrapper)wrapper) > 0) {
            return Result.succeed(false, "\u5df2\u5b58\u5728\u76f8\u540c\u7684\u5c55\u793a\u987a\u5e8f");
        }
        this.menuMapper.updateById(pubPlatMenuDO);
        return Result.succeed(true);
    }

    @Override
    public boolean deleteMenus(String menuID) {
        ArrayList allMenuIDs = new ArrayList();
        ArrayList menuVOS = new ArrayList();
        QueryWrapper wrapper = new QueryWrapper();
        ArrayList menuIDList = CollUtil.toList((Object[])menuID.split(","));
        menuIDList.forEach(menuId -> {
            menuVOS.addAll(this.selectMenuList("", "", (String)menuId, 1, -1).getList());
            allMenuIDs.add(menuId);
        });
        menuVOS.forEach(pubPlatMenuVO -> allMenuIDs.add(pubPlatMenuVO.getMenuId()));
        wrapper.in((Object)"MENUID", allMenuIDs);
        this.menuMapper.delete((Wrapper)wrapper);
        return true;
    }

    @Override
    public PageDTO<PubPlatTypeDO> getPubPlatTypeList(String typeName, int pageNum, int pageSize) {
        QueryWrapper wrapper = new QueryWrapper();
        PageDTO pageDTO = new PageDTO();
        pageDTO.setPageNum(pageNum);
        pageDTO.setPageSize(pageSize);
        if (!StrUtil.isEmpty((CharSequence)typeName)) {
            wrapper.and(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)i.like((Object)"TYPENAME", (Object)StringUtil.replaceSpecialChar(typeName.trim()));
            });
        }
        return this.iPubPlatMapper.getPubPlatTypeList(pageDTO, (Wrapper)wrapper);
    }

    @Override
    public Result<Boolean> saveAddType(PubPlatTypeDTO pubPlatTypeDTO) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.orderByDesc((Object)"SHOWORDER");
        String time = DateUtil.now();
        PubPlatTypeDO pubPlatTypeDO = new PubPlatTypeDO();
        BeanUtil.copyProperties((Object)pubPlatTypeDTO, (Object)pubPlatTypeDO);
        pubPlatTypeDO.setTypeId(IdUtil.randomUUID().toUpperCase().substring(0, 36));
        List list = this.typeMapper.selectList((Wrapper)wrapper);
        pubPlatTypeDO.setShowOrder(CollUtil.isEmpty((Collection)list) ? 0 : ((PubPlatTypeDO)list.get(0)).getShowOrder() + 1);
        pubPlatTypeDO.setCreateTime(time);
        pubPlatTypeDO.setModifyTime(time);
        pubPlatTypeDO.setCreateUserName(ShiroKit.getUser().getName());
        pubPlatTypeDO.setCreateUserID(ShiroKit.getUser().getId());
        pubPlatTypeDO.setOrganiseId(ShiroKit.getUser().getDeptId());
        this.typeMapper.insert(pubPlatTypeDO);
        return Result.succeed(true);
    }

    @Override
    public Result<Boolean> saveEditType(PubPlatTypeDO pubPlatTypeDO) {
        pubPlatTypeDO.setModifyTime(DateUtil.now());
        this.typeMapper.updateById(pubPlatTypeDO);
        return Result.succeed(true);
    }

    @Override
    public Result<Boolean> deletePubPlatType(String typeIDs) {
        List<String> userList = Arrays.asList(typeIDs.split(","));
        int count = this.iPubPlatMapper.selectCount((Wrapper)new QueryWrapper().lambda().in(PubPlatDO::getCategoryId, userList));
        if (count > 0 && userList.size() > 1) {
            return Result.failed("\u65e0\u6cd5\u5220\u9664\uff01\uff08\u5b58\u5728\u5df2\u5173\u8054\u5fae\u5e94\u7528\u7684\u5206\u7c7b!\uff09");
        }
        if (count > 0 && userList.size() == 1) {
            return Result.failed("\u65e0\u6cd5\u5220\u9664\uff01\uff08\u5206\u7c7b\u5df2\u5173\u8054\u5fae\u5e94\u7528\uff01\uff09");
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"TYPEID", userList);
        this.typeMapper.delete((Wrapper)wrapper);
        return Result.succeed(true);
    }

    @Override
    public boolean dragType(String littleID, String largeID, String upDown) {
        PubPlatTypeDO pubPlatType;
        String time = DateUtil.now();
        List<PubPlatTypeDO> pubPlatTypeS = this.iPubPlatMapper.getPubTypeBetween(littleID, largeID);
        if ("0".equals(upDown)) {
            pubPlatType = new PubPlatTypeDO();
            pubPlatType.setTypeId(largeID);
            pubPlatType.setShowOrder(pubPlatTypeS.get(0).getShowOrder());
            pubPlatType.setModifyTime(time);
            this.typeMapper.updateById(pubPlatType);
            pubPlatTypeS.remove(pubPlatTypeS.size() - 1);
            pubPlatTypeS.forEach(pubPlatTypeDO -> pubPlatTypeDO.setShowOrder(pubPlatTypeDO.getShowOrder() + 1));
            this.typeService.updateBatchById(pubPlatTypeS);
        }
        if ("1".equals(upDown)) {
            pubPlatType = new PubPlatTypeDO();
            pubPlatType.setTypeId(littleID);
            pubPlatType.setShowOrder(pubPlatTypeS.get(pubPlatTypeS.size() - 1).getShowOrder());
            pubPlatType.setModifyTime(time);
            this.typeMapper.updateById(pubPlatType);
            pubPlatTypeS.remove(0);
            pubPlatTypeS.forEach(pubPlatTypeDO -> pubPlatTypeDO.setShowOrder(pubPlatTypeDO.getShowOrder() - 1));
            this.typeService.updateBatchById(pubPlatTypeS);
        }
        return true;
    }

    @Override
    public int selectCount(String pubPlatID) {
        QueryWrapper wrapper = new QueryWrapper();
        PubPlatDO pubPlatDO = new PubPlatDO();
        pubPlatDO.setObjId(pubPlatID);
        pubPlatDO.setIsDefault(0);
        ((QueryWrapper)wrapper.eq((Object)"OBJID", (Object)pubPlatID)).eq((Object)"ISDEFAULT", (Object)0);
        return this.iPubPlatMapper.selectCount((Wrapper)wrapper);
    }

    @Override
    public Result<Boolean> publish(PubPlatDTO pubPlatDTO, String androidChange, String iosChange, String pcChange) {
        String time = DateUtil.now();
        PubPlatDO pubPlat = new PubPlatDO();
        pubPlat.setModifyTime(time);
        pubPlat.setObjId(pubPlatDTO.getObjID());
        BeanUtil.copyProperties((Object)pubPlatDTO, (Object)pubPlat);
        this.editPubPlat(pubPlat, pubPlatDTO, "edit", androidChange, iosChange, pcChange);
        this.iPubPlatMapper.updateById(pubPlat);
        return Result.succeed(true);
    }

    @Override
    public List<String> ListPermittedUserId(String pubPlatId) {
        return this.iPubPlatMapper.ListPermittedUserId(pubPlatId);
    }

    @Override
    public PageVO<UserVO> selectUserList(String searchKey, String orgID, String roleIDs, String pubPlatID, int pageNum, int pageSize, String isAuthorized, String authorizedIDs) {
        PageDTO<Object> pageDTO = new PageDTO();
        pageDTO.setPageSize(pageSize);
        pageDTO.setPageNum(pageNum);
        int count = 0;
        if (!StrUtil.isEmpty((CharSequence)pubPlatID)) {
            count = this.selectCount(pubPlatID);
        }
        QueryWrapper wrapper = new QueryWrapper();
        if (count != 0) {
            wrapper.and(i -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)i.inSql((Object)"U.USER_ID", "SELECT OBJID FROM EIM_PUBPLAT_PERMISSION WHERE BID='" + pubPlatID + "'" + " AND PERMITTYPE='1'")).or()).inSql((Object)"U.USER_ID", "SELECT USER_ID FROM sys_user_role WHERE granted_role IN(SELECT PU.OBJID FROM EIM_PUBPLAT_PERMISSION PU WHERE PU.PERMITTYPE='3' AND PU.BID='" + pubPlatID + "'" + ")");
            });
        }
        if (!StrUtil.isEmpty((CharSequence)searchKey)) {
            wrapper.like((Object)"u.user_name", (Object)searchKey);
        }
        if (!StrUtil.isEmpty((CharSequence)orgID)) {
            wrapper.in((Object)"U.CORPORATION_ID", Arrays.asList(orgID.split(",")));
        }
        if (!StrUtil.isEmpty((CharSequence)roleIDs)) {
            wrapper.inSql((Object)"U.USER_ID", "SELECT USER_ID FROM sys_user_role  WHERE granted_role  IN ('" + roleIDs.replace(",", "','") + "'" + ")");
        }
        if (!StrUtil.isEmpty((CharSequence)isAuthorized)) {
            ArrayList authorizedIDList = CollUtil.toList((Object[])authorizedIDs.split(","));
            if ("1".equals(isAuthorized)) {
                wrapper.in((Object)"U.USER_ID", (Collection)authorizedIDList);
            } else {
                wrapper.notIn((Object)"U.USER_ID", (Collection)authorizedIDList);
            }
        }
        wrapper.ne((Object)"account_status", (Object)2);
        pageDTO = this.iPubPlatMapper.searchUser(pageDTO, "", (Wrapper)wrapper);
        PageVO<UserVO> pageVO = new PageVO<UserVO>();
        BeanUtil.copyProperties(pageDTO, pageVO);
        return pageVO;
    }
}

