/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.pubplat.controller.manage;

import com.jxdinfo.hussar.pubplat.model.PageDTO;
import com.jxdinfo.hussar.pubplat.model.PageVO;
import com.jxdinfo.hussar.pubplat.model.Result;
import com.jxdinfo.hussar.pubplat.model.SearchParamDTO;
import com.jxdinfo.hussar.pubplat.model.UserRoleVO;
import com.jxdinfo.hussar.pubplat.model.UserVO;
import com.jxdinfo.hussar.pubplat.model.menu.PubPlatMenuDO;
import com.jxdinfo.hussar.pubplat.model.menu.PubPlatMenuDTO;
import com.jxdinfo.hussar.pubplat.model.menu.PubPlatMenuVO;
import com.jxdinfo.hussar.pubplat.model.pubplat.AuthorizeDTO;
import com.jxdinfo.hussar.pubplat.model.pubplat.PubPlatDO;
import com.jxdinfo.hussar.pubplat.model.pubplat.PubPlatDTO;
import com.jxdinfo.hussar.pubplat.model.type.PubPlatTypeDO;
import com.jxdinfo.hussar.pubplat.model.type.PubPlatTypeDTO;
import com.jxdinfo.hussar.pubplat.service.IPubPlatService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5fae\u5e94\u7528\u540e\u53f0\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/v1/pubPlat/manager"})
public class PubPlatManageController {
    private static final Logger log = LoggerFactory.getLogger(PubPlatManageController.class);
    @Resource
    private IPubPlatService iPubPlatService;

    @ApiOperation(value="\u67e5\u8be2\u5fae\u5e94\u7528\u5217\u8868\u9875\u6570\u636e")
    @GetMapping(value={"/pageList"})
    @RequiresPermissions(value={"microAppMain:microList"})
    public Result<PageDTO<PubPlatDO>> getPageList(@RequestParam(value="searchKey", required=false) @ApiParam(value="\u5fae\u5e94\u7528\u540d\u79f0") String searchKey, @RequestParam(value="pageNum", defaultValue="1") @ApiParam(value="\u5f53\u524d\u9875") int pageNum, @RequestParam(value="pageSize", defaultValue="30") @ApiParam(value="\u6bcf\u9875\u5927\u5c0f") int pageSize, @RequestParam(value="classifyId", required=false) @ApiParam(value="\u5206\u7c7bID") String classifyID, @RequestParam(value="pubType", required=false) @ApiParam(value="\u7c7b\u578b") String pubType) {
        PageDTO pageDTO = new PageDTO();
        pageDTO.setPageNum(pageNum);
        pageDTO.setPageSize(pageSize);
        return Result.succeed(this.iPubPlatService.getPubPlatList(searchKey, pageDTO, classifyID, pubType));
    }

    @ApiOperation(value="\u67e5\u770b\u5fae\u5e94\u7528\u8be6\u60c5(\u4fee\u6539\u9875\u9762\u8be6\u60c5)")
    @GetMapping(value={"{pubPlatId}"})
    public Result<PubPlatDTO> getPubPlat(@PathVariable(value="pubPlatId") @ApiParam(value="\u5fae\u5e94\u7528id") String pubPlatID) {
        return Result.succeed(this.iPubPlatService.getPubPlat(pubPlatID));
    }

    @ApiOperation(value="\u4fdd\u5b58\u65b0\u589e\u5fae\u5e94\u7528\u6570\u636e")
    @PostMapping(value={"save"})
    @RequiresPermissions(value={"microAppMain:add"})
    public Result<Boolean> saveAdd(@RequestBody PubPlatDTO pubPlatDTO) {
        return this.iPubPlatService.saveAdd(pubPlatDTO);
    }

    @ApiOperation(value="\u4fdd\u5b58\u4fee\u6539\u5fae\u5e94\u7528\u6570\u636e")
    @PostMapping(value={"update"})
    public Result<Boolean> saveEdit(@RequestBody PubPlatDTO pubPlatDTO) {
        return this.iPubPlatService.saveEdit(pubPlatDTO, pubPlatDTO.getAndroidChange(), pubPlatDTO.getIosChange(), pubPlatDTO.getPcChange());
    }

    @ApiOperation(value="\u5220\u9664\u5fae\u5e94\u7528")
    @GetMapping(value={"delete"})
    public Result<Boolean> deletePubPlat(@RequestParam(value="id") @ApiParam(value="id") String id) {
        return Result.succeed(this.iPubPlatService.deletePubPlat(id));
    }

    @ApiOperation(value="\u5237\u65b0key")
    @GetMapping(value={"/key"})
    public Result<Boolean> updateKey(@RequestParam(value="id", required=false) @ApiParam(value="id") String id) {
        return Result.succeed(this.iPubPlatService.updateKey(id));
    }

    @ApiOperation(value="\u6388\u6743\u5fae\u5e94\u7528\u7ba1\u7406")
    @GetMapping(value={"/manager"})
    public Result<Boolean> powerManger(@RequestParam(value="bId") @ApiParam(value="\u5fae\u5e94\u7528id") String bID, @RequestParam(value="userId", required=false) @ApiParam(value="\u591a\u7528\u6237id") String userIDs) {
        return Result.succeed(this.iPubPlatService.powerManger(bID, userIDs));
    }

    @ApiOperation(value="\u6388\u6743\u5fae\u5e94\u7528\u5bdf\u770b")
    @PostMapping(value={"/view"})
    public Result<Boolean> powerPerson(@RequestBody AuthorizeDTO authorizeDTO) {
        return Result.succeed(this.iPubPlatService.powerPerson(authorizeDTO.getPubPlatID(), authorizeDTO.getUserIDs(), authorizeDTO.getRoleIDs(), "pubPlat"));
    }

    @ApiOperation(value="\u5fae\u5e94\u7528\u83dc\u5355\u67e5\u770b\u6388\u6743")
    @PostMapping(value={"/menuView"})
    public Result<Boolean> powerMenuView(@RequestBody AuthorizeDTO authorizeDTO) {
        return Result.succeed(this.iPubPlatService.powerPerson(authorizeDTO.getPubMenuID(), authorizeDTO.getUserIDs(), authorizeDTO.getRoleIDs(), "pubMenu"));
    }

    @ApiOperation(value="\u83b7\u53d6\u6388\u6743\u7ba1\u7406\u8be5\u5fae\u5e94\u7528\u7684\u4eba\u5458")
    @GetMapping(value={"/manager/user"})
    public Result<UserRoleVO> getPubManager(@RequestParam(value="objId") @ApiParam(value="\u5fae\u5e94\u7528id") String objID) {
        return Result.succeed(this.iPubPlatService.getUsersByObjID(objID, "manage"));
    }

    @ApiOperation(value="\u83b7\u53d6\u5fae\u5e94\u7528\u6388\u6743\u7684\u4eba\u5458\u89d2\u8272")
    @GetMapping(value={"/pubViewer"})
    public Result<UserRoleVO> getPubViewer(@RequestParam(value="objId") @ApiParam(value="\u5fae\u5e94\u7528id") String objID) {
        return Result.succeed(this.iPubPlatService.getUsersByObjID(objID, "pubView"));
    }

    @ApiOperation(value="\u83b7\u53d6\u8be5\u5fae\u5e94\u7528\u83dc\u5355\u6388\u6743\u7684\u4eba\u5458\u89d2\u8272")
    @GetMapping(value={"/menuViewer"})
    public Result<UserRoleVO> getMenuViewer(@RequestParam(value="pubMenuID") @ApiParam(value="\u5fae\u5e94\u7528id") String pubMenuID) {
        return Result.succeed(this.iPubPlatService.getUsersByObjID(pubMenuID, "menuView"));
    }

    @ApiOperation(value="\u5fae\u5e94\u7528\u62d6\u62c9\u79fb\u52a8")
    @GetMapping(value={"/showOrder"})
    public Result<Boolean> dragPubPlat(@RequestParam @ApiParam(value="\u987a\u5e8f\u8f83\u5c0f\u5fae\u5e94\u7528id") String littleID, @RequestParam @ApiParam(value="\u987a\u5e8f\u8f83\u5927\u5fae\u5e94\u7528id") String largeID, @RequestParam @ApiParam(value="\u4e0a\u79fb\u6216\u4e0b\u79fb") String upDown) {
        return this.iPubPlatService.dragPubPlat(littleID, largeID, upDown);
    }

    @ApiOperation(value="\u52a0\u8f7d\u5fae\u5e94\u7528\u83dc\u5355\u6811")
    @GetMapping(value={"/menuTree"})
    public Result<List<PubPlatMenuVO>> loadMenuTree(@RequestParam(value="objId") @ApiParam(value="\u5fae\u5e94\u7528id") String objID) {
        return Result.succeed(this.iPubPlatService.loadMenuTree(objID));
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5fae\u5e94\u7528\u83dc\u5355\u5217\u8868")
    @GetMapping(value={"/menuList"})
    public Result<PageDTO<PubPlatMenuVO>> selectMenuList(@RequestParam(value="objId", required=false) @ApiParam(value="\u5fae\u5e94\u7528id") String objID, @RequestParam(value="menuName", required=false) @ApiParam(value="\u83dc\u5355\u540d\u79f0") String menuName, @RequestParam(value="parentMenuId", required=false) @ApiParam(value="\u7236\u7ea7\u83dc\u5355ID") String parentMenuID, @RequestParam(value="pageIndex", defaultValue="1") @ApiParam(value="\u5f53\u524d\u9875") int pageIndex, @RequestParam(value="pageSize", defaultValue="20") @ApiParam(value="\u6bcf\u9875\u5927\u5c0f") int pageSize) {
        return Result.succeed(this.iPubPlatService.selectMenuList(objID, menuName, parentMenuID, pageIndex, pageSize));
    }

    @ApiOperation(value="\u4fdd\u5b58\u83dc\u5355\u4fe1\u606f")
    @PostMapping(value={"save/menu"})
    public Result<Boolean> saveMenu(@RequestBody @ApiParam(value="\u5fae\u5e94\u7528\u83dc\u5355\u4fe1\u606f") PubPlatMenuDTO pubPlatMenuDTO) {
        return this.iPubPlatService.saveMenu(pubPlatMenuDTO);
    }

    @ApiOperation(value="\u4fee\u6539\u83dc\u5355\u4fe1\u606f")
    @PostMapping(value={"update/menu"})
    public Result<Boolean> editMenu(@RequestBody @ApiParam(value="\u5fae\u5e94\u7528\u83dc\u5355\u4fe1\u606f") PubPlatMenuDO pubPlatMenuDO) {
        return this.iPubPlatService.editMenu(pubPlatMenuDO);
    }

    @ApiOperation(value="\u5220\u9664\u83dc\u5355\u4fe1\u606f")
    @GetMapping(value={"delete/menu"})
    public Result<Boolean> deleteMenus(@RequestParam(value="menuId") @ApiParam(value="\u83dc\u5355id") String menuID) {
        return Result.succeed(this.iPubPlatService.deleteMenus(menuID));
    }

    @ApiOperation(value="\u83b7\u53d6\u5fae\u5e94\u7528\u5206\u7c7b\u5217\u8868\u9875\u6570\u636e")
    @GetMapping(value={"/type"})
    public Result<PageDTO<PubPlatTypeDO>> getPubPlatTypeList(@RequestParam(value="typeName", required=false) @ApiParam(value="\u5fae\u5e94\u7528\u5206\u7c7b\u540d") String typeName, @RequestParam(value="pageNum", defaultValue="1") @ApiParam(value="\u5f53\u524d\u9875") int pageNum, @RequestParam(value="pageSize", defaultValue="20") @ApiParam(value="\u6bcf\u9875\u5927\u5c0f") int pageSize) {
        return Result.succeed(this.iPubPlatService.getPubPlatTypeList(typeName, pageNum, pageSize));
    }

    @ApiOperation(value="\u4fdd\u5b58\u5fae\u5e94\u7528\u5206\u7c7b\u65b0\u589e")
    @PostMapping(value={"save/type"})
    public Result<Boolean> saveAddType(@RequestBody @ApiParam(value="\u5fae\u5e94\u7528\u5206\u7c7b\u4fe1\u606f") PubPlatTypeDTO pubPlatTypeDTO) {
        return this.iPubPlatService.saveAddType(pubPlatTypeDTO);
    }

    @ApiOperation(value="\u4fdd\u5b58\u5fae\u5e94\u7528\u5206\u7c7b\u4fee\u6539")
    @PostMapping(value={"update/type"})
    public Result<Boolean> saveEditType(@RequestBody @ApiParam(value="\u4e3a\u5e94\u7528\u5206\u7c7b\u4fe1\u606f") PubPlatTypeDO pubPlatTypeDO) {
        return this.iPubPlatService.saveEditType(pubPlatTypeDO);
    }

    @ApiOperation(value="\u5220\u9664\u5fae\u5e94\u7528\u5206\u7c7b")
    @GetMapping(value={"delete/type"})
    public Result<Boolean> deletePubPlatType(@RequestParam(value="typeIds") @ApiParam(value="\u5206\u7c7bids") String typeIDs) {
        return this.iPubPlatService.deletePubPlatType(typeIDs);
    }

    @ApiOperation(value="\u62d6\u62fd\u5fae\u5e94\u7528\u5206\u7c7b")
    @GetMapping(value={"/typeOrder"})
    public Result<Boolean> dragType(@RequestParam @ApiParam(value="\u987a\u5e8f\u8f83\u5c0f\u5fae\u5e94\u7528id") String littleID, @RequestParam @ApiParam(value="\u987a\u5e8f\u8f83\u5927\u5fae\u5e94\u7528id") String largeID, @RequestParam @ApiParam(value="\u4e0a\u79fb\u6216\u4e0b\u79fb\uff0c0\u4e0a1\u4e0b") String upDown) {
        return Result.succeed(this.iPubPlatService.dragType(littleID, largeID, upDown));
    }

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u5bfb\u662f\u5426\u5b58\u5728\u6ee1\u8db3\u6761\u4ef6\u7684\u5fae\u5e94\u7528")
    @GetMapping(value={"/count"})
    public Result<Integer> selectCount(@RequestParam(value="pubPlatID") String pubPlatID) {
        return Result.succeed(this.iPubPlatService.selectCount(pubPlatID));
    }

    @ApiOperation(value="\u5fae\u5e94\u7528\u53d1\u5e03\u63a5\u53e3")
    @PostMapping(value={"/publish"})
    public Result<Boolean> publish(@RequestBody PubPlatDTO pubPlatDTO) {
        return this.iPubPlatService.publish(pubPlatDTO, pubPlatDTO.getAndroidChange(), pubPlatDTO.getIosChange(), pubPlatDTO.getPcChange());
    }

    @ApiOperation(value="\u83b7\u53d6\u6709\u5fae\u5e94\u7528\u6743\u9650\u7684\u4eba\u5458id")
    @GetMapping(value={"/{pubPlatId}/permissionId"})
    public List<String> getPermissionID(@PathVariable(value="pubPlatId") String pubPlatID) {
        return this.iPubPlatService.ListPermittedUserId(pubPlatID);
    }

    @ApiOperation(value="\u5fae\u5e94\u7528\u53ef\u89c1\u4eba\u5458\u5206\u9875\u67e5\u8be2")
    @GetMapping(value={"/pubPlat/users"})
    public Result<PageVO<UserVO>> selectUserList(@RequestParam(value="searchKey", required=false) @ApiParam(value="\u7528\u6237\u540d\u6216\u5de5\u53f7") String searchKey, @RequestParam(value="orgId", required=false) @ApiParam(value="\u90e8\u95e8id") String orgID, @RequestParam(value="roleIds", required=false) @ApiParam(value="\u7528\u6237\u89d2\u8272id") String roleIDs, @RequestParam(value="pubPlatId", required=false) @ApiParam(value="\u5fae\u5e94\u7528id") String pubPlatID, @RequestParam(value="pageNum", defaultValue="1") @ApiParam(value="\u5f53\u524d\u9875") int pageNum, @RequestParam(value="pageSize", defaultValue="30") @ApiParam(value="\u6bcf\u9875\u5927\u5c0f") int pageSize, @RequestParam(value="isAuthorized", required=false) @ApiParam(value="\u662f\u5426\u6388\u6743") String isAuthorized, @RequestParam(value="authorizedIDs", required=false) @ApiParam(value="\u88ab\u6388\u6743\u7684ids") String authorizedIDs) {
        return Result.succeed(this.iPubPlatService.selectUserList(searchKey, orgID, roleIDs, pubPlatID, pageNum, pageSize, isAuthorized, authorizedIDs));
    }

    @ApiOperation(value="\u7ba1\u7406\u6388\u6743\u4eba\u5458\u67e5\u8be2\u63a5\u53e3")
    @PostMapping(value={"/authUsers"})
    public Result<PageVO<UserVO>> selectAuthUsers(@RequestBody SearchParamDTO searchParamDTO) {
        return Result.succeed(this.iPubPlatService.selectUserList(searchParamDTO.getSearchKey(), searchParamDTO.getOrgId(), "", "", searchParamDTO.getPageNum(), searchParamDTO.getPageSize(), searchParamDTO.getIsAuthorized(), searchParamDTO.getAuthorizedIDs()));
    }
}

