/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.pubplat.controller;

import com.jxdinfo.hussar.pubplat.model.PageDTO;
import com.jxdinfo.hussar.pubplat.model.Result;
import com.jxdinfo.hussar.pubplat.model.menu.PubPlatMenuVO;
import com.jxdinfo.hussar.pubplat.model.pubplat.PubPlatVO;
import com.jxdinfo.hussar.pubplat.service.PubPlatService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5fae\u5e94\u7528\u76f8\u5173\u64cd\u4f5c"})
@RestController
@RequestMapping(value={"v1/pubPlat"})
public class PubPlatController {
    private static final Logger log = LoggerFactory.getLogger(PubPlatController.class);
    @Resource
    private PubPlatService pubPlatService;

    @ApiOperation(value="\u83b7\u53d6\u5fae\u5e94\u7528\u5217\u8868 'J_PUB_0001' 'J_PUB_0002'")
    @GetMapping
    public Result<List<PubPlatVO>> getPubPlatList(@RequestParam(defaultValue="0") int flag, @RequestParam String deviceTag, @RequestParam String userId) {
        List<PubPlatVO> pubVOList;
        if (0 == flag) {
            PageDTO<PubPlatVO> pageDTO = new PageDTO<PubPlatVO>();
            pageDTO.setPageSize(-1);
            pageDTO.setPageNum(1);
            pubVOList = this.pubPlatService.getNotFocusPubPlatList(pageDTO, null, deviceTag, userId).getList();
        } else {
            pubVOList = this.pubPlatService.getFocusPubPlatList(deviceTag, userId);
        }
        pubVOList.forEach(i -> {
            if (i.getMenuList() == null) {
                i.setMenuList(new ArrayList<PubPlatMenuVO>());
            }
        });
        return Result.succeed(pubVOList);
    }

    @ApiOperation(value="\u83b7\u53d6\u5fae\u5e94\u7528\u5217\u8868 'J_PUB_0001' 'J_PUB_0002'")
    @GetMapping(value={"page"})
    public Result<PageDTO<PubPlatVO>> getPubPlatList(@RequestParam @ApiParam(value="\u641c\u7d22\u5173\u952e\u5b57") String searchKey, @RequestParam(required=false, defaultValue="20") @ApiParam(value="\u6bcf\u9875\u5927\u5c0f") Integer pageSize, @RequestParam(required=false, defaultValue="1") @ApiParam(value="\u5f53\u524d\u9875") Integer pageNum, @RequestParam String deviceTag, @RequestParam String userId) {
        PageDTO<PubPlatVO> pageDTO = new PageDTO<PubPlatVO>();
        pageDTO.setPageSize(pageSize);
        pageDTO.setPageNum(pageNum);
        PageDTO<PubPlatVO> page = this.pubPlatService.getNotFocusPubPlatList(pageDTO, searchKey, deviceTag, userId);
        page.getRecords().forEach(i -> {
            if (i.getMenuList() == null) {
                i.setMenuList(new ArrayList<PubPlatMenuVO>());
            }
        });
        return Result.succeed(page);
    }

    @ApiOperation(value="\u6279\u91cf\u5173\u6ce8\u5fae\u5e94\u7528 'J_PUB_0003'")
    @PostMapping(value={"/follow"})
    public Result<Boolean> followPubPlat(@RequestParam @ApiParam(value="\u5fae\u5e94\u7528id\u62fc\u63a5\u4e32") String pubPlatID, @RequestParam String deviceTag, @RequestParam String userId) {
        return Result.succeed(this.pubPlatService.followPubPlat(pubPlatID, deviceTag, userId));
    }

    @ApiOperation(value="\u53d6\u6d88\u5173\u6ce8\u5fae\u5e94\u7528 'J_PUB_0004'")
    @PostMapping(value={"delete/{pubPlatID}"})
    public Result<Boolean> unFollowPubPlat(@PathVariable @ApiParam(value="\u5fae\u5e94\u7528id") String pubPlatID, @RequestParam String deviceTag, @RequestParam String userId) {
        return Result.succeed(this.pubPlatService.unFollowPubPlat(pubPlatID, deviceTag, userId));
    }

    @ApiOperation(value="\u5fae\u5e94\u7528\u6d88\u606f\u662f\u5426\u63d0\u9192 'J_PUB_0006'")
    @PostMapping(value={"update/remind/{pubPlatID}"})
    public Result<Boolean> remindPubPlat(@PathVariable @ApiParam(value="\u5fae\u5e94\u7528id") String pubPlatID, @RequestParam @ApiParam(value="\u662f\u5426\u63d0\u9192") int remindFlag, @RequestParam String deviceTag, @RequestParam String userId) {
        int num = this.pubPlatService.queryPubPlatIsExit(pubPlatID);
        if (num == 0) {
            return Result.failedWith(false, 500, "\u8be5\u5fae\u5e94\u7528\u5df2\u88ab\u5220\u9664");
        }
        return Result.succeed(this.pubPlatService.updatePubAttention(pubPlatID, "remind", remindFlag, deviceTag, userId));
    }

    @ApiOperation(value="\u83b7\u53d6\u5fae\u5e94\u7528\u8be6\u60c5(\u5173\u6ce8\u7684) 'J_PUB_0007'")
    @PostMapping(value={"/{pubPlatID}"})
    public Result<PubPlatVO> getPubPlatInfo(@PathVariable @ApiParam(value="\u5fae\u5e94\u7528ID") String pubPlatID, @RequestParam String deviceTag, @RequestParam String userId) {
        int num = this.pubPlatService.queryPubPlatIsExit(pubPlatID);
        if (num == 0) {
            return Result.failedWith(new PubPlatVO(), 500, "\u8be5\u5fae\u5e94\u7528\u5df2\u88ab\u5220\u9664");
        }
        PubPlatVO pubPlatVO = this.pubPlatService.getPubPlatInfo(pubPlatID, deviceTag, userId);
        if (pubPlatVO.getMenuList() == null) {
            pubPlatVO.setMenuList(new ArrayList<PubPlatMenuVO>());
        }
        return Result.succeed(pubPlatVO);
    }

    @ApiOperation(value="\u5fae\u5e94\u7528\u6d88\u606f\u662f\u5426\u7f6e\u9876 'J_PUB_0010'")
    @PostMapping(value={"top/{pubPlatID}"})
    public Result<Boolean> topPubPlat(@PathVariable @ApiParam(value="\u5fae\u5e94\u7528id") String pubPlatID, @RequestParam @ApiParam(value="\u662f\u5426\u7f6e\u9876") int topFlag, @RequestParam String deviceTag, @RequestParam String userId) {
        int num = this.pubPlatService.queryPubPlatIsExit(pubPlatID);
        if (num == 0) {
            return Result.failedWith(false, 500, "\u8be5\u5fae\u5e94\u7528\u5df2\u88ab\u5220\u9664");
        }
        return Result.succeed(this.pubPlatService.updatePubAttention(pubPlatID, "top", topFlag, deviceTag, userId));
    }

    @ApiOperation(value="\u83b7\u53d6\u5168\u90e8user\u5173\u6ce8\u7684\u5fae\u5e94\u7528\u7684\u72b6\u6001")
    @PostMapping(value={"/status"})
    public Result<List<PubPlatVO>> getPubStatus(@RequestParam(value="time", required=false) @ApiParam(value="\u4e0a\u6b21\u540c\u6b65\u7684\u670d\u52a1\u5668\u7684\u65f6\u95f4") String time, @RequestParam String userId) {
        List<PubPlatVO> list = this.pubPlatService.getPubStatusByUserID(time, userId);
        list.forEach(i -> {
            if (i.getMenuList() == null) {
                i.setMenuList(new ArrayList<PubPlatMenuVO>());
            }
        });
        return Result.succeed(list);
    }
}

