/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.pubplat.controller;

import com.jxdinfo.hussar.core.config.HussarConfig;
import com.jxdinfo.hussar.pubplat.model.EfsFileRecord;
import com.jxdinfo.hussar.pubplat.service.EfsFileService;
import com.jxdinfo.hussar.pubplat.util.FileUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RequestMapping(value={"file/v1"})
@Api(tags={"\u6587\u4ef6\u4e0a\u4f20\u4e0e\u4e0b\u8f7d"})
@RestController
public class FileController {
    @Resource
    private EfsFileService efsFileService;
    @Resource
    HussarConfig hussarConfig;

    @ApiOperation(value="\u4e0a\u4f20", notes="\u6587\u4ef6\u4e0a\u4f20")
    @PostMapping
    @ResponseBody
    public Object uploadFile(String fileId, MultipartFile file) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        boolean success = true;
        try {
            BufferedImage bufferedImage;
            String fileName = file.getOriginalFilename();
            String fileType = "";
            if (fileName.indexOf(".") > -1) {
                fileType = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length());
            }
            Long fileSizeLong = file.getSize();
            Integer widthInt = 0;
            Integer heightInt = 0;
            InputStream fileInput = file.getInputStream();
            String fastFileName = FilenameUtils.getExtension((String)file.getOriginalFilename());
            if (FileUtil.imageBoolean(fileType) && (bufferedImage = ImageIO.read(file.getInputStream())) != null) {
                widthInt = bufferedImage.getWidth();
                heightInt = bufferedImage.getHeight();
            }
            String fdfsPath = FileUtil.uploadFileToLocal(this.hussarConfig.getFileUploadPath(), fileInput, fileName, fileType, widthInt, heightInt);
            String objId = UUID.randomUUID().toString().toUpperCase();
            if (fileId == null || "".equals(fileId)) {
                fileId = objId;
            }
            Float fileSize = Float.valueOf(new BigDecimal(fileSizeLong / 1024L).setScale(2, 4).floatValue());
            EfsFileRecord efsFile = new EfsFileRecord();
            efsFile.setObjId(objId);
            efsFile.setFileName(fileName);
            efsFile.setFileId(fileId);
            efsFile.setFileType(fileType);
            efsFile.setFileSize(fileSize);
            efsFile.setWidth(widthInt);
            efsFile.setHeight(heightInt);
            efsFile.setFdfsPath(fdfsPath);
            Date date = new Date();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd :hh:mm:ss");
            efsFile.setCreateTime(simpleDateFormat.format(date));
            this.efsFileService.insertEfsFileRecord(efsFile);
            resultMap.put("msg", "\u4e0a\u4f20\u6210\u529f");
            resultMap.put("errcode", 200);
            resultMap.put("data", fileId);
        }
        catch (Exception e) {
            e.printStackTrace();
            success = false;
            resultMap.put("errcode", 500);
            resultMap.put("msg", e.getMessage());
        }
        resultMap.put("success", success);
        return resultMap;
    }

    @ApiOperation(value="\u539f\u6587\u4ef6\u4e0b\u8f7d", notes="\u539f\u6587\u4ef6\u4e0b\u8f7d")
    @GetMapping(value={"/{fileId}"})
    public void downloadFile(@PathVariable(value="fileId") String fileId, HttpServletRequest request, HttpServletResponse response) throws IOException {
        List<EfsFileRecord> efsFileList = this.efsFileService.getFileById(fileId);
        if (efsFileList != null && efsFileList.size() > 0) {
            EfsFileRecord efsFile = efsFileList.get(0);
            String fdfsPath = efsFile.getFdfsPath();
            String fileName = efsFile.getFileName();
            String fileType = efsFile.getFileType();
            Integer width = efsFile.getWidth();
            Integer height = efsFile.getHeight();
            FileUtil.downloadFileFromLocal(response, fdfsPath, fileName, fileType, false);
        } else {
            response.sendError(404);
        }
    }
}

