package org.plugins.savePhoto;

import static android.os.Environment.DIRECTORY_DCIM;

import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Environment;
import android.text.TextUtils;
import com.jxdinfo.mp.sdk.core.utils.ToastUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.PluginResult;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/** 保存图片插件 */
public class SavePhoto extends CordovaPlugin {
  /** 保存图片 */
  public static final String ACTION_SAVE = "downloadToPhotoLibrary";
  /** 当前动作暂存 */
  private String action = "";

  /** JS回调接口对象 */
  public static CallbackContext cbCtx = null;

  @Override
  public boolean execute(String action, JSONArray args, CallbackContext callbackContext)
      throws JSONException {
    cbCtx = callbackContext;
    this.action = action;
    AtomicBoolean ret = new AtomicBoolean(false);
    if (action.equals(ACTION_SAVE)) {
      JSONObject jsonObject = args.getJSONObject(0);
      String url = jsonObject.optString("url");
      if (TextUtils.isEmpty(url)) {
        ToastUtil.showShortToast(cordova.getActivity(), "配置错误");
      } else {
        String filePath =
            Environment.getExternalStoragePublicDirectory(DIRECTORY_DCIM).getAbsolutePath()
                + "/"
                + url.substring(url.indexOf("?") + 4)
                + ".png";
        JSONObject jsonObject1 = new JSONObject();
        cordova
            .getThreadPool()
            .execute(
                () -> {
                  try {
                    URL url1 = new URL(url);
                    URLConnection connection = url1.openConnection();
                    connection.connect();
                    InputStream inputStream = connection.getInputStream();
                    Bitmap bitmap = BitmapFactory.decodeStream(inputStream);
                    boolean flag = false;
                    File f = new File(filePath);
                    try {
                      if (f.exists()) {
                        f.delete();
                      } else {
                        f.createNewFile();
                      }
                      FileOutputStream out = new FileOutputStream(f);
                      bitmap.compress(Bitmap.CompressFormat.JPEG, 90, out);
                      out.flush();
                      out.close();
                      flag = true;

                    } catch (FileNotFoundException e) {
                      e.printStackTrace();
                    } catch (IOException e) {
                      e.printStackTrace();
                    }
                    jsonObject1.put("success", flag);
                    jsonObject1.put("msg", filePath);
                    cbCtx.success(jsonObject1);
                    try {
                      // 通知图库更新 下载的图片能马上显示在相册列表中（否则只能开关机后才能显示出下载的图片） 通知系统图库软件
                      cordova
                          .getActivity()
                          .sendBroadcast(
                              new Intent(
                                  Intent.ACTION_MEDIA_SCANNER_SCAN_FILE,
                                  Uri.parse("file://" + f.getAbsolutePath())));
                    } catch (Exception e) {
                      e.printStackTrace();
                    }
                    ret.set(true);
                  } catch (Exception e) {
                    e.printStackTrace();
                  }
                });
      }
    }
    return ret.get();
  }

  void error(String errorMsg) {
    PluginResult pluginResult = new PluginResult(PluginResult.Status.ERROR, errorMsg);
    pluginResult.setKeepCallback(true);
    cbCtx.sendPluginResult(pluginResult);
  }
}
