/*
 * Decompiled with CFR 0.152.
 */
package org.plugins.nfc;

import android.nfc.NdefMessage;
import android.nfc.NdefRecord;
import android.nfc.Tag;
import android.nfc.tech.Ndef;
import android.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Util {
    static final String TAG = "NfcPlugin";

    static JSONObject ndefToJSON(Ndef ndef) {
        JSONObject json = new JSONObject();
        if (ndef != null) {
            try {
                Tag tag = ndef.getTag();
                if (tag != null) {
                    json.put("id", (Object)Util.byteArrayToJSON(tag.getId()));
                    json.put("techTypes", (Object)new JSONArray(Arrays.asList(tag.getTechList())));
                }
                json.put("type", (Object)Util.translateType(ndef.getType()));
                json.put("maxSize", ndef.getMaxSize());
                json.put("isWritable", ndef.isWritable());
                json.put("ndefMessage", (Object)Util.messageToJSON(ndef.getCachedNdefMessage()));
                try {
                    json.put("canMakeReadOnly", ndef.canMakeReadOnly());
                }
                catch (NullPointerException e) {
                    json.put("canMakeReadOnly", JSONObject.NULL);
                }
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)("Failed to convert ndef into json: " + ndef.toString()), (Throwable)e);
            }
        }
        return json;
    }

    static JSONObject tagToJSON(Tag tag) {
        JSONObject json = new JSONObject();
        if (tag != null) {
            try {
                json.put("id", (Object)Util.byteArrayToJSON(tag.getId()));
                json.put("techTypes", (Object)new JSONArray(Arrays.asList(tag.getTechList())));
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)("Failed to convert tag into json: " + tag.toString()), (Throwable)e);
            }
        }
        return json;
    }

    static String translateType(String type) {
        String translation = type.equals("org.nfcforum.ndef.type1") ? "NFC Forum Type 1" : (type.equals("org.nfcforum.ndef.type2") ? "NFC Forum Type 2" : (type.equals("org.nfcforum.ndef.type3") ? "NFC Forum Type 3" : (type.equals("org.nfcforum.ndef.type4") ? "NFC Forum Type 4" : type)));
        return translation;
    }

    static NdefRecord[] jsonToNdefRecords(String ndefMessageAsJSON) throws JSONException {
        JSONArray jsonRecords = new JSONArray(ndefMessageAsJSON);
        NdefRecord[] records = new NdefRecord[jsonRecords.length()];
        for (int i = 0; i < jsonRecords.length(); ++i) {
            JSONObject record = jsonRecords.getJSONObject(i);
            byte tnf = (byte)record.getInt("tnf");
            byte[] type = Util.jsonToByteArray(record.getJSONArray("type"));
            byte[] id = Util.jsonToByteArray(record.getJSONArray("id"));
            byte[] payload = Util.jsonToByteArray(record.getJSONArray("payload"));
            records[i] = new NdefRecord((short)tnf, type, id, payload);
        }
        return records;
    }

    static JSONArray byteArrayToJSON(byte[] bytes) {
        JSONArray json = new JSONArray();
        for (byte aByte : bytes) {
            json.put((int)aByte);
        }
        return json;
    }

    static byte[] jsonToByteArray(JSONArray json) throws JSONException {
        byte[] b = new byte[json.length()];
        for (int i = 0; i < json.length(); ++i) {
            b[i] = (byte)json.getInt(i);
        }
        return b;
    }

    static JSONArray messageToJSON(NdefMessage message) {
        if (message == null) {
            return null;
        }
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        for (NdefRecord ndefRecord : message.getRecords()) {
            list.add(Util.recordToJSON(ndefRecord));
        }
        return new JSONArray(list);
    }

    static JSONObject recordToJSON(NdefRecord record) {
        JSONObject json = new JSONObject();
        try {
            json.put("tnf", (int)record.getTnf());
            json.put("type", (Object)Util.byteArrayToJSON(record.getType()));
            json.put("id", (Object)Util.byteArrayToJSON(record.getId()));
            json.put("payload", (Object)Util.byteArrayToJSON(record.getPayload()));
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)("Failed to convert ndef record into json: " + record.toString()), (Throwable)e);
        }
        return json;
    }
}

