/*
 * Decompiled with CFR 0.152.
 */
package org.plugins.nfc;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.nfc.FormatException;
import android.nfc.NdefMessage;
import android.nfc.NdefRecord;
import android.nfc.NfcAdapter;
import android.nfc.NfcEvent;
import android.nfc.Tag;
import android.nfc.TagLostException;
import android.nfc.tech.Ndef;
import android.nfc.tech.NdefFormatable;
import android.nfc.tech.TagTechnology;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaArgs;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.PluginResult;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.plugins.nfc.Util;

public class NfcPlugin
extends CordovaPlugin
implements NfcAdapter.OnNdefPushCompleteCallback {
    private static final String REGISTER_MIME_TYPE = "registerMimeType";
    private static final String REMOVE_MIME_TYPE = "removeMimeType";
    private static final String REGISTER_NDEF = "registerNdef";
    private static final String REMOVE_NDEF = "removeNdef";
    private static final String REGISTER_NDEF_FORMATABLE = "registerNdefFormatable";
    private static final String REGISTER_DEFAULT_TAG = "registerTag";
    private static final String REMOVE_DEFAULT_TAG = "removeTag";
    private static final String WRITE_TAG = "writeTag";
    private static final String MAKE_READ_ONLY = "makeReadOnly";
    private static final String ERASE_TAG = "eraseTag";
    private static final String SHARE_TAG = "shareTag";
    private static final String UNSHARE_TAG = "unshareTag";
    private static final String HANDOVER = "handover";
    private static final String STOP_HANDOVER = "stopHandover";
    private static final String ENABLED = "enabled";
    private static final String INIT = "init";
    private static final String SHOW_SETTINGS = "showSettings";
    private static final String NDEF = "ndef";
    private static final String NDEF_MIME = "ndef-mime";
    private static final String NDEF_FORMATABLE = "ndef-formatable";
    private static final String TAG_DEFAULT = "tag";
    private static final String READER_MODE = "readerMode";
    private static final String DISABLE_READER_MODE = "disableReaderMode";
    private static final String CONNECT = "connect";
    private static final String CLOSE = "close";
    private static final String TRANSCEIVE = "transceive";
    private static final String CHANNEL = "channel";
    private static final String STATUS_NFC_OK = "NFC_OK";
    private static final String STATUS_NO_NFC = "NO_NFC";
    private static final String STATUS_NFC_DISABLED = "NFC_DISABLED";
    private static final String STATUS_NDEF_PUSH_DISABLED = "NDEF_PUSH_DISABLED";
    private static final String TAG = "NfcPlugin";
    private final List<IntentFilter> intentFilters = new ArrayList<IntentFilter>();
    private final ArrayList<String[]> techLists = new ArrayList();
    private TagTechnology tagTechnology = null;
    private Class<?> tagTechnologyClass;
    private NdefMessage p2pMessage = null;
    private PendingIntent pendingIntent = null;
    private Intent savedIntent = null;
    private CallbackContext readerModeCallback;
    private CallbackContext channelCallback;
    private CallbackContext shareTagCallback;
    private CallbackContext handoverCallback;
    private final NfcAdapter.ReaderCallback callback = new NfcAdapter.ReaderCallback(){

        public void onTagDiscovered(Tag tag) {
            JSONObject json;
            List<String> techList = Arrays.asList(tag.getTechList());
            if (techList.contains(Ndef.class.getName())) {
                Ndef ndef = Ndef.get((Tag)tag);
                json = Util.ndefToJSON(ndef);
            } else {
                json = Util.tagToJSON(tag);
            }
            Intent tagIntent = new Intent();
            tagIntent.putExtra("android.nfc.extra.TAG", (Parcelable)tag);
            NfcPlugin.this.setIntent(tagIntent);
            PluginResult result = new PluginResult(PluginResult.Status.OK, json);
            result.setKeepCallback(true);
            if (NfcPlugin.this.readerModeCallback != null) {
                NfcPlugin.this.readerModeCallback.sendPluginResult(result);
            } else {
                Log.i((String)NfcPlugin.TAG, (String)"readerModeCallback is null - reader mode probably disabled in the meantime");
            }
        }
    };

    public boolean execute(String action, JSONArray data, CallbackContext callbackContext) throws JSONException {
        Log.d((String)TAG, (String)("execute " + action));
        if (action.equalsIgnoreCase(SHOW_SETTINGS)) {
            this.showSettings(callbackContext);
            return true;
        }
        if (action.equalsIgnoreCase(CHANNEL)) {
            this.channelCallback = callbackContext;
            return true;
        }
        if (action.equalsIgnoreCase(DISABLE_READER_MODE)) {
            this.disableReaderMode(callbackContext);
            return true;
        }
        if (!this.getNfcStatus().equals(STATUS_NFC_OK)) {
            callbackContext.error(this.getNfcStatus());
            return true;
        }
        this.createPendingIntent();
        if (action.equalsIgnoreCase(READER_MODE)) {
            int flags = data.getInt(0);
            this.readerMode(flags, callbackContext);
        } else if (action.equalsIgnoreCase(REGISTER_MIME_TYPE)) {
            this.registerMimeType(data, callbackContext);
        } else if (action.equalsIgnoreCase(REMOVE_MIME_TYPE)) {
            this.removeMimeType(data, callbackContext);
        } else if (action.equalsIgnoreCase(REGISTER_NDEF)) {
            this.registerNdef(callbackContext);
        } else if (action.equalsIgnoreCase(REMOVE_NDEF)) {
            this.removeNdef(callbackContext);
        } else if (action.equalsIgnoreCase(REGISTER_NDEF_FORMATABLE)) {
            this.registerNdefFormatable(callbackContext);
        } else if (action.equals(REGISTER_DEFAULT_TAG)) {
            this.registerDefaultTag(callbackContext);
        } else if (action.equals(REMOVE_DEFAULT_TAG)) {
            this.removeDefaultTag(callbackContext);
        } else if (action.equalsIgnoreCase(WRITE_TAG)) {
            this.writeTag(data, callbackContext);
        } else if (action.equalsIgnoreCase(MAKE_READ_ONLY)) {
            this.makeReadOnly(callbackContext);
        } else if (action.equalsIgnoreCase(ERASE_TAG)) {
            this.eraseTag(callbackContext);
        } else if (action.equalsIgnoreCase(SHARE_TAG)) {
            this.shareTag(data, callbackContext);
        } else if (action.equalsIgnoreCase(UNSHARE_TAG)) {
            this.unshareTag(callbackContext);
        } else if (action.equalsIgnoreCase(HANDOVER)) {
            this.handover(data, callbackContext);
        } else if (action.equalsIgnoreCase(STOP_HANDOVER)) {
            this.stopHandover(callbackContext);
        } else if (action.equalsIgnoreCase(INIT)) {
            this.init(callbackContext);
        } else if (action.equalsIgnoreCase(ENABLED)) {
            callbackContext.success(STATUS_NFC_OK);
        } else if (action.equalsIgnoreCase(CONNECT)) {
            String tech = data.getString(0);
            int timeout = data.optInt(1, -1);
            this.connect(tech, timeout, callbackContext);
        } else if (action.equalsIgnoreCase(TRANSCEIVE)) {
            CordovaArgs args = new CordovaArgs(data);
            byte[] command = args.getArrayBuffer(0);
            this.transceive(command, callbackContext);
        } else if (action.equalsIgnoreCase(CLOSE)) {
            this.close(callbackContext);
        } else {
            return false;
        }
        return true;
    }

    private String getNfcStatus() {
        NfcAdapter nfcAdapter = NfcAdapter.getDefaultAdapter((Context)this.getActivity());
        if (nfcAdapter == null) {
            return STATUS_NO_NFC;
        }
        if (!nfcAdapter.isEnabled()) {
            return STATUS_NFC_DISABLED;
        }
        return STATUS_NFC_OK;
    }

    private void readerMode(int flags, CallbackContext callbackContext) {
        Bundle extras = new Bundle();
        this.readerModeCallback = callbackContext;
        this.getActivity().runOnUiThread(() -> {
            NfcAdapter nfcAdapter = NfcAdapter.getDefaultAdapter((Context)this.getActivity());
            nfcAdapter.enableReaderMode(this.getActivity(), this.callback, flags, extras);
        });
    }

    private void disableReaderMode(CallbackContext callbackContext) {
        this.getActivity().runOnUiThread(() -> {
            this.readerModeCallback = null;
            NfcAdapter nfcAdapter = NfcAdapter.getDefaultAdapter((Context)this.getActivity());
            if (nfcAdapter != null) {
                nfcAdapter.disableReaderMode(this.getActivity());
            }
            callbackContext.success();
        });
    }

    private void registerDefaultTag(CallbackContext callbackContext) {
        this.addTagFilter();
        this.restartNfc();
        callbackContext.success();
    }

    private void removeDefaultTag(CallbackContext callbackContext) {
        this.removeTagFilter();
        this.restartNfc();
        callbackContext.success();
    }

    private void registerNdefFormatable(CallbackContext callbackContext) {
        this.addTechList(new String[]{NdefFormatable.class.getName()});
        this.restartNfc();
        callbackContext.success();
    }

    private void registerNdef(CallbackContext callbackContext) {
        this.addTechList(new String[]{Ndef.class.getName()});
        this.restartNfc();
        callbackContext.success();
    }

    private void removeNdef(CallbackContext callbackContext) {
        this.removeTechList(new String[]{Ndef.class.getName()});
        this.restartNfc();
        callbackContext.success();
    }

    private void unshareTag(CallbackContext callbackContext) {
        this.p2pMessage = null;
        this.stopNdefPush();
        this.shareTagCallback = null;
        callbackContext.success();
    }

    private void init(CallbackContext callbackContext) {
        Log.d((String)TAG, (String)("Enabling plugin " + this.getIntent()));
        this.startNfc();
        if (!this.recycledIntent()) {
            this.parseMessage();
        }
        callbackContext.success();
    }

    private void removeMimeType(JSONArray data, CallbackContext callbackContext) throws JSONException {
        String mimeType = data.getString(0);
        this.removeIntentFilter(mimeType);
        this.restartNfc();
        callbackContext.success();
    }

    private void registerMimeType(JSONArray data, CallbackContext callbackContext) throws JSONException {
        String mimeType = "";
        try {
            mimeType = data.getString(0);
            this.intentFilters.add(this.createIntentFilter(mimeType));
            this.restartNfc();
            callbackContext.success();
        }
        catch (IntentFilter.MalformedMimeTypeException e) {
            callbackContext.error("Invalid MIME Type " + mimeType);
        }
    }

    private void eraseTag(CallbackContext callbackContext) {
        Tag tag = (Tag)this.savedIntent.getParcelableExtra("android.nfc.extra.TAG");
        NdefRecord[] records = new NdefRecord[]{new NdefRecord(0, new byte[0], new byte[0], new byte[0])};
        this.writeNdefMessage(new NdefMessage(records), tag, callbackContext);
    }

    private void writeTag(JSONArray data, CallbackContext callbackContext) throws JSONException {
        if (this.getIntent() == null) {
            callbackContext.error("Failed to write tag, received null intent");
        }
        Tag tag = (Tag)this.savedIntent.getParcelableExtra("android.nfc.extra.TAG");
        NdefRecord[] records = Util.jsonToNdefRecords(data.getString(0));
        this.writeNdefMessage(new NdefMessage(records), tag, callbackContext);
    }

    private void writeNdefMessage(NdefMessage message, Tag tag, CallbackContext callbackContext) {
        this.cordova.getThreadPool().execute(() -> {
            try {
                Ndef ndef = Ndef.get((Tag)tag);
                if (ndef != null) {
                    ndef.connect();
                    if (ndef.isWritable()) {
                        int size = message.toByteArray().length;
                        if (ndef.getMaxSize() < size) {
                            callbackContext.error("Tag capacity is " + ndef.getMaxSize() + " bytes, message is " + size + " bytes.");
                        } else {
                            ndef.writeNdefMessage(message);
                            callbackContext.success();
                        }
                    } else {
                        callbackContext.error("Tag is read only");
                    }
                    ndef.close();
                } else {
                    NdefFormatable formatable = NdefFormatable.get((Tag)tag);
                    if (formatable != null) {
                        formatable.connect();
                        formatable.format(message);
                        callbackContext.success();
                        formatable.close();
                    } else {
                        callbackContext.error("Tag doesn't support NDEF");
                    }
                }
            }
            catch (FormatException e) {
                callbackContext.error(e.getMessage());
            }
            catch (TagLostException e) {
                callbackContext.error(e.getMessage());
            }
            catch (IOException e) {
                callbackContext.error(e.getMessage());
            }
        });
    }

    private void makeReadOnly(CallbackContext callbackContext) {
        if (this.getIntent() == null) {
            callbackContext.error("Failed to make tag read only, received null intent");
            return;
        }
        Tag tag = (Tag)this.savedIntent.getParcelableExtra("android.nfc.extra.TAG");
        if (tag == null) {
            callbackContext.error("Failed to make tag read only, tag is null");
            return;
        }
        this.cordova.getThreadPool().execute(() -> {
            boolean success = false;
            String message = "Could not make tag read only";
            Ndef ndef = Ndef.get((Tag)tag);
            try {
                if (ndef != null) {
                    ndef.connect();
                    if (!ndef.isWritable()) {
                        message = "Tag is not writable";
                    } else if (ndef.canMakeReadOnly()) {
                        success = ndef.makeReadOnly();
                    } else {
                        message = "Tag can not be made read only";
                    }
                } else {
                    message = "Tag is not NDEF";
                }
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Failed to make tag read only", (Throwable)e);
                message = e.getMessage() != null ? e.getMessage() : e.toString();
            }
            if (success) {
                callbackContext.success();
            } else {
                callbackContext.error(message);
            }
        });
    }

    private void shareTag(JSONArray data, CallbackContext callbackContext) throws JSONException {
        NdefRecord[] records = Util.jsonToNdefRecords(data.getString(0));
        this.p2pMessage = new NdefMessage(records);
        this.startNdefPush(callbackContext);
    }

    private void handover(JSONArray data, CallbackContext callbackContext) throws JSONException {
        Uri[] uri = new Uri[data.length()];
        for (int i = 0; i < data.length(); ++i) {
            uri[i] = Uri.parse((String)data.getString(i));
        }
        this.startNdefBeam(callbackContext, uri);
    }

    private void stopHandover(CallbackContext callbackContext) {
        this.stopNdefBeam();
        this.handoverCallback = null;
        callbackContext.success();
    }

    private void showSettings(CallbackContext callbackContext) {
        if (Build.VERSION.SDK_INT >= 16) {
            Intent intent = new Intent("android.settings.NFC_SETTINGS");
            this.getActivity().startActivity(intent);
        } else {
            Intent intent = new Intent("android.settings.WIRELESS_SETTINGS");
            this.getActivity().startActivity(intent);
        }
        callbackContext.success();
    }

    private void createPendingIntent() {
        if (this.pendingIntent == null) {
            Activity activity = this.getActivity();
            Intent intent = new Intent((Context)activity, activity.getClass());
            intent.addFlags(0x24000000);
            this.pendingIntent = PendingIntent.getActivity((Context)activity, (int)0, (Intent)intent, (int)0);
        }
    }

    private void addTechList(String[] list) {
        this.addTechFilter();
        this.addToTechList(list);
    }

    private void removeTechList(String[] list) {
        this.removeTechFilter();
        this.removeFromTechList(list);
    }

    private void addTechFilter() {
        this.intentFilters.add(new IntentFilter("android.nfc.action.TECH_DISCOVERED"));
    }

    private void removeTechFilter() {
        Iterator<IntentFilter> iterator = this.intentFilters.iterator();
        while (iterator.hasNext()) {
            IntentFilter intentFilter = iterator.next();
            if (!"android.nfc.action.TECH_DISCOVERED".equals(intentFilter.getAction(0))) continue;
            iterator.remove();
        }
    }

    private void addTagFilter() {
        this.intentFilters.add(new IntentFilter("android.nfc.action.TAG_DISCOVERED"));
    }

    private void removeTagFilter() {
        Iterator<IntentFilter> iterator = this.intentFilters.iterator();
        while (iterator.hasNext()) {
            IntentFilter intentFilter = iterator.next();
            if (!"android.nfc.action.TAG_DISCOVERED".equals(intentFilter.getAction(0))) continue;
            iterator.remove();
        }
    }

    private void restartNfc() {
        this.stopNfc();
        this.startNfc();
    }

    private void startNfc() {
        this.createPendingIntent();
        this.getActivity().runOnUiThread(() -> {
            NfcAdapter nfcAdapter = NfcAdapter.getDefaultAdapter((Context)this.getActivity());
            if (nfcAdapter != null && !this.getActivity().isFinishing()) {
                try {
                    IntentFilter[] intentFilters = this.getIntentFilters();
                    String[][] techLists = this.getTechLists();
                    if (intentFilters.length > 0 || techLists.length > 0) {
                        nfcAdapter.enableForegroundDispatch(this.getActivity(), this.getPendingIntent(), intentFilters, techLists);
                    }
                    if (this.p2pMessage != null) {
                        nfcAdapter.setNdefPushMessage(this.p2pMessage, this.getActivity(), new Activity[0]);
                    }
                }
                catch (IllegalStateException e) {
                    Log.w((String)TAG, (String)"Illegal State Exception starting NFC. Assuming application is terminating.");
                }
            }
        });
    }

    private void stopNfc() {
        Log.d((String)TAG, (String)"stopNfc");
        this.getActivity().runOnUiThread(() -> {
            NfcAdapter nfcAdapter = NfcAdapter.getDefaultAdapter((Context)this.getActivity());
            if (nfcAdapter != null) {
                try {
                    nfcAdapter.disableForegroundDispatch(this.getActivity());
                }
                catch (IllegalStateException e) {
                    Log.w((String)TAG, (String)"Illegal State Exception stopping NFC. Assuming application is terminating.");
                }
            }
        });
    }

    private void startNdefBeam(CallbackContext callbackContext, Uri[] uris) {
        this.getActivity().runOnUiThread(() -> {
            NfcAdapter nfcAdapter = NfcAdapter.getDefaultAdapter((Context)this.getActivity());
            if (nfcAdapter == null) {
                callbackContext.error(STATUS_NO_NFC);
            } else if (!nfcAdapter.isNdefPushEnabled()) {
                callbackContext.error(STATUS_NDEF_PUSH_DISABLED);
            } else {
                nfcAdapter.setOnNdefPushCompleteCallback((NfcAdapter.OnNdefPushCompleteCallback)this, this.getActivity(), new Activity[0]);
                try {
                    nfcAdapter.setBeamPushUris(uris, this.getActivity());
                    PluginResult result = new PluginResult(PluginResult.Status.NO_RESULT);
                    result.setKeepCallback(true);
                    this.handoverCallback = callbackContext;
                    callbackContext.sendPluginResult(result);
                }
                catch (IllegalArgumentException e) {
                    callbackContext.error(e.getMessage());
                }
            }
        });
    }

    private void startNdefPush(CallbackContext callbackContext) {
        this.getActivity().runOnUiThread(() -> {
            NfcAdapter nfcAdapter = NfcAdapter.getDefaultAdapter((Context)this.getActivity());
            if (nfcAdapter == null) {
                callbackContext.error(STATUS_NO_NFC);
            } else if (!nfcAdapter.isNdefPushEnabled()) {
                callbackContext.error(STATUS_NDEF_PUSH_DISABLED);
            } else {
                nfcAdapter.setNdefPushMessage(this.p2pMessage, this.getActivity(), new Activity[0]);
                nfcAdapter.setOnNdefPushCompleteCallback((NfcAdapter.OnNdefPushCompleteCallback)this, this.getActivity(), new Activity[0]);
                PluginResult result = new PluginResult(PluginResult.Status.NO_RESULT);
                result.setKeepCallback(true);
                this.shareTagCallback = callbackContext;
                callbackContext.sendPluginResult(result);
            }
        });
    }

    private void stopNdefPush() {
        this.getActivity().runOnUiThread(() -> {
            NfcAdapter nfcAdapter = NfcAdapter.getDefaultAdapter((Context)this.getActivity());
            if (nfcAdapter != null) {
                nfcAdapter.setNdefPushMessage(null, this.getActivity(), new Activity[0]);
            }
        });
    }

    private void stopNdefBeam() {
        this.getActivity().runOnUiThread(() -> {
            NfcAdapter nfcAdapter = NfcAdapter.getDefaultAdapter((Context)this.getActivity());
            if (nfcAdapter != null) {
                nfcAdapter.setBeamPushUris(null, this.getActivity());
            }
        });
    }

    private void addToTechList(String[] techs) {
        this.techLists.add(techs);
    }

    private void removeFromTechList(String[] techs) {
        Iterator<String[]> iterator = this.techLists.iterator();
        while (iterator.hasNext()) {
            Object[] list = iterator.next();
            if (!Arrays.equals(list, techs)) continue;
            iterator.remove();
        }
    }

    private void removeIntentFilter(String mimeType) {
        Iterator<IntentFilter> iterator = this.intentFilters.iterator();
        while (iterator.hasNext()) {
            IntentFilter intentFilter = iterator.next();
            String mt = intentFilter.getDataType(0);
            if (!mimeType.equals(mt)) continue;
            iterator.remove();
        }
    }

    private IntentFilter createIntentFilter(String mimeType) throws IntentFilter.MalformedMimeTypeException {
        IntentFilter intentFilter = new IntentFilter("android.nfc.action.NDEF_DISCOVERED");
        intentFilter.addDataType(mimeType);
        return intentFilter;
    }

    private PendingIntent getPendingIntent() {
        return this.pendingIntent;
    }

    private IntentFilter[] getIntentFilters() {
        return this.intentFilters.toArray(new IntentFilter[this.intentFilters.size()]);
    }

    private String[][] getTechLists() {
        return (String[][])this.techLists.toArray((T[])new String[0][0]);
    }

    private void parseMessage() {
        this.cordova.getThreadPool().execute(() -> {
            Log.d((String)TAG, (String)("parseMessage " + this.getIntent()));
            Intent intent = this.getIntent();
            String action = intent.getAction();
            Log.d((String)TAG, (String)("action " + action));
            if (action == null) {
                return;
            }
            Tag tag = (Tag)intent.getParcelableExtra("android.nfc.extra.TAG");
            Parcelable[] messages = intent.getParcelableArrayExtra("android.nfc.extra.NDEF_MESSAGES");
            if (action.equals("android.nfc.action.NDEF_DISCOVERED")) {
                Ndef ndef = Ndef.get((Tag)tag);
                this.fireNdefEvent(NDEF_MIME, ndef, messages);
            } else if (action.equals("android.nfc.action.TECH_DISCOVERED")) {
                for (String tagTech : tag.getTechList()) {
                    Log.d((String)TAG, (String)tagTech);
                    if (tagTech.equals(NdefFormatable.class.getName())) {
                        this.fireNdefFormatableEvent(tag);
                        continue;
                    }
                    if (!tagTech.equals(Ndef.class.getName())) continue;
                    Ndef ndef = Ndef.get((Tag)tag);
                    this.fireNdefEvent(NDEF, ndef, messages);
                }
            }
            if (action.equals("android.nfc.action.TAG_DISCOVERED")) {
                this.fireTagEvent(tag);
            }
            this.setIntent(new Intent());
        });
    }

    private void sendEvent(String type, JSONObject tag) {
        try {
            JSONObject event = new JSONObject();
            event.put("type", (Object)type);
            event.put(TAG_DEFAULT, (Object)tag);
            PluginResult result = new PluginResult(PluginResult.Status.OK, event);
            result.setKeepCallback(true);
            this.channelCallback.sendPluginResult(result);
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)"Error sending NFC event through the channel", (Throwable)e);
        }
    }

    private void fireNdefEvent(String type, Ndef ndef, Parcelable[] messages) {
        JSONObject json = this.buildNdefJSON(ndef, messages);
        this.sendEvent(type, json);
    }

    private void fireNdefFormatableEvent(Tag tag) {
        this.sendEvent(NDEF_FORMATABLE, Util.tagToJSON(tag));
    }

    private void fireTagEvent(Tag tag) {
        this.sendEvent(TAG_DEFAULT, Util.tagToJSON(tag));
    }

    private JSONObject buildNdefJSON(Ndef ndef, Parcelable[] messages) {
        JSONObject json = Util.ndefToJSON(ndef);
        if (ndef == null && messages != null) {
            try {
                if (messages.length > 0) {
                    NdefMessage message = (NdefMessage)messages[0];
                    json.put("ndefMessage", (Object)Util.messageToJSON(message));
                    json.put("type", (Object)"NDEF Push Protocol");
                }
                if (messages.length > 1) {
                    Log.wtf((String)TAG, (String)("Expected one ndefMessage but found " + messages.length));
                }
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)"Failed to convert ndefMessage into json", (Throwable)e);
            }
        }
        return json;
    }

    private boolean recycledIntent() {
        int flags = this.getIntent().getFlags();
        if ((flags & 0x100000) == 0x100000) {
            Log.i((String)TAG, (String)"Launched from history, killing recycled intent");
            this.setIntent(new Intent());
            return true;
        }
        return false;
    }

    public void onPause(boolean multitasking) {
        Log.d((String)TAG, (String)("onPause " + this.getIntent()));
        super.onPause(multitasking);
        if (multitasking) {
            this.stopNfc();
        }
    }

    public void onResume(boolean multitasking) {
        Log.d((String)TAG, (String)("onResume " + this.getIntent()));
        super.onResume(multitasking);
        this.startNfc();
    }

    public void onNewIntent(Intent intent) {
        Log.d((String)TAG, (String)("onNewIntent " + intent));
        super.onNewIntent(intent);
        this.setIntent(intent);
        this.savedIntent = intent;
        this.parseMessage();
    }

    private Activity getActivity() {
        return this.cordova.getActivity();
    }

    private Intent getIntent() {
        return this.getActivity().getIntent();
    }

    private void setIntent(Intent intent) {
        this.getActivity().setIntent(intent);
    }

    public void onNdefPushComplete(NfcEvent event) {
        if (this.handoverCallback != null) {
            PluginResult result = new PluginResult(PluginResult.Status.OK, "Beamed Message to Peer");
            result.setKeepCallback(true);
            this.handoverCallback.sendPluginResult(result);
        } else if (this.shareTagCallback != null) {
            PluginResult result = new PluginResult(PluginResult.Status.OK, "Shared Message with Peer");
            result.setKeepCallback(true);
            this.shareTagCallback.sendPluginResult(result);
        }
    }

    private void connect(String tech, int timeout, CallbackContext callbackContext) {
        this.cordova.getThreadPool().execute(() -> {
            try {
                Tag tag = (Tag)this.getIntent().getParcelableExtra("android.nfc.extra.TAG");
                if (tag == null && this.savedIntent != null) {
                    tag = (Tag)this.savedIntent.getParcelableExtra("android.nfc.extra.TAG");
                }
                if (tag == null) {
                    Log.e((String)TAG, (String)"No Tag");
                    callbackContext.error("No Tag");
                    return;
                }
                JSONObject resultObject = new JSONObject();
                List<String> techList = Arrays.asList(tag.getTechList());
                if (techList.contains(tech)) {
                    this.tagTechnologyClass = Class.forName(tech);
                    Method method = this.tagTechnologyClass.getMethod("get", Tag.class);
                    this.tagTechnology = (TagTechnology)method.invoke(null, tag);
                    try {
                        Method maxTransceiveLengthMethod = this.tagTechnologyClass.getMethod("getMaxTransceiveLength", new Class[0]);
                        resultObject.put("maxTransceiveLength", maxTransceiveLengthMethod.invoke((Object)this.tagTechnology, new Object[0]));
                    }
                    catch (NoSuchMethodException maxTransceiveLengthMethod) {
                    }
                    catch (JSONException e) {
                        Log.e((String)TAG, (String)"Error serializing JSON", (Throwable)e);
                    }
                }
                if (this.tagTechnology == null) {
                    callbackContext.error("Tag does not support " + tech);
                    return;
                }
                this.tagTechnology.connect();
                this.setTimeout(timeout);
                callbackContext.success(resultObject);
            }
            catch (IOException ex) {
                Log.e((String)TAG, (String)"Tag connection failed", (Throwable)ex);
                callbackContext.error("Tag connection failed");
            }
            catch (ClassNotFoundException e) {
                Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
                callbackContext.error(e.getMessage());
            }
            catch (NoSuchMethodException e) {
                Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
                callbackContext.error(e.getMessage());
            }
            catch (IllegalAccessException e) {
                Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
                callbackContext.error(e.getMessage());
            }
            catch (InvocationTargetException e) {
                Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
                callbackContext.error(e.getMessage());
            }
        });
    }

    private void setTimeout(int timeout) {
        if (timeout < 0) {
            return;
        }
        try {
            Method setTimeout = this.tagTechnologyClass.getMethod("setTimeout", Integer.TYPE);
            setTimeout.invoke((Object)this.tagTechnology, timeout);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    private void close(CallbackContext callbackContext) {
        this.cordova.getThreadPool().execute(() -> {
            try {
                if (this.tagTechnology != null && this.tagTechnology.isConnected()) {
                    this.tagTechnology.close();
                    this.tagTechnology = null;
                    callbackContext.success();
                } else {
                    callbackContext.success();
                }
            }
            catch (IOException ex) {
                Log.e((String)TAG, (String)"Error closing nfc connection", (Throwable)ex);
                callbackContext.error("Error closing nfc connection " + ex.getLocalizedMessage());
            }
        });
    }

    private void transceive(byte[] data, CallbackContext callbackContext) {
        this.cordova.getThreadPool().execute(() -> {
            try {
                if (this.tagTechnology == null) {
                    Log.e((String)TAG, (String)"No Tech");
                    callbackContext.error("No Tech");
                    return;
                }
                if (!this.tagTechnology.isConnected()) {
                    Log.e((String)TAG, (String)"Not connected");
                    callbackContext.error("Not connected");
                    return;
                }
                Method transceiveMethod = this.tagTechnologyClass.getMethod(TRANSCEIVE, byte[].class);
                byte[] response = (byte[])transceiveMethod.invoke((Object)this.tagTechnology, new Object[]{data});
                callbackContext.success(response);
            }
            catch (NoSuchMethodException e) {
                String error = "TagTechnology " + this.tagTechnologyClass.getName() + " does not have a transceive function";
                Log.e((String)TAG, (String)error, (Throwable)e);
                callbackContext.error(error);
            }
            catch (NullPointerException e) {
                Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
                callbackContext.error(e.getMessage());
            }
            catch (IllegalAccessException e) {
                Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
                callbackContext.error(e.getMessage());
            }
            catch (InvocationTargetException e) {
                Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
                Throwable cause = e.getCause();
                callbackContext.error(cause.getMessage());
            }
        });
    }
}

