/*
 * Decompiled with CFR 0.152.
 */
package org.plugins.map;

import android.text.TextUtils;
import com.baidu.mapapi.model.LatLng;
import com.baidu.mapapi.utils.CoordinateConverter;
import java.io.Serializable;

public class NavigationParamBean
implements Serializable {
    public static final String MAPTYPE_BAIDU = "Baidu";
    public static final String MAPTYPE_AMAP = "AMap";
    public static final String MAPTYPE_QQ = "QQ";
    public static final String COORDTYPE_BD09LL = "BD09ll";
    public static final String COORDTYPE_BD09 = "BD09";
    public static final String COORDTYPE_GCJ02 = "GCJ02";
    public static final String COORDTYPE_WGS84 = "WGS84";
    private String mapType = "";
    private String coordType = "GCJ02";
    private String latitude = "";
    private String longitude = "";
    private String locationDescribe = "\u76ee\u7684\u5730";

    public String getMapType() {
        return this.mapType;
    }

    public void setMapType(String mapType) {
        this.mapType = mapType;
    }

    public String getCoordType() {
        return this.coordType;
    }

    public void setCoordType(String coordType) {
        this.coordType = coordType;
    }

    public String getLatitude() {
        return this.latitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public String getLongitude() {
        return this.longitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public String getLocationDescribe() {
        return this.locationDescribe;
    }

    public void setLocationDescribe(String locationDescribe) {
        this.locationDescribe = locationDescribe;
    }

    LatLng parseToBaidu() {
        LatLng sourceLatLng = new LatLng(Double.parseDouble(this.getLatitude()), Double.parseDouble(this.getLongitude()));
        LatLng desLatLng = null;
        switch (this.getCoordType()) {
            case "BD09ll": {
                desLatLng = sourceLatLng;
                break;
            }
            case "BD09": {
                CoordinateConverter converter = new CoordinateConverter().from(CoordinateConverter.CoordType.BD09MC).coord(sourceLatLng);
                desLatLng = converter.convert();
                break;
            }
            case "GCJ02": {
                CoordinateConverter converter1 = new CoordinateConverter().from(CoordinateConverter.CoordType.COMMON).coord(sourceLatLng);
                desLatLng = converter1.convert();
                break;
            }
            case "WGS84": {
                CoordinateConverter converter2 = new CoordinateConverter().from(CoordinateConverter.CoordType.GPS).coord(sourceLatLng);
                desLatLng = converter2.convert();
            }
        }
        return desLatLng;
    }

    LatLng parseToCOORDTYPE_GCJ02() {
        LatLng sourceLatLng = new LatLng(Double.parseDouble(this.getLatitude()), Double.parseDouble(this.getLongitude()));
        LatLng desLatLng = null;
        switch (this.getCoordType()) {
            case "GCJ02": {
                desLatLng = sourceLatLng;
                break;
            }
            default: {
                sourceLatLng = this.parseToBaidu();
                CoordinateConverter converter = new CoordinateConverter().from(CoordinateConverter.CoordType.BD09LL).coord(sourceLatLng);
                desLatLng = converter.convert();
            }
        }
        return desLatLng;
    }

    public String checkInfoFullfilled() {
        if (TextUtils.isEmpty((CharSequence)this.latitude)) {
            return "\u7eac\u5ea6\u4fe1\u606f\u7f3a\u5931";
        }
        if (TextUtils.isEmpty((CharSequence)this.longitude)) {
            return "\u7ecf\u5ea6\u4fe1\u606f\u7f3a\u5931";
        }
        return "true";
    }
}

