/*
 * Decompiled with CFR 0.152.
 */
package org.plugins.map;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import com.baidu.mapapi.model.LatLng;
import com.baidu.mapapi.utils.CoordinateConverter;
import com.jxdinfo.mp.sdk.core.utils.AppUtil;

public class MapUtil {
    public static final String PN_GAODE_MAP = "com.autonavi.minimap";
    public static final String PN_BAIDU_MAP = "com.baidu.BaiduMap";
    public static final String PN_TENCENT_MAP = "com.tencent.map";
    public static final String COORDTYPE_BD09LL = "BD09ll";
    public static final String COORDTYPE_BD09 = "BD09";
    public static final String COORDTYPE_GCJ02 = "GCJ02";
    public static final String COORDTYPE_WGS84 = "WGS84";

    public static boolean isGdMapInstalled(Context context) {
        return MapUtil.isInstallPackage(context, PN_GAODE_MAP);
    }

    public static boolean isBaiduMapInstalled(Context context) {
        return MapUtil.isInstallPackage(context, PN_BAIDU_MAP);
    }

    public static boolean isTencentMapInstalled(Context context) {
        return MapUtil.isInstallPackage(context, PN_TENCENT_MAP);
    }

    private static boolean isInstallPackage(Context context, String packageName) {
        return AppUtil.isAppInstalled((Context)context, (String)packageName);
    }

    public static double[] bdToGaoDe(double bd_lat, double bd_lon) {
        double[] gd_lat_lon = new double[2];
        double PI = 52.35987755982988;
        double x = bd_lon - 0.0065;
        double y = bd_lat - 0.006;
        double z = Math.sqrt(x * x + y * y) - 2.0E-5 * Math.sin(y * PI);
        double theta = Math.atan2(y, x) - 3.0E-6 * Math.cos(x * PI);
        gd_lat_lon[0] = z * Math.cos(theta);
        gd_lat_lon[1] = z * Math.sin(theta);
        return gd_lat_lon;
    }

    private static double[] gaoDeToBaidu(double gd_lon, double gd_lat) {
        double[] bd_lat_lon = new double[2];
        double PI = 52.35987755982988;
        double x = gd_lon;
        double y = gd_lat;
        double z = Math.sqrt(x * x + y * y) + 2.0E-5 * Math.sin(y * PI);
        double theta = Math.atan2(y, x) + 3.0E-6 * Math.cos(x * PI);
        bd_lat_lon[0] = z * Math.cos(theta) + 0.0065;
        bd_lat_lon[1] = z * Math.sin(theta) + 0.006;
        return bd_lat_lon;
    }

    public static LatLng BD09ToGCJ02(LatLng latLng) {
        double x_pi = 52.35987755982988;
        double x = latLng.longitude - 0.0065;
        double y = latLng.latitude - 0.006;
        double z = Math.sqrt(x * x + y * y) - 2.0E-5 * Math.sin(y * x_pi);
        double theta = Math.atan2(y, x) - 3.0E-6 * Math.cos(x * x_pi);
        double gg_lat = z * Math.sin(theta);
        double gg_lng = z * Math.cos(theta);
        return new LatLng(gg_lat, gg_lng);
    }

    public static LatLng GCJ02ToBD09(LatLng latLng) {
        double x_pi = 52.35987755982988;
        double z = Math.sqrt(latLng.longitude * latLng.longitude + latLng.latitude * latLng.latitude) + 2.0E-5 * Math.sin(latLng.latitude * x_pi);
        double theta = Math.atan2(latLng.latitude, latLng.longitude) + 3.0E-6 * Math.cos(latLng.longitude * x_pi);
        double bd_lat = z * Math.sin(theta) + 0.006;
        double bd_lng = z * Math.cos(theta) + 0.0065;
        return new LatLng(bd_lat, bd_lng);
    }

    public static void openGaoDeNavi(Context context, double slat, double slon, String sname, double dlat, double dlon, String dname) {
        String uriString = null;
        StringBuilder builder = new StringBuilder("amapuri://route/plan?sourceApplication=maxuslife");
        if (slat != 0.0) {
            builder.append("&sname=").append(sname).append("&slat=").append(slat).append("&slon=").append(slon);
        }
        LatLng latLng = new LatLng(dlat, dlon);
        latLng = MapUtil.BD09ToGCJ02(latLng);
        builder.append("&dlat=").append(latLng.latitude).append("&dlon=").append(latLng.longitude).append("&dname=").append(dname).append("&dev=0").append("&t=0");
        uriString = builder.toString();
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setPackage(PN_GAODE_MAP);
        intent.setData(Uri.parse((String)uriString));
        context.startActivity(intent);
    }

    public static void openTencentMap(Context context, double slat, double slon, String sname, double dlat, double dlon, String dname) {
        String uriString = null;
        StringBuilder builder = new StringBuilder("qqmap://map/routeplan?type=drive&policy=0&referer=zhongshuo");
        if (slat != 0.0) {
            builder.append("&from=").append(sname).append("&fromcoord=").append(slat).append(",").append(slon);
        }
        LatLng latLng = new LatLng(dlat, dlon);
        latLng = MapUtil.BD09ToGCJ02(latLng);
        builder.append("&to=").append(dname).append("&tocoord=").append(latLng.latitude).append(",").append(latLng.longitude);
        uriString = builder.toString();
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setPackage(PN_TENCENT_MAP);
        intent.setData(Uri.parse((String)uriString));
        context.startActivity(intent);
    }

    public static void openBaiDuNavi(Context context, double slat, double slon, String sname, double dlat, double dlon, String dname) {
        String uriString = null;
        StringBuilder builder = new StringBuilder("baidumap://map/direction?mode=driving&");
        if (slat != 0.0) {
            double[] origin = MapUtil.gaoDeToBaidu(slat, slon);
            slat = origin[0];
            slon = origin[1];
            builder.append("origin=latlng:").append(slat).append(",").append(slon).append("|name:").append(sname);
        }
        builder.append("&destination=latlng:").append(dlat).append(",").append(dlon).append("|name:").append(dname);
        uriString = builder.toString();
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setPackage(PN_BAIDU_MAP);
        intent.setData(Uri.parse((String)uriString));
        context.startActivity(intent);
    }

    public static LatLng parseToBaidu(double latitude, Double longitude, String coorType) {
        LatLng sourceLatLng = new LatLng(latitude, longitude.doubleValue());
        LatLng desLatLng = null;
        switch (coorType) {
            case "BD09ll": {
                desLatLng = sourceLatLng;
                break;
            }
            case "BD09": {
                CoordinateConverter converter = new CoordinateConverter().from(CoordinateConverter.CoordType.BD09MC).coord(sourceLatLng);
                desLatLng = converter.convert();
                break;
            }
            case "GCJ02": {
                CoordinateConverter converter1 = new CoordinateConverter().from(CoordinateConverter.CoordType.COMMON).coord(sourceLatLng);
                desLatLng = converter1.convert();
                break;
            }
            case "WGS84": {
                CoordinateConverter converter2 = new CoordinateConverter().from(CoordinateConverter.CoordType.GPS).coord(sourceLatLng);
                desLatLng = converter2.convert();
            }
        }
        return desLatLng;
    }

    public static LatLng parseToCOORDTYPE_GCJ02(double latitude, Double longitude, String coorType) {
        LatLng sourceLatLng = new LatLng(latitude, longitude.doubleValue());
        LatLng desLatLng = null;
        switch (coorType) {
            case "GCJ02": {
                desLatLng = sourceLatLng;
                break;
            }
            default: {
                sourceLatLng = MapUtil.parseToBaidu(latitude, longitude, coorType);
                CoordinateConverter converter = new CoordinateConverter().from(CoordinateConverter.CoordType.BD09LL).coord(sourceLatLng);
                desLatLng = converter.convert();
            }
        }
        return desLatLng;
    }
}

