/*
 * Decompiled with CFR 0.152.
 */
package org.plugins.map;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.PopupWindow;
import com.baidu.mapapi.model.LatLng;
import com.google.gson.Gson;
import com.jxdinfo.mp.sdk.core.utils.IntentUtil;
import com.jxdinfo.plugin_map.R;
import java.util.ArrayList;
import java.util.List;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.PluginResult;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.plugins.map.NavigationParamBean;

public class MapNavigator
extends CordovaPlugin {
    public static final String ACTION_GOTONAVIGATION = "goToMapNavigation";
    public static CallbackContext cbCtx = null;
    private String action = "";

    public boolean execute(String action, JSONArray args, CallbackContext callbackContext) throws JSONException {
        cbCtx = callbackContext;
        this.action = action;
        boolean ret = false;
        if (action.equals(ACTION_GOTONAVIGATION)) {
            NavigationParamBean navigationBean = this.parseParamFromJasonArray(args);
            String checkResult = navigationBean.checkInfoFullfilled();
            if (!"true".equals(checkResult)) {
                this.error(checkResult);
            }
            switch (navigationBean.getMapType()) {
                case "AMap": {
                    this.toGaoDeNavigation(navigationBean);
                    break;
                }
                case "QQ": {
                    this.toTengXunNavigation(navigationBean);
                    break;
                }
                case "Baidu": {
                    this.toBaiDuNavigation(navigationBean);
                    break;
                }
                default: {
                    this.showNavigationSheet(navigationBean);
                }
            }
            ret = true;
        }
        return ret;
    }

    void showNavigationSheet(final NavigationParamBean bean) {
        View mapSheetView = LayoutInflater.from((Context)this.cordova.getActivity()).inflate(R.layout.cordova_popwindow_navigation_sheet, null);
        mapSheetView.findViewById(R.id.v_baidu).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MapNavigator.this.toBaiDuNavigation(bean);
            }
        });
        mapSheetView.findViewById(R.id.v_gaode).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MapNavigator.this.toGaoDeNavigation(bean);
            }
        });
        mapSheetView.findViewById(R.id.v_tengxun).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MapNavigator.this.toTengXunNavigation(bean);
            }
        });
        PopupWindow mBottomSheetPop = new PopupWindow((Context)this.cordova.getActivity());
        mBottomSheetPop.setWidth(-1);
        mBottomSheetPop.setHeight(-2);
        mBottomSheetPop.setContentView(mapSheetView);
        mBottomSheetPop.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        mBottomSheetPop.setOutsideTouchable(true);
        mBottomSheetPop.setFocusable(true);
        mBottomSheetPop.showAtLocation(this.cordova.getActivity().getWindow().getDecorView(), 80, 0, 0);
    }

    void toBaiDuNavigation(NavigationParamBean bean) {
        LatLng desLatLng = bean.parseToBaidu();
        if (this.isAvilible((Context)this.cordova.getActivity(), "com.baidu.BaiduMap")) {
            try {
                Intent intent = Intent.getIntent((String)("intent://map/direction?destination=latlng:" + desLatLng.latitude + "," + desLatLng.longitude + "|name:" + bean.getLocationDescribe() + "&mode=driving&&src=appname#Intent;scheme=bdapp;package=com.baidu.BaiduMap;end"));
                this.cordova.getActivity().startActivity(intent);
                this.cordova.setActivityResultCallback((CordovaPlugin)this);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.error(e.getMessage());
            }
        } else {
            IntentUtil.goToMarket((Context)this.cordova.getActivity(), (String)"com.baidu.BaiduMap");
            this.error("\u60a8\u5c1a\u672a\u5b89\u88c5\u767e\u5ea6\u5730\u56fe");
        }
    }

    void error(String errorMsg) {
        PluginResult pluginResult = new PluginResult(PluginResult.Status.ERROR, errorMsg);
        pluginResult.setKeepCallback(true);
        cbCtx.sendPluginResult(pluginResult);
    }

    void toGaoDeNavigation(NavigationParamBean bean) {
        LatLng desLatLng = bean.parseToCOORDTYPE_GCJ02();
        if (this.isAvilible((Context)this.cordova.getActivity(), "com.autonavi.minimap")) {
            try {
                Intent intent = new Intent();
                intent.setAction("android.intent.action.VIEW");
                intent.addCategory("android.intent.category.DEFAULT");
                String appName = "";
                try {
                    PackageManager packageManager = this.cordova.getActivity().getPackageManager();
                    PackageInfo packageInfo = packageManager.getPackageInfo(this.cordova.getActivity().getPackageName(), 0);
                    int labelRes = packageInfo.applicationInfo.labelRes;
                    appName = this.cordova.getActivity().getResources().getString(labelRes);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                Uri uri = Uri.parse((String)("androidamap://navi?sourceApplication=" + appName + "&poiname=" + bean.getLocationDescribe() + "&lat=" + desLatLng.latitude + "&lon=" + desLatLng.longitude + "&dev=1&style=2"));
                intent.setData(uri);
                this.cordova.getActivity().startActivity(intent);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.error(e.getMessage());
            }
        } else {
            IntentUtil.goToMarket((Context)this.cordova.getActivity(), (String)"com.autonavi.minimap");
            this.error("\u60a8\u5c1a\u672a\u5b89\u88c5\u9ad8\u5fb7\u5730\u56fe");
        }
    }

    void toTengXunNavigation(NavigationParamBean bean) {
        LatLng desLatLng = bean.parseToCOORDTYPE_GCJ02();
        Intent intent = new Intent();
        intent.setAction("android.intent.action.VIEW");
        intent.addCategory("android.intent.category.DEFAULT");
        Uri uri = Uri.parse((String)("qqmap://map/routeplan?type=drive&to=" + bean.getLocationDescribe() + "&tocoord=" + desLatLng.latitude + "," + desLatLng.longitude));
        intent.setData(uri);
        if (intent.resolveActivity(this.cordova.getActivity().getPackageManager()) != null) {
            this.cordova.getActivity().startActivity(intent);
        } else {
            IntentUtil.goToMarket((Context)this.cordova.getActivity(), (String)"com.tencent.map");
            this.error("\u60a8\u5c1a\u672a\u5b89\u88c5\u817e\u8baf\u5730\u56fe");
        }
    }

    public NavigationParamBean parseParamFromJasonArray(JSONArray jsonArray) {
        NavigationParamBean navigationBean = null;
        try {
            JSONObject jsonObject = jsonArray.getJSONObject(0);
            navigationBean = (NavigationParamBean)new Gson().fromJson(jsonObject.toString(), NavigationParamBean.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error(e.getMessage());
            return null;
        }
        return navigationBean;
    }

    private boolean isAvilible(Context context, String packageName) {
        PackageManager packageManager = context.getPackageManager();
        List pinfo = packageManager.getInstalledPackages(0);
        ArrayList<String> pName = new ArrayList<String>();
        if (pinfo != null) {
            for (int i = 0; i < pinfo.size(); ++i) {
                String pn = ((PackageInfo)pinfo.get((int)i)).packageName;
                pName.add(pn);
            }
        }
        return pName.contains(packageName);
    }
}

