package org.plugins.gzip;

import android.text.TextUtils;
import android.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaArgs;
import org.apache.cordova.CordovaPlugin;
import org.json.JSONException;

/**
 * Created by yujianni on 2018/2/26.
 */

public class GzipUtil extends CordovaPlugin {
    //字符编码格式
    private static String charSet = "GBK";
    @Override
    public boolean execute(String action, CordovaArgs args, final CallbackContext callbackContext)  throws JSONException {
        try {
            if ("gzip".equals(action)){
                String data = args.getString(0);
                try{
                    charSet = args.getString(1);
                }catch (Exception e){
                    e.printStackTrace();
                    charSet = "GBK";
                }
                if(TextUtils.isEmpty(charSet)){
                    charSet = "GBK";
                }

                String primStr =gzip(data);
                callbackContext.success(primStr);
            }else if ("gunzip".equals(action)){
                try{
                    charSet = args.getString(1);
                }catch (Exception e){
                    e.printStackTrace();
                    charSet = "GBK";
                }
                if(TextUtils.isEmpty(charSet)){
                    charSet = "GBK";
                }
                String data = args.getString(0);
                String compressedStr =gunzip(data);
                callbackContext.success(compressedStr);
            }
        } catch (Exception e) {
            callbackContext.error(e.getMessage());
        }
        return super.execute(action, args, callbackContext);
    }
    /**
     * 字符串进行Gzip压缩
     *
     * @param primStr
     * @return String
     * @Title: gzip
     */
    public static String gzip(String primStr) {
        if (primStr == null || primStr.length() == 0) {
            return primStr;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gzip = null;
        try {
            gzip = new GZIPOutputStream(out);
            switch (charSet){
                case "GBK":
                    gzip.write(primStr.getBytes("GBK"));
                    break;
                default:
                    gzip.write(primStr.getBytes("UTF-8"));
                    break;
            }

        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (gzip != null) {
                try {
                    gzip.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return Base64.encodeToString(out.toByteArray(), Base64.DEFAULT);
    }
    /**
     * <p>
     * Description:使用gzip进行解压缩
     * </p>
     *
     * @param compressedStr
     * @return
     */
    public static String gunzip(String compressedStr) {
        if (compressedStr == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = null;
        GZIPInputStream ginzip = null;
        byte[] compressed = null;
        String decompressed = null;
        try {
            compressed = Base64.decode(compressedStr, Base64.DEFAULT);
            in = new ByteArrayInputStream(compressed);
            ginzip = new GZIPInputStream(in);
            byte[] buffer = new byte[1024];
            int offset = -1;
            while ((offset = ginzip.read(buffer)) != -1) {
                out.write(buffer, 0, offset);
            }
            switch (charSet){
                case "GBK":
                    decompressed = new String(out.toByteArray(), "GBK");
                    break;
                default:
                    decompressed = new String(out.toByteArray(), "UTF-8");
                    break;
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (ginzip != null) {
                try {
                    ginzip.close();
                } catch (IOException e) {
                }
            }
            if (in != null) {
                try {
                    in.close();
                } catch (IOException e) {
                }
            }
            try {
                out.close();
            } catch (IOException e) {
            }
        }
        return decompressed;
    }
}


