/*
 * Decompiled with CFR 0.152.
 */
package org.plugins.contact;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.ContactsContract;
import android.util.Base64;
import android.util.Log;
import android.widget.Toast;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Set;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.PermissionHelper;
import org.apache.cordova.PluginResult;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Contact
extends CordovaPlugin {
    public static CallbackContext cbCtx = null;
    private String mName;
    private String mNameIn;
    private int whichMethods = 1;
    private boolean mIsNeedHeard;
    private String mAllData;
    private String[] permissions = new String[]{"android.permission.READ_CONTACTS", "android.permission.WRITE_CONTACTS"};

    public boolean execute(String action, JSONArray args, CallbackContext callbackContext) throws JSONException {
        cbCtx = callbackContext;
        boolean ret = false;
        if ("getContactsByName".equals(action)) {
            this.mNameIn = args.getString(0);
            this.mIsNeedHeard = args.getBoolean(1);
            this.whichMethods = 1;
            if (this.hasPermisssion()) {
                if (this.mNameIn == null || "".equals(this.mNameIn)) {
                    Toast.makeText((Context)this.cordova.getActivity(), (CharSequence)"\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (int)0).show();
                } else {
                    this.getContactsByName(this.mNameIn, this.mIsNeedHeard);
                }
            } else {
                this.requestPermissions(0);
            }
            ret = true;
        } else if ("addContacts".equals(action)) {
            this.whichMethods = 2;
            this.mAllData = args.getString(0);
            if (this.hasPermisssion()) {
                this.addContacts();
            } else {
                this.requestPermissions(0);
            }
            ret = true;
        } else if ("getContacts".equals(action)) {
            this.whichMethods = 3;
            this.mIsNeedHeard = args.getBoolean(0);
            if (this.hasPermisssion()) {
                this.getContacts(this.mIsNeedHeard);
            } else {
                this.requestPermissions(0);
            }
            ret = true;
        }
        return ret;
    }

    public boolean hasPermisssion() {
        for (String p : this.permissions) {
            if (PermissionHelper.hasPermission((CordovaPlugin)this, (String)p)) continue;
            return false;
        }
        return true;
    }

    public void requestPermissions(int requestCode) {
        PermissionHelper.requestPermissions((CordovaPlugin)this, (int)requestCode, (String[])this.permissions);
    }

    private void addContacts() {
        String name = "";
        JSONArray phoneNums = null;
        String phoneNumSingle = "";
        String jobTitle = "";
        String orgName = "";
        String deptName = "";
        String email = "";
        String qq = "";
        String birthday = "";
        String note = "";
        String heardImg = "";
        if (this.mAllData == null || "".equals(this.mAllData)) {
            PluginResult pluginResult = new PluginResult(PluginResult.Status.OK, "\u4f20\u5165\u8054\u7cfb\u4eba\u6570\u636e\u4e3a\u7a7a\uff01");
            pluginResult.setKeepCallback(true);
            cbCtx.sendPluginResult(pluginResult);
        } else {
            try {
                JSONObject jsonAddData = new JSONObject(this.mAllData);
                name = jsonAddData.getString("name");
                phoneNums = jsonAddData.optJSONArray("phones");
                phoneNumSingle = jsonAddData.optString("phone");
                jobTitle = jsonAddData.optString("jobTitle");
                orgName = jsonAddData.optString("orgName");
                deptName = jsonAddData.optString("deptName");
                email = jsonAddData.optString("email");
                qq = jsonAddData.optString("qq");
                birthday = jsonAddData.optString("birthday");
                note = jsonAddData.optString("note");
                heardImg = jsonAddData.optString("heardImg");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ContentValues values = new ContentValues();
            Uri rawContactUri = this.cordova.getActivity().getContentResolver().insert(ContactsContract.RawContacts.CONTENT_URI, values);
            long rawContactId = ContentUris.parseId((Uri)rawContactUri);
            values.clear();
            values.put("raw_contact_id", Long.valueOf(rawContactId));
            values.put("mimetype", "vnd.android.cursor.item/name");
            values.put("data2", name == null ? "" : name);
            this.cordova.getActivity().getContentResolver().insert(ContactsContract.Data.CONTENT_URI, values);
            if (phoneNums == null || phoneNums.length() < 1) {
                values.clear();
                values.put("raw_contact_id", Long.valueOf(rawContactId));
                values.put("mimetype", "vnd.android.cursor.item/phone_v2");
                values.put("data1", phoneNumSingle == null ? "" : phoneNumSingle);
                values.put("data2", Integer.valueOf(2));
                this.cordova.getActivity().getContentResolver().insert(ContactsContract.Data.CONTENT_URI, values);
            } else {
                for (int i = 0; i < phoneNums.length(); ++i) {
                    values.clear();
                    values.put("raw_contact_id", Long.valueOf(rawContactId));
                    values.put("mimetype", "vnd.android.cursor.item/phone_v2");
                    try {
                        values.put("data1", phoneNums.getString(i) == null ? "" : phoneNums.getString(i));
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    values.put("data2", Integer.valueOf(2));
                    this.cordova.getActivity().getContentResolver().insert(ContactsContract.Data.CONTENT_URI, values);
                }
            }
            values.clear();
            values.put("raw_contact_id", Long.valueOf(rawContactId));
            values.put("mimetype", "vnd.android.cursor.item/email_v2");
            values.put("data1", email == null ? "" : email);
            values.put("data2", Integer.valueOf(2));
            this.cordova.getActivity().getContentResolver().insert(ContactsContract.Data.CONTENT_URI, values);
            values.clear();
            values.put("raw_contact_id", Long.valueOf(rawContactId));
            values.put("mimetype", "vnd.android.cursor.item/organization");
            values.put("data1", orgName == null ? "" : orgName);
            values.put("data4", jobTitle == null ? "" : jobTitle);
            values.put("data2", Integer.valueOf(1));
            this.cordova.getActivity().getContentResolver().insert(ContactsContract.Data.CONTENT_URI, values);
            values.clear();
            values.put("raw_contact_id", Long.valueOf(rawContactId));
            values.put("mimetype", "vnd.android.cursor.item/contact_event");
            values.put("data1", birthday == null ? "" : birthday);
            this.cordova.getActivity().getContentResolver().insert(ContactsContract.Data.CONTENT_URI, values);
            values.clear();
            values.put("raw_contact_id", Long.valueOf(rawContactId));
            values.put("mimetype", "vnd.android.cursor.item/im");
            values.put("data1", qq == null ? "" : qq);
            values.put("data2", Integer.valueOf(4));
            this.cordova.getActivity().getContentResolver().insert(ContactsContract.Data.CONTENT_URI, values);
            values.clear();
            values.put("raw_contact_id", Long.valueOf(rawContactId));
            values.put("mimetype", "vnd.android.cursor.item/note");
            values.put("data1", note == null ? "" : note);
            this.cordova.getActivity().getContentResolver().insert(ContactsContract.Data.CONTENT_URI, values);
            byte[] heard = Base64.decode((String)heardImg, (int)0);
            if (heard != null) {
                values.clear();
                values.put("raw_contact_id", Long.valueOf(rawContactId));
                values.put("mimetype", "vnd.android.cursor.item/photo");
                values.put("data1", heard);
                this.cordova.getActivity().getContentResolver().insert(ContactsContract.Data.CONTENT_URI, values);
            }
            PluginResult pluginResult = new PluginResult(PluginResult.Status.OK, true);
            pluginResult.setKeepCallback(true);
            cbCtx.sendPluginResult(pluginResult);
        }
    }

    private void getContactsByName(String names, boolean isNeedImage) {
        ContentResolver contentResolver = this.cordova.getActivity().getContentResolver();
        Cursor cursor = contentResolver.query(ContactsContract.Contacts.CONTENT_URI, new String[]{"_id"}, null, null, null);
        JSONObject json = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        while (cursor.moveToNext()) {
            String id = cursor.getString(cursor.getColumnIndex("_id"));
            Cursor contactInfoCursor = contentResolver.query(ContactsContract.Data.CONTENT_URI, new String[]{"contact_id", "mimetype", "data1"}, "contact_id=" + id, null, null);
            while (contactInfoCursor.moveToNext()) {
                String mimetype = contactInfoCursor.getString(contactInfoCursor.getColumnIndex("mimetype"));
                String value = null;
                try {
                    if (mimetype.contains("/name")) {
                        this.mName = value = contactInfoCursor.getString(contactInfoCursor.getColumnIndex("data1"));
                        if (!names.equals(this.mName)) continue;
                        json.put("name", (Object)value);
                        continue;
                    }
                    if (mimetype.contains("/im")) {
                        if (!names.equals(this.mName)) continue;
                        value = contactInfoCursor.getString(contactInfoCursor.getColumnIndex("data1"));
                        json.put("qq", (Object)value);
                        continue;
                    }
                    if (mimetype.contains("/email")) {
                        if (!names.equals(this.mName)) continue;
                        value = contactInfoCursor.getString(contactInfoCursor.getColumnIndex("data1"));
                        json.put("email", (Object)value);
                        continue;
                    }
                    if (mimetype.contains("/postal")) {
                        if (!names.equals(this.mName)) continue;
                        value = contactInfoCursor.getString(contactInfoCursor.getColumnIndex("data1"));
                        json.put("postal", (Object)value);
                        continue;
                    }
                    if (mimetype.contains("/group")) {
                        if (!names.equals(this.mName)) continue;
                        value = contactInfoCursor.getString(contactInfoCursor.getColumnIndex("data1"));
                        json.put("deptName", (Object)value);
                        continue;
                    }
                    if (mimetype.contains("/contact_event")) {
                        if (!names.equals(this.mName)) continue;
                        value = contactInfoCursor.getString(contactInfoCursor.getColumnIndex("data1"));
                        json.put("birthday", (Object)value);
                        continue;
                    }
                    if (!mimetype.contains("/note") || !names.equals(this.mName)) continue;
                    value = contactInfoCursor.getString(contactInfoCursor.getColumnIndex("data1"));
                    json.put("note", (Object)value);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            if (names.equals(this.mName)) {
                Cursor phoneCursor;
                block32: {
                    String orgWhere = "contact_id = ? AND mimetype = ?";
                    String[] orgWhereParams = new String[]{id, "vnd.android.cursor.item/organization"};
                    Cursor orgCur = contentResolver.query(ContactsContract.Data.CONTENT_URI, null, orgWhere, orgWhereParams, null);
                    if (orgCur.moveToFirst()) {
                        String company = orgCur.getString(orgCur.getColumnIndex("data1"));
                        String title = orgCur.getString(orgCur.getColumnIndex("data4"));
                        try {
                            json.put("orgName", (Object)(company == null ? "" : company));
                            json.put("jobTitle", (Object)(title == null ? "" : title));
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                    orgCur.close();
                    phoneCursor = contentResolver.query(ContactsContract.CommonDataKinds.Phone.CONTENT_URI, null, "contact_id = " + id, null, null);
                    while (phoneCursor.moveToNext()) {
                        JSONObject jsonChild = new JSONObject();
                        String number = phoneCursor.getString(phoneCursor.getColumnIndex("data1"));
                        String type = phoneCursor.getString(phoneCursor.getColumnIndex("data2"));
                        String TypePhone = "";
                        if ("1".equals(type)) {
                            TypePhone = "homeTypePhone";
                        } else if ("2".equals(type)) {
                            TypePhone = "homeTypePhone";
                        } else if ("3".equals(type)) {
                            TypePhone = "homeTypePhone";
                        }
                        try {
                            jsonChild.put(TypePhone, (Object)number);
                            jsonArray.put(phoneCursor.getPosition(), (Object)jsonChild);
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                    try {
                        json.put("phone", (Object)jsonArray);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    Cursor curPhoto = null;
                    try {
                        if (isNeedImage) {
                            String selection;
                            String[] projection;
                            String photo_id = null;
                            String selection1 = "_id = " + id;
                            Cursor cur1 = contentResolver.query(ContactsContract.Contacts.CONTENT_URI, null, selection1, null, null);
                            if (cur1.getCount() > 0) {
                                cur1.moveToFirst();
                                photo_id = cur1.getString(cur1.getColumnIndex("photo_id"));
                            }
                            if ((curPhoto = contentResolver.query(ContactsContract.Data.CONTENT_URI, projection = new String[]{"data15"}, selection = "_id = " + photo_id, null, null)).getCount() > 0) {
                                curPhoto.moveToFirst();
                                byte[] contactIcon = curPhoto.getBlob(0);
                                String photo = Base64.encodeToString((byte[])contactIcon, (int)0);
                                json.put("image", (Object)photo);
                                curPhoto.close();
                            }
                        } else {
                            json.put("image", (Object)"");
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        if (curPhoto == null) break block32;
                        curPhoto.close();
                    }
                }
                PluginResult pluginResult = new PluginResult(PluginResult.Status.OK, json);
                pluginResult.setKeepCallback(true);
                cbCtx.sendPluginResult(pluginResult);
                phoneCursor.close();
                contactInfoCursor.close();
                cursor.close();
                return;
            }
            try {
                json.put("message", (Object)"\u8054\u7cfb\u4eba\u4e0d\u5b58\u5728\uff01");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            PluginResult pluginResult = new PluginResult(PluginResult.Status.OK, json);
            pluginResult.setKeepCallback(true);
            cbCtx.sendPluginResult(pluginResult);
            contactInfoCursor.close();
        }
        cursor.close();
    }

    private void getContacts(boolean isNeedImage) {
        Log.e((String)"lyj", (String)"getContactsstart");
        try {
            JSONArray allArray = new JSONArray();
            ContentResolver contentResolver = this.cordova.getActivity().getContentResolver();
            LinkedHashMap<String, JSONObject> baseInfoHashMap = new LinkedHashMap<String, JSONObject>();
            String[] projecttions = null;
            projecttions = isNeedImage ? new String[]{"contact_id", "mimetype", "data1", "data1", "data4", "data15"} : new String[]{"contact_id", "mimetype", "data1", "data1", "data4"};
            String where = "mimetype like '%/name%' or mimetype like '%/im%' or mimetype like '%/email%' or mimetype like '%/postal%' or mimetype like '%/group%' or mimetype like '%/contact_event%' or mimetype like '%/note%' or mimetype like '%vnd.android.cursor.item/organization%'";
            if (isNeedImage) {
                where = where + " or " + "mimetype" + " like '%/photo%'";
            }
            Cursor contactInfoCursor = contentResolver.query(ContactsContract.Data.CONTENT_URI, projecttions, where, null, null);
            while (contactInfoCursor.moveToNext()) {
                String value;
                byte[] contactIcon;
                JSONObject json = null;
                String id = contactInfoCursor.getString(contactInfoCursor.getColumnIndex("contact_id"));
                if (((HashMap)baseInfoHashMap).get(id) == null) {
                    json = new JSONObject();
                    baseInfoHashMap.put(id, json);
                } else {
                    json = (JSONObject)((HashMap)baseInfoHashMap).get(id);
                }
                String mimetype = contactInfoCursor.getString(contactInfoCursor.getColumnIndex("mimetype"));
                if (isNeedImage && mimetype.contains("/photo") && (contactIcon = contactInfoCursor.getBlob(contactInfoCursor.getColumnIndex("data15"))) != null && contactIcon.length != 0) {
                    Log.e((String)"lyj", (String)("getContactsstart" + contactInfoCursor.getString(contactInfoCursor.getColumnIndex("mimetype"))));
                    String photo = Base64.encodeToString((byte[])contactIcon, (int)0);
                    json.put("image", (Object)photo);
                }
                if (mimetype.contains("/name")) {
                    value = contactInfoCursor.getString(contactInfoCursor.getColumnIndex("data1"));
                    json.put("name", (Object)value);
                    continue;
                }
                if (mimetype.contains("/im")) {
                    value = contactInfoCursor.getString(contactInfoCursor.getColumnIndex("data1"));
                    json.put("qq", (Object)value);
                    continue;
                }
                if (mimetype.contains("/email")) {
                    value = contactInfoCursor.getString(contactInfoCursor.getColumnIndex("data1"));
                    json.put("email", (Object)value);
                    continue;
                }
                if (mimetype.contains("/postal")) {
                    value = contactInfoCursor.getString(contactInfoCursor.getColumnIndex("data1"));
                    json.put("postal", (Object)value);
                    continue;
                }
                if (mimetype.contains("/group")) {
                    value = contactInfoCursor.getString(contactInfoCursor.getColumnIndex("data1"));
                    json.put("deptName", (Object)value);
                    continue;
                }
                if (mimetype.contains("/contact_event")) {
                    value = contactInfoCursor.getString(contactInfoCursor.getColumnIndex("data1"));
                    json.put("birthday", (Object)value);
                    continue;
                }
                if (mimetype.contains("/note")) {
                    value = contactInfoCursor.getString(contactInfoCursor.getColumnIndex("data1"));
                    json.put("note", (Object)value);
                    continue;
                }
                if (!mimetype.equals("vnd.android.cursor.item/organization")) continue;
                String company = contactInfoCursor.getString(contactInfoCursor.getColumnIndex("data1"));
                String title = contactInfoCursor.getString(contactInfoCursor.getColumnIndex("data4"));
                try {
                    json.put("orgName", (Object)(company == null ? "" : company));
                    json.put("jobTitle", (Object)(title == null ? "" : title));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            contactInfoCursor.close();
            Cursor phoneCursor = contentResolver.query(ContactsContract.CommonDataKinds.Phone.CONTENT_URI, new String[]{"contact_id", "data1", "data2"}, null, null, null);
            while (phoneCursor.moveToNext()) {
                String phoneId = phoneCursor.getString(phoneCursor.getColumnIndex("contact_id"));
                String number = phoneCursor.getString(phoneCursor.getColumnIndex("data1"));
                String type = phoneCursor.getString(phoneCursor.getColumnIndex("data2"));
                JSONObject json = (JSONObject)((HashMap)baseInfoHashMap).get(phoneId);
                JSONObject jsonChild = new JSONObject();
                JSONArray jsonArray = null;
                if (json == null) {
                    json = new JSONObject();
                    json.put("name", (Object)number);
                    jsonArray = new JSONArray();
                    json.put("phone", (Object)jsonArray);
                } else if (json != null && json.has("phone")) {
                    jsonArray = (JSONArray)((JSONObject)((HashMap)baseInfoHashMap).get(phoneId)).get("phone");
                } else {
                    jsonArray = new JSONArray();
                    json.put("phone", (Object)jsonArray);
                }
                String TypePhone = "";
                if ("1".equals(type)) {
                    TypePhone = "homeTypePhone";
                } else if ("2".equals(type)) {
                    TypePhone = "mobileTypePhone";
                } else if ("3".equals(type)) {
                    TypePhone = "workTypePhone";
                }
                try {
                    jsonChild.put(TypePhone, (Object)number);
                    int count = jsonArray.length();
                    jsonArray.put(count, (Object)jsonChild);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            phoneCursor.close();
            Set keyset = ((HashMap)baseInfoHashMap).keySet();
            for (String key : keyset) {
                try {
                    allArray.put(((HashMap)baseInfoHashMap).get(key));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            PluginResult pluginResult = new PluginResult(PluginResult.Status.OK, allArray);
            pluginResult.setKeepCallback(true);
            cbCtx.sendPluginResult(pluginResult);
        }
        catch (Exception e) {
            e.printStackTrace();
            PluginResult pluginResult = new PluginResult(PluginResult.Status.ERROR, e.getMessage());
            pluginResult.setKeepCallback(true);
            cbCtx.sendPluginResult(pluginResult);
        }
        Log.e((String)"lyj", (String)"getContactsends");
    }

    public void onRequestPermissionResult(int requestCode, String[] permissions, int[] grantResults) throws JSONException {
        super.onRequestPermissionResult(requestCode, permissions, grantResults);
        if (cbCtx == null) {
            return;
        }
        for (int r : grantResults) {
            if (r != -1) continue;
            PluginResult result = new PluginResult(PluginResult.Status.ILLEGAL_ACCESS_EXCEPTION);
            cbCtx.sendPluginResult(result);
            return;
        }
        switch (requestCode) {
            case 0: {
                if (this.whichMethods == 1) {
                    this.getContactsByName(this.mName, this.mIsNeedHeard);
                    break;
                }
                if (this.whichMethods == 2) {
                    this.addContacts();
                    break;
                }
                this.getContacts(this.mIsNeedHeard);
            }
        }
    }
}

