/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.platform.cloud.business.system.service.impl;

import com.jxdinfo.hussar.platform.cloud.business.subservice.api.dto.ProductDto;
import com.jxdinfo.hussar.platform.cloud.business.subservice.api.entity.Dict;
import com.jxdinfo.hussar.platform.cloud.business.subservice.api.entity.Product;
import com.jxdinfo.hussar.platform.cloud.business.subservice.api.feign.RemoteDictService;
import com.jxdinfo.hussar.platform.cloud.business.subservice.api.feign.RemoteProductService;
import com.jxdinfo.hussar.platform.cloud.business.system.api.dto.OrderDto;
import com.jxdinfo.hussar.platform.cloud.business.system.api.entity.Account;
import com.jxdinfo.hussar.platform.cloud.business.system.api.entity.Order;
import com.jxdinfo.hussar.platform.cloud.business.system.mapper.OrderMapper;
import com.jxdinfo.hussar.platform.cloud.business.system.service.AccountService;
import com.jxdinfo.hussar.platform.cloud.business.system.service.OrderService;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.time.LocalDateTime;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrderServiceImpl
extends HussarServiceImpl<OrderMapper, Order>
implements OrderService {
    @Resource
    AccountService accountService;
    @Resource
    RemoteProductService productService;
    @Resource
    RemoteDictService dictService;

    @Override
    public void addOrder(OrderDto order) {
        Account account = new Account();
        account.setBalance(Double.valueOf(1000.0));
        account.setName(order.getUserName());
        account.setLastUpdateTime(LocalDateTime.now());
        this.accountService.save(account);
        if (order.getFlag() == 1) {
            throw new HussarException("\u53d1\u751f\u5f02\u5e38\uff0caccount\u4fdd\u5b58\u6210\u529f\u4e4b\u540e\u51fa\u73b0\u9519\u8bef");
        }
        Product product = new Product();
        product.setPrice(Double.valueOf(100.0));
        product.setStock(Long.valueOf(100L));
        product.setProductName(order.getProductName());
        ProductDto productDto = new ProductDto();
        BeanUtil.copy((Object)product, (Object)productDto);
        productDto.setFlag(Integer.valueOf(order.getFlag()));
        this.productService.saveProduct(productDto);
        if (order.getFlag() == 2) {
            throw new HussarException("\u53d1\u751f\u5f02\u5e38\uff0caccount\u548cproduct\u4fdd\u5b58\u6210\u529f\u4e4b\u540e\u51fa\u73b0\u9519\u8bef");
        }
        Order orderData = new Order();
        orderData.setAmount(Long.valueOf(20L));
        orderData.setProductId(product.getId());
        orderData.setStatus("1");
        orderData.setTotalPrice(Double.valueOf(100.0));
        orderData.setUserId(account.getId());
        this.save((BaseEntity)orderData);
        if (order.getFlag() == 3) {
            throw new HussarException("\u53d1\u751f\u5f02\u5e38\uff0caccount\u548cproduct\u3001order\u4fdd\u5b58\u6210\u529f\u4e4b\u540e\u51fa\u73b0\u9519\u8bef");
        }
    }

    @Override
    public void singleDatasource(OrderDto orderDto) {
        Order orderData = new Order();
        orderData.setAmount(Long.valueOf(20L));
        orderData.setProductId(Long.valueOf(1L));
        orderData.setStatus("1");
        orderData.setTotalPrice(Double.valueOf(100.0));
        orderData.setUserId(Long.valueOf(2L));
        this.save((BaseEntity)orderData);
        if (orderDto.getFlag() == 1) {
            throw new HussarException("\u4fdd\u5b58order \u4e4b\u540e\u5931\u8d25");
        }
        Dict dict = new Dict();
        dict.setDictName(orderDto.getDictName());
        dict.setDictValue("product_value");
        this.dictService.addDict(dict);
        if (orderDto.getFlag() == 2) {
            throw new HussarException("\u4fdd\u5b58order \u548c dict \u4e4b\u540e\u5931\u8d25");
        }
    }

    @Override
    public void updateTest(OrderDto orderDto) {
        Order orderData4 = new Order();
        orderData4.setId(Long.valueOf("564541672697110528"));
        orderData4.setAmount(Long.valueOf(20L));
        orderData4.setProductId(Long.valueOf(1L));
        orderData4.setStatus("1");
        orderData4.setTotalPrice(Double.valueOf(100.0));
        orderData4.setUserId(Long.valueOf(2L));
        Order orderData5 = new Order();
        orderData5.setId(Long.valueOf("564541672697110666"));
        orderData5.setAmount(Long.valueOf(20L));
        orderData5.setProductId(Long.valueOf(1L));
        orderData5.setStatus("1");
        orderData5.setTotalPrice(Double.valueOf(100.0));
        orderData5.setUserId(Long.valueOf(2L));
        this.updateById((BaseEntity)orderData4);
        this.updateById((BaseEntity)orderData5);
    }

    @Override
    @HussarTransactional(propagation=Propagation.REQUIRED)
    public void datasourceTest(OrderDto orderDto) throws Exception {
        if (HussarUtils.isEmpty((Object)orderDto)) {
            orderDto = new OrderDto();
        }
        ArrayList<Order> orders = new ArrayList<Order>();
        Order order = new Order();
        order.setAmount(Long.valueOf(1L));
        order.setProductId(Long.valueOf(2222L));
        order.setTotalPrice(Double.valueOf(100.0));
        Order order1 = new Order();
        order1.setAmount(Long.valueOf(2L));
        order1.setProductId(Long.valueOf(3333L));
        order1.setTotalPrice(Double.valueOf(110.0));
        orders.add(order);
        orders.add(order1);
        this.saveBatch(orders);
        if (orderDto.getFlag() == 1) {
            throw new HussarException("\u4fdd\u5b58order\u540e,\u629b\u51fa\u5f02\u5e38");
        }
        try {
            ProductDto productDto = new ProductDto();
            productDto.setId(order.getProductId());
            productDto.setFlag(Integer.valueOf(orderDto.getFlag()));
            this.productService.dataSourceTest(productDto);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.accountService.dataSourceTest(order.getProductId(), "slave_2", orderDto.getFlag());
        order.setTotalPrice(Double.valueOf(110.0));
        order1.setTotalPrice(Double.valueOf(120.0));
        this.updateById((BaseEntity)order);
        this.updateById((BaseEntity)order1);
        if (orderDto.getFlag() == 5) {
            throw new HussarException("\u6279\u91cf\u66f4\u65b0order\u540e,\u629b\u51fa\u5f02\u5e38");
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public void transactionalTest(OrderDto orderDto) throws Exception {
        if (HussarUtils.isEmpty((Object)orderDto)) {
            orderDto = new OrderDto();
        }
        ArrayList<Order> orders = new ArrayList<Order>();
        Order order = new Order();
        order.setAmount(Long.valueOf(1L));
        order.setProductId(Long.valueOf(2222L));
        order.setTotalPrice(Double.valueOf(100.0));
        Order order1 = new Order();
        order1.setAmount(Long.valueOf(2L));
        order1.setProductId(Long.valueOf(3333L));
        order1.setTotalPrice(Double.valueOf(110.0));
        orders.add(order);
        orders.add(order1);
        this.saveBatch(orders);
        if (orderDto.getFlag() == 1) {
            throw new HussarException("\u4fdd\u5b58order\u540e,\u629b\u51fa\u5f02\u5e38");
        }
        try {
            ProductDto productDto = new ProductDto();
            productDto.setId(order.getProductId());
            this.productService.transactionalTest(productDto);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.accountService.transactionalTest(order.getProductId(), orderDto.getFlag());
        order.setTotalPrice(Double.valueOf(110.0));
        order1.setTotalPrice(Double.valueOf(120.0));
        this.updateBatchById(orders);
        if (orderDto.getFlag() == 5) {
            throw new HussarException("\u6279\u91cf\u66f4\u65b0order\u540e,\u629b\u51fa\u5f02\u5e38");
        }
    }
}

