/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.platform.cloud.business.system.api.util;

import com.jxdinfo.hussar.platform.cloud.business.system.api.dto.MenuTree;
import com.jxdinfo.hussar.platform.cloud.business.system.api.dto.TreeNode;
import com.jxdinfo.hussar.platform.cloud.business.system.api.entity.SysMenu;
import java.util.ArrayList;
import java.util.List;

public class TreeUtil {
    public static <T extends TreeNode> List<T> build(List<T> treeNodes, Object root) {
        ArrayList<TreeNode> trees = new ArrayList<TreeNode>();
        for (TreeNode treeNode : treeNodes) {
            if (root.equals(treeNode.getParentId())) {
                trees.add(treeNode);
            }
            for (TreeNode it : treeNodes) {
                if (!it.getParentId().equals(treeNode.getId())) continue;
                if (treeNode.getChildren() == null) {
                    treeNode.setChildren(new ArrayList<TreeNode>());
                }
                treeNode.add(it);
            }
        }
        return trees;
    }

    public static <T extends TreeNode> List<T> buildByRecursive(List<T> treeNodes, Object root) {
        ArrayList<TreeNode> trees = new ArrayList<TreeNode>();
        for (TreeNode treeNode : treeNodes) {
            if (!root.equals(treeNode.getParentId())) continue;
            trees.add(TreeUtil.findChildren(treeNode, treeNodes));
        }
        return trees;
    }

    public static <T extends TreeNode> T findChildren(T treeNode, List<T> treeNodes) {
        for (TreeNode it : treeNodes) {
            if (!treeNode.getId().equals(it.getParentId())) continue;
            if (treeNode.getChildren() == null) {
                treeNode.setChildren(new ArrayList<TreeNode>());
            }
            treeNode.add(TreeUtil.findChildren(it, treeNodes));
        }
        return treeNode;
    }

    public static List<MenuTree> buildTree(List<SysMenu> menus, Long root) {
        ArrayList<MenuTree> trees = new ArrayList<MenuTree>();
        for (SysMenu menu : menus) {
            MenuTree node = new MenuTree();
            node.setId(menu.getId());
            node.setParentId(menu.getParentId());
            node.setName(menu.getName());
            node.setPath(menu.getPath());
            node.setPermission(menu.getPermission());
            node.setLabel(menu.getName());
            node.setIcon(menu.getIcon());
            node.setType(menu.getType());
            node.setSort(menu.getSort());
            node.setHasChildren(true);
            node.setKeepAlive(menu.getKeepAlive());
            trees.add(node);
        }
        return TreeUtil.build(trees, root);
    }
}

