/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.platform.cloud.business.subservice.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.cloud.business.subservice.api.dto.ProductDto;
import com.jxdinfo.hussar.platform.cloud.business.subservice.api.entity.Dict;
import com.jxdinfo.hussar.platform.cloud.business.subservice.api.entity.Product;
import com.jxdinfo.hussar.platform.cloud.business.subservice.mapper.ProductMapper;
import com.jxdinfo.hussar.platform.cloud.business.subservice.service.DictService;
import com.jxdinfo.hussar.platform.cloud.business.subservice.service.ProductService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProductServiceImpl
extends HussarServiceImpl<ProductMapper, Product>
implements ProductService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProductServiceImpl.class);
    @Autowired
    private DictService dictService;
    @Autowired
    private Environment environment;

    @Override
    @HussarDs(value="#connname")
    public List<Product> getProductListByConnName(String connname) {
        return this.list();
    }

    @Override
    public List<Product> getProductListNoConnName() {
        return this.list();
    }

    @HussarTransactional
    public ApiResponse<List<Dict>> saveProduct(ProductDto productDto) {
        Product product = new Product();
        BeanUtil.copy((Object)productDto, (Object)product);
        this.save((BaseEntity)product);
        if (HussarUtils.isNotEmpty((Object)productDto) && productDto.getFlag() == 4) {
            throw new HussarException("product\u4fdd\u5b58\u6210\u529f\u4e4b\u540e\u629b\u51fa\u5f02\u5e38");
        }
        List dictList = ((Page)this.dictService.page((IPage)new Page(1L, 50L))).getRecords();
        ArrayList list = new ArrayList();
        list.addAll(dictList);
        list.addAll(dictList);
        return ApiResponse.success((Object)dictList);
    }

    @Override
    @HussarTransactional(propagation=Propagation.REQUIRES_NEW)
    public void dataSourceTest(ProductDto productDto) {
        Product product = (Product)this.getById(productDto.getId());
        if (HussarUtils.isEmpty((Object)product)) {
            product = new Product();
            product.setId(productDto.getId());
            product.setPrice(Double.valueOf(100.0));
            product.setProductName("hhh");
            this.save((BaseEntity)product);
            return;
        }
        Double price = product.getPrice() + 1.0;
        product.setPrice(price);
        this.updateById((BaseEntity)product);
        if (HussarUtils.isNotEmpty((Object)productDto) && productDto.getFlag() == 2) {
            this.removeById((BaseEntity)product);
            throw new HussarException("\u4fdd\u5b58\u6216\u66f4\u65b0produce\u540e\uff0c\u629b\u51fa\u5f02\u5e38");
        }
        Dict dict = new Dict();
        dict.setDictName("\u5206\u5e03\u5f0f\u4e8b\u52a1");
        dict.setDictValue("1111");
        this.dictService.addDict(dict);
        if (HussarUtils.isNotEmpty((Object)productDto) && productDto.getFlag() == 3) {
            throw new HussarException("\u4fdd\u5b58dict\u540e\uff0c\u629b\u51fa\u5f02\u5e38");
        }
    }

    @Override
    @Transactional
    public void transactionalTest(ProductDto productDto) {
        Product product = (Product)this.getById(productDto.getId());
        if (HussarUtils.isEmpty((Object)product)) {
            product = new Product();
            product.setId(productDto.getId());
            product.setPrice(Double.valueOf(100.0));
            product.setProductName("hhh");
            this.save((BaseEntity)product);
            return;
        }
        Double price = product.getPrice() + 1.0;
        product.setPrice(price);
        this.updateById((BaseEntity)product);
        if (HussarUtils.isNotEmpty((Object)productDto) && productDto.getFlag() == 2) {
            throw new HussarException("\u66f4\u65b0produce\u540e\uff0c\u629b\u51fa\u5f02\u5e38");
        }
        Dict dict = new Dict();
        dict.setDictName("\u5206\u5e03\u5f0f\u4e8b\u52a1");
        dict.setDictValue("1111");
        this.dictService.transactionalTest(dict);
        if (HussarUtils.isNotEmpty((Object)productDto) && productDto.getFlag() == 3) {
            throw new HussarException("\u4fdd\u5b58dict\u540e\uff0c\u629b\u51fa\u5f02\u5e38");
        }
    }

    @Override
    public Map<String, Object> serviceProduct() {
        LOGGER.info("\u8c03\u7528 subService \u7684 ProductServiceImpl \u7684 serviceProduct \u65b9\u6cd5");
        HashMap<String, Object> map = new HashMap<String, Object>();
        String version = this.environment.getProperty("spring.cloud.nacos.discovery.metadata.VERSION");
        String group = this.environment.getProperty("spring.cloud.nacos.discovery.group");
        String devUser = this.environment.getProperty("spring.cloud.nacos.discovery.metadata.DEV_USER");
        map.put("subService \u670d\u52a1", "version: " + version + ", group: " + group + ", devUser: " + devUser);
        return map;
    }
}

