/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.platform.cloud.business.subservice.service.impl;

import com.jxdinfo.hussar.platform.cloud.business.subservice.api.dto.DictDto;
import com.jxdinfo.hussar.platform.cloud.business.subservice.api.entity.Dict;
import com.jxdinfo.hussar.platform.cloud.business.subservice.api.entity.Product;
import com.jxdinfo.hussar.platform.cloud.business.subservice.mapper.DictMapper;
import com.jxdinfo.hussar.platform.cloud.business.subservice.service.DictService;
import com.jxdinfo.hussar.platform.cloud.business.subservice.service.ProductService;
import com.jxdinfo.hussar.platform.cloud.business.system.api.entity.Account;
import com.jxdinfo.hussar.platform.cloud.business.system.api.feign.RemoteAccountService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.ConvertUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
@HussarDs(value="slave_2")
public class DictServiceImpl
extends HussarServiceImpl<DictMapper, Dict>
implements DictService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DictServiceImpl.class);
    @Autowired
    ProductService productService;
    @Resource
    RemoteAccountService remoteAccountService;

    @Override
    @HussarDs(value="#connname")
    public List<Dict> getDictListByConnName(String connname) {
        return this.list();
    }

    @Override
    public List<Dict> getDictListNoConnName() {
        return this.list();
    }

    @Override
    public List<Dict> getDictListToProductNoConname() {
        List<Product> productList = this.productService.getProductListNoConnName();
        for (Product p : productList) {
            System.out.println(p.getPrice());
        }
        return this.list();
    }

    @Override
    @HussarDs(value="#connname")
    public List<Dict> getDictListToProductByConname(String connname) {
        List<Product> productList = this.productService.getProductListByConnName(connname);
        for (Product p : productList) {
            System.out.println(p.getPrice());
        }
        return this.list();
    }

    @Override
    @HussarTransactional(propagation=Propagation.NOT_SUPPORTED)
    public void addDict(Dict dict) {
        this.save((BaseEntity)dict);
        Account account = new Account();
        account.setName("\u5206\u5e03\u5f0f\u4e8b\u52a1");
        this.remoteAccountService.saveAccount(account);
    }

    @Override
    @Transactional
    public void transactionalTest(Dict dict) {
        this.save((BaseEntity)dict);
    }

    @Override
    public String hasGenericity() {
        return "\u6d4b\u8bd5\u6210\u529f";
    }

    @Override
    public List<Dict> hasGenericityActual() {
        return this.list();
    }

    @Override
    public DictDto syncFeignSub() {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        String authorization = requestAttributes.getRequest().getHeader("Authorization");
        String clientId = requestAttributes.getRequest().getHeader("client-id");
        String header = requestAttributes.getRequest().getHeader("test-header");
        LOGGER.info("{},\u83b7\u53d6header\u3010Authorization\u3011={}", (Object)Thread.currentThread().getName(), (Object)authorization);
        LOGGER.info("{},\u83b7\u53d6header\u3010clientId\u3011={}", (Object)Thread.currentThread().getName(), (Object)clientId);
        LOGGER.info("{},\u83b7\u53d6header\u3010test-header\u3011={}", (Object)Thread.currentThread().getName(), (Object)header);
        DictDto dictDto = new DictDto();
        List list = this.list();
        Dict dict = null;
        if (HussarUtils.isNotEmpty((Object)list)) {
            dict = (Dict)list.get(0);
        }
        dictDto.setDict(dict);
        HashMap<Integer, Long> map = new HashMap<Integer, Long>();
        map.put(1, 1000L);
        map.put(2, 10002L);
        dictDto.setMap(map);
        return dictDto;
    }

    @Override
    public Map<Integer, Long> syncFeignSubMap() {
        HashMap<Integer, Long> map = new HashMap<Integer, Long>();
        for (int i = 0; i < 6; ++i) {
            map.put(i, (Long)ConvertUtil.convert((Object)i, Long.class));
        }
        return map;
    }

    @Override
    public ApiResponse<Map<Integer, Long>> syncFeignSubMapApi() {
        HashMap<Integer, Object> map = new HashMap<Integer, Object>();
        for (int i = 0; i < 6; ++i) {
            map.put(i, ConvertUtil.convert((Object)i, Long.class));
        }
        return ApiResponse.success(map);
    }
}

