/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.platform.cloud.business.subservice.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.cloud.business.subservice.api.entity.Dict;
import com.jxdinfo.hussar.platform.cloud.business.subservice.api.entity.SysDict;
import com.jxdinfo.hussar.platform.cloud.business.subservice.api.entity.SysDictItem;
import com.jxdinfo.hussar.platform.cloud.business.subservice.service.DictService;
import com.jxdinfo.hussar.platform.cloud.business.subservice.service.SysDictItemService;
import com.jxdinfo.hussar.platform.cloud.business.subservice.service.SysDictService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.validation.Valid;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dict"})
@Api(value="dict", tags={"\u5b57\u5178\u7ba1\u7406\u6a21\u5757"})
public class SysDictController {
    private final SysDictService sysDictService;
    private final SysDictItemService sysDictItemService;
    private final DictService dictService;

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u901a\u8fc7ID\u67e5\u8be2\u5b57\u5178\u4fe1\u606f", notes="\u901a\u8fc7ID\u67e5\u8be2\u5b57\u5178\u4fe1\u606f")
    public ApiResponse getById(@ApiParam(value="\u5b57\u5178\u8868id") @PathVariable(value="id") Long id) {
        return ApiResponse.success((Object)this.sysDictService.getById(id));
    }

    @GetMapping(value={"/page"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5b57\u5178\u4fe1\u606f", notes="\u5206\u9875\u67e5\u8be2\u5b57\u5178\u4fe1\u606f")
    public ApiResponse<IPage> getDictPage(@ApiParam(value="\u5206\u9875\u53c2\u6570") Page page, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") SysDict sysDict) {
        return ApiResponse.success((Object)this.sysDictService.page((IPage)page, (Wrapper)Wrappers.query((Object)sysDict)));
    }

    @GetMapping(value={"/type/{type}"})
    @ApiOperation(value="\u901a\u8fc7\u5b57\u5178\u7c7b\u578b\u67e5\u627e\u5b57\u5178", notes="\u901a\u8fc7\u5b57\u5178\u7c7b\u578b\u67e5\u627e\u5b57\u5178")
    @Cacheable(value={"dict_details"}, key="#type", unless="#result.data.isEmpty()")
    public ApiResponse getDictByType(@ApiParam(value="\u5b57\u5178\u7c7b\u578b\u67e5") @PathVariable String type) {
        return ApiResponse.success((Object)this.sysDictItemService.list((Wrapper)Wrappers.query().lambda().eq(SysDictItem::getType, (Object)type)));
    }

    @PostMapping
    @ApiOperation(value="\u6dfb\u52a0\u5b57\u5178", notes="\u6dfb\u52a0\u5b57\u5178")
    public ApiResponse save(@Valid @RequestBody @ApiParam(value="\u5f85\u4fdd\u5b58\u6570\u636e") SysDict sysDict) {
        return ApiResponse.success((Object)this.sysDictService.save(sysDict));
    }

    @GetMapping(value={"/item/page"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2", notes="\u5206\u9875\u67e5\u8be2")
    public ApiResponse getSysDictItemPage(@ApiParam(value="\u5206\u9875\u53c2\u6570") Page page, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") SysDictItem sysDictItem) {
        return ApiResponse.success((Object)this.sysDictItemService.page((IPage)page, (Wrapper)Wrappers.query((Object)sysDictItem)));
    }

    @GetMapping(value={"/item/{id}"})
    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2\u5b57\u5178\u9879", notes="\u901a\u8fc7id\u67e5\u8be2\u5b57\u5178\u9879")
    public ApiResponse getDictItemById(@ApiParam(value="id\u6570\u636e") @PathVariable(value="id") Integer id) {
        return ApiResponse.success((Object)this.sysDictItemService.getById(id));
    }

    @PostMapping(value={"/item"})
    @CacheEvict(value={"dict_details"}, allEntries=true)
    @ApiOperation(value="\u65b0\u589e\u5b57\u5178\u9879", notes="\u65b0\u589e\u5b57\u5178\u9879")
    public ApiResponse save(@ApiParam(value="\u5f85\u65b0\u589e\u6570\u636e\u9879") @RequestBody SysDictItem sysDictItem) {
        return ApiResponse.success((Object)this.sysDictItemService.save(sysDictItem));
    }

    @PostMapping(value={"/addDict"})
    @ApiOperation(value="\u5206\u5e03\u5f0f\u4e8b\u52a1-\u65b0\u589e\u5b57\u5178\u9879", notes="\u5206\u5e03\u5f0f\u4e8b\u52a1-\u65b0\u589e\u5b57\u5178\u9879")
    public void addDict(@ApiParam(value="\u5f85\u65b0\u589e\u6570\u636e\u9879") @RequestBody Dict dict) {
        this.dictService.addDict(dict);
    }

    public SysDictController(SysDictService sysDictService, SysDictItemService sysDictItemService, DictService dictService) {
        this.sysDictService = sysDictService;
        this.sysDictItemService = sysDictItemService;
        this.dictService = dictService;
    }
}

