/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.platform.cloud.business.subservice.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.jxdinfo.hussar.platform.cloud.business.subservice.api.dto.ProductDto;
import com.jxdinfo.hussar.platform.cloud.business.subservice.api.entity.Dict;
import com.jxdinfo.hussar.platform.cloud.business.subservice.api.entity.Product;
import com.jxdinfo.hussar.platform.cloud.business.subservice.mapper.ProductMapper;
import com.jxdinfo.hussar.platform.cloud.business.subservice.service.DictService;
import com.jxdinfo.hussar.platform.cloud.business.subservice.service.ProductService;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProductServiceImpl
extends HussarServiceImpl<ProductMapper, Product>
implements ProductService {
    @Autowired
    private DictService dictService;

    @Override
    @HussarDs(value="#connname")
    public List<Product> getProductListByConnName(String connname) {
        return this.list();
    }

    @Override
    public List<Product> getProductListNoConnName() {
        return this.list();
    }

    @Override
    @DSTransactional
    public void saveProduct(ProductDto productDto) {
        Product product = new Product();
        BeanUtil.copy((Object)productDto, (Object)product);
        this.save((BaseEntity)product);
        if (HussarUtils.isNotEmpty((Object)productDto) && productDto.getFlag() == 4) {
            throw new HussarException("product\u4fdd\u5b58\u6210\u529f\u4e4b\u540e\u629b\u51fa\u5f02\u5e38");
        }
        Dict dict = new Dict();
        dict.setDictName("seata");
        dict.setDictValue("product_value");
        this.dictService.save(dict);
        if (HussarUtils.isNotEmpty((Object)productDto) && productDto.getFlag() == 5) {
            throw new HussarException("\u5b57\u5178\u4fdd\u5b58\u6210\u529f\u4e4b\u540e\u629b\u51fa\u5f02\u5e38");
        }
    }

    @Override
    @HussarTransactional(propagation=Propagation.REQUIRES_NEW)
    public void dataSourceTest(ProductDto productDto) {
        Product product = (Product)this.getById(productDto.getId());
        if (HussarUtils.isEmpty((Object)product)) {
            product = new Product();
            product.setId(productDto.getId());
            product.setPrice(Double.valueOf(100.0));
            product.setProductName("hhh");
            this.save((BaseEntity)product);
            return;
        }
        Double price = product.getPrice() + 1.0;
        product.setPrice(price);
        this.updateById((BaseEntity)product);
        if (HussarUtils.isNotEmpty((Object)productDto) && productDto.getFlag() == 2) {
            this.removeById((BaseEntity)product);
            throw new HussarException("\u4fdd\u5b58\u6216\u66f4\u65b0produce\u540e\uff0c\u629b\u51fa\u5f02\u5e38");
        }
        Dict dict = new Dict();
        dict.setDictName("\u5206\u5e03\u5f0f\u4e8b\u52a1");
        dict.setDictValue("1111");
        this.dictService.addDict(dict);
        if (HussarUtils.isNotEmpty((Object)productDto) && productDto.getFlag() == 3) {
            throw new HussarException("\u4fdd\u5b58dict\u540e\uff0c\u629b\u51fa\u5f02\u5e38");
        }
    }

    @Override
    @Transactional
    public void transactionalTest(ProductDto productDto) {
        Product product = (Product)this.getById(productDto.getId());
        if (HussarUtils.isEmpty((Object)product)) {
            product = new Product();
            product.setId(productDto.getId());
            product.setPrice(Double.valueOf(100.0));
            product.setProductName("hhh");
            this.save((BaseEntity)product);
            return;
        }
        Double price = product.getPrice() + 1.0;
        product.setPrice(price);
        this.updateById((BaseEntity)product);
        if (HussarUtils.isNotEmpty((Object)productDto) && productDto.getFlag() == 2) {
            throw new HussarException("\u66f4\u65b0produce\u540e\uff0c\u629b\u51fa\u5f02\u5e38");
        }
        Dict dict = new Dict();
        dict.setDictName("\u5206\u5e03\u5f0f\u4e8b\u52a1");
        dict.setDictValue("1111");
        this.dictService.transactionalTest(dict);
        if (HussarUtils.isNotEmpty((Object)productDto) && productDto.getFlag() == 3) {
            throw new HussarException("\u4fdd\u5b58dict\u540e\uff0c\u629b\u51fa\u5f02\u5e38");
        }
    }
}

