/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.platform.cloud.business.subservice.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.cloud.business.subservice.api.entity.SysDict;
import com.jxdinfo.hussar.platform.cloud.business.subservice.api.entity.SysDictItem;
import com.jxdinfo.hussar.platform.cloud.business.subservice.service.SysDictItemService;
import com.jxdinfo.hussar.platform.cloud.business.subservice.service.SysDictService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import io.swagger.annotations.Api;
import javax.validation.Valid;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dict"})
@Api(value="dict", tags={"\u5b57\u5178\u7ba1\u7406\u6a21\u5757"})
public class SysDictController {
    private final SysDictService sysDictService;
    private final SysDictItemService sysDictItemService;

    @GetMapping(value={"/{id}"})
    public ApiResponse getById(@PathVariable(value="id") Long id) {
        return ApiResponse.success((Object)this.sysDictService.getById(id));
    }

    @GetMapping(value={"/page"})
    public ApiResponse<IPage> getDictPage(Page page, SysDict sysDict) {
        return ApiResponse.success((Object)this.sysDictService.page((IPage)page, (Wrapper)Wrappers.query((Object)sysDict)));
    }

    @GetMapping(value={"/type/{type}"})
    @Cacheable(value={"dict_details"}, key="#type", unless="#result.data.isEmpty()")
    public ApiResponse getDictByType(@PathVariable String type) {
        return ApiResponse.success((Object)this.sysDictItemService.list((Wrapper)Wrappers.query().lambda().eq(SysDictItem::getType, (Object)type)));
    }

    @PostMapping
    public ApiResponse save(@Valid @RequestBody SysDict sysDict) {
        return ApiResponse.success((Object)this.sysDictService.save(sysDict));
    }

    @GetMapping(value={"/item/page"})
    public ApiResponse getSysDictItemPage(Page page, SysDictItem sysDictItem) {
        return ApiResponse.success((Object)this.sysDictItemService.page((IPage)page, (Wrapper)Wrappers.query((Object)sysDictItem)));
    }

    @GetMapping(value={"/item/{id}"})
    public ApiResponse getDictItemById(@PathVariable(value="id") Integer id) {
        return ApiResponse.success((Object)this.sysDictItemService.getById(id));
    }

    @PostMapping(value={"/item"})
    @CacheEvict(value={"dict_details"}, allEntries=true)
    public ApiResponse save(@RequestBody SysDictItem sysDictItem) {
        return ApiResponse.success((Object)this.sysDictItemService.save(sysDictItem));
    }

    public SysDictController(SysDictService sysDictService, SysDictItemService sysDictItemService) {
        this.sysDictService = sysDictService;
        this.sysDictItemService = sysDictItemService;
    }
}

