/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.platform.cloud.business.subservice.service.impl;

import com.jxdinfo.hussar.platform.cloud.business.subservice.api.entity.Dict;
import com.jxdinfo.hussar.platform.cloud.business.subservice.api.entity.Product;
import com.jxdinfo.hussar.platform.cloud.business.subservice.mapper.DictMapper;
import com.jxdinfo.hussar.platform.cloud.business.subservice.service.DictService;
import com.jxdinfo.hussar.platform.cloud.business.subservice.service.ProductService;
import com.jxdinfo.hussar.platform.cloud.business.system.api.entity.Account;
import com.jxdinfo.hussar.platform.cloud.business.system.api.feign.RemoteAccountService;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@HussarDs(value="slave_2")
public class DictServiceImpl
extends HussarServiceImpl<DictMapper, Dict>
implements DictService {
    @Autowired
    ProductService productService;
    @Resource
    RemoteAccountService remoteAccountService;

    @Override
    @HussarDs(value="#connname")
    public List<Dict> getDictListByConnName(String connname) {
        return this.list();
    }

    @Override
    public List<Dict> getDictListNoConnName() {
        return this.list();
    }

    @Override
    public List<Dict> getDictListToProductNoConname() {
        List<Product> productList = this.productService.getProductListNoConnName();
        for (Product p : productList) {
            System.out.println(p.getPrice());
        }
        return this.list();
    }

    @Override
    @HussarDs(value="#connname")
    public List<Dict> getDictListToProductByConname(String connname) {
        List<Product> productList = this.productService.getProductListByConnName(connname);
        for (Product p : productList) {
            System.out.println(p.getPrice());
        }
        return this.list();
    }

    @Override
    @HussarTransactional(propagation=Propagation.NOT_SUPPORTED)
    public void addDict(Dict dict) {
        this.save((BaseEntity)dict);
        Account account = new Account();
        account.setName("\u5206\u5e03\u5f0f\u4e8b\u52a1");
        this.remoteAccountService.saveAccount(account);
    }

    @Override
    @Transactional
    public void transactionalTest(Dict dict) {
        this.save((BaseEntity)dict);
    }
}

